const float PI = 3.141592;
const float rPI = 1.0 / PI;
const float hPI = PI * 0.5;
const float TAU = PI * 2.0;
const float rTAU = 1.0 / TAU;
const float hTAU = TAU * 0.5;

const float PHI = sqrt(5.0) * 0.5 + 0.5;
const float LOG2 = log(2.0);
const float rLOG2	= 1.0 / LOG2;

const float goldenAngle = TAU / PHI / PHI;

#define clamp01(x) clamp(x, 0.0, 1.0)
#define max0(x) max(x, 0.0)
#define max1(x) max(x, 1.0)
#define rcp(x) (1.0 / x)

float sumOf(vec2 x){return x.x + x.y;}

#define fsign(x) (clamp01(x * 1e35) * 2.0 - 1.0)
#define fstep(x,y) clamp01((y - x) * 1e35)

#define lum0 vec3(0.2989, 0.5866, 0.1145)
#define lum1 vec3(0.2126, 0.7152, 0.0722)

#define curve(x) x * x * (3.0 - 2.0 * x)

#define renderTex(x)  texelFetch2D(x, ivec2(gl_FragCoord.xy), 0)

#include "/settings/time.glsl"
#include "/program/utility/pow.glsl"
#include "/program/utility/noise.glsl"
#include "/program/utility/encode.glsl"
#include "/program/utility/position.glsl"
#include "/program/utility/bicubic.glsl"

#if defined deferred2 || defined deferred3 || defined composite0
#include "/program/utility/diffuseOperator.glsl"
#endif

float max3(vec3 x){
  return max(x.x, max(x.y, x.z));
}

float toGamma(float x){
  return mix(pow(x / 1.055 + (0.055 / 1.055), 2.4), x / 12.92, fstep(x, 0.04045));
}

vec3 toGamma(vec3 x){
  return mix(pow(x / 1.055 + (0.055 / 1.055), vec3(2.4)), x / 12.92, fstep(x, vec3(0.04045)));
}

vec3 toLinear(vec3 x){
  return mix(1.055 * pow(x, vec3(1 / 2.4)) - 0.055, x * 12.92, fstep(x, vec3(0.0031308)));
}

float renderLuminance601(vec3 x){
	return dot(x, lum0);
}

float renderLuminance701(vec3 x){
	return dot(x, lum1);
}

float linearDepth(float depth) {
  return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float fLength(vec2 x){
  return sqrt(dot(x, x));
}

vec4 ToSH(float value, vec3 dir) {
  float transferl1 = 0.3849 * PI;
  float sqrt1OverPI = sqrt(rPI);
  float sqrt3OverPI = sqrt(rPI * 3.0);

  vec2 halfnhalf = vec2(0.5, -0.5);
  vec2 transfer = vec2(PI * sqrt1OverPI, transferl1 * sqrt3OverPI);

  vec4 foo = halfnhalf.xyxy * transfer.xyyy;

  return foo * vec4(1.0, dir.yzx) * value;
}

vec3 FromSH(vec4 cR, vec4 cG, vec4 cB, vec3 lightDir) {
  float sqrt1OverPI = sqrt(rPI);
  float sqrt3OverPI = sqrt(3.0 * rPI);

  vec2 halfnhalf = vec2(0.5, -0.5);
  vec2 sqrtOverPI = vec2(sqrt1OverPI, sqrt3OverPI);
  vec4 foo = halfnhalf.xyxy * sqrtOverPI.xyyy;

  vec4 sh = foo * vec4(1.0, lightDir.yzx);

  return vec3(dot(sh,cR),
        		  dot(sh,cG),
        			dot(sh,cB));
}

vec3 blackbody(float Temp){
    float t = pow(Temp, -1.5);
    float lt = log(Temp);

    vec3 col = vec3(0.0);
         col.x = 220000.0 * t + 0.58039215686;
         col.y = 0.39231372549 * lt - 2.44549019608;
         col.y = Temp > 6500. ? 138039.215686 * t + 0.72156862745 : col.y;
         col.z = 0.76078431372 * lt - 5.68078431373;
         col = clamp01(col);
         col = Temp < 1000. ? col * Temp * 0.001 : col;

    return toGamma(col);
}

vec2 sincos(float x){
    return vec2(sin(x), cos(x));
}

vec2 circlemap(float i, float n){
	return sincos(i * n * goldenAngle) * sqrt(i);
}

vec3 circlemapL(float i, float n){
	return vec3(sincos(i * n * goldenAngle), sqrt(i));
}

vec2 rotate(vec2 vector, float r) {
    float c = cos(r), s = sin(r);
    return vector * mat2(c, -s, s, c);
}

vec3 renderProjectSky(vec2 coord) {
  coord *= vec2(TAU, PI);

  vec2 lon = sincos(coord.x) * sin(coord.y);
  return vec3(lon.x, cos(coord.y), lon.y);
}

vec2 renderUnprojectSky(vec3 dir) {
  vec2 lonlat = vec2(atan(-dir.x, dir.z), acos(dir.y));
  return lonlat * vec2(rTAU, rPI) + vec2(0.501, 0.0);
}

mat3 renderRotMat(vec3 x,vec3 y){
   float d = dot(x,y);
   vec3 cr = cross(y,x);

   float s = length(cr);

   float id = 1.-d;

   vec3 m = cr/s;

   vec3 m2 = m*m*id+d;
   vec3 sm = s*m;

   vec3 w = (m.xy*id).xxy*m.yzz;

   return mat3(
	   m2.x,     w.x-sm.z, w.y+sm.y,
	   w.x+sm.z, m2.y,     w.z-sm.x,
	   w.y-sm.y, w.z+sm.x, m2.z
   );
}

vec3 renderCloudsCurvature(vec3 position){
  float planetRadius = 6371e3;
  return vec3(position.x, length(position + vec3(0, planetRadius, 0)) - planetRadius, position.z);
}

