#define diagonal2(m) vec2((m)[0].x, (m)[1].y)
#define diagonal3(m) vec3(diagonal2(m), m[2].z)
#define diagonal4(m) vec4(diagonal3(m), m[2].w)

#define transMAD(mat, v) (mat3(mat) * (v) + (mat)[3].xyz)
#define projMAD(mat, v) (diagonal3(mat) * (v) + (mat)[3].xyz)

const float shadowResolution = shadowMapResolution * MC_SHADOW_QUALITY;
const float rShadowMapResolution = 1.0 / shadowResolution;

//Halton Sequence from pissang
//https://github.com/pissang/claygl-advanced-renderer/blob/master/src/halton.js

float renderHaltonSequence(int i){
  float result = 0.0;
  float f = 1.0;

  while(i > 0){
    result = result + f * (i % 2);
    i = int(i / 2);
    f = f / 2;
  }

  return result;
}

vec2 renderTemporalJitter() {
  #ifdef TEMPORAL_AA
  return vec2(renderHaltonSequence(frameCounter % 16)) / pixel;
  #else
  return vec2(0.0);
  #endif
}

vec2 jitter = renderTemporalJitter();

vec3 renderViewPosition(vec2 coord, float depth){
  coord -= jitter * 0.5;
  vec3 view = vec3(coord, depth) * 2.0 - 1.0;
  return projMAD(gbufferProjectionInverse, view) / (view.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
}

vec3 renderViewPosition(vec3 coord){
  vec3 view = coord * 2.0 - 1.0;
  return projMAD(gbufferProjectionInverse, view) / (view.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
}

vec3 renderWorldPosition(vec3 view){
  return transMAD(gbufferModelViewInverse, view);
}

vec3 renderScreenPosition(vec3 view){
  return ((projMAD(gbufferProjection, view) / -view.z )* 0.5 + 0.5) + vec3(jitter * 0.5, 0.0);
}

vec2 renderVelocity(vec3 screenPos) {
  vec3 projection = (cameraPosition - previousCameraPosition) + renderWorldPosition(renderViewPosition(screenPos));
		   projection = transMAD(gbufferPreviousModelView, projection);
       projection = (projMAD(gbufferPreviousProjection, projection) / -projection.z) * 0.5 + 0.5;

  return (screenPos.xy - projection.xy);
}

vec3 renderShadowPosition(vec3 position){
  vec3 shadowPosition = transMAD(shadowModelView, position);
       shadowPosition = projMAD(shadowProjection, shadowPosition);

  return shadowPosition;
}

float renderShadowDistort(vec2 position){
  return length(position * 1.169) * SHADOW_DISTORTION + (1.0 - SHADOW_DISTORTION);
}

vec2 renderShadowDistortPosition(vec2 position){
  return position / renderShadowDistort(position);
}

vec3 renderShadowDistortPosition(vec3 position){
  return vec3(renderShadowDistortPosition(position.xy), position.z * 0.25);
}
