const int noiseTextureResolution = 64;
const float rNoiseTexRes = 1.0 / noiseTextureResolution;

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) (bayer64(.5*(a))*.25+bayer2(a))

#define dither2(p)   (bayer2(  p) - 0.375      )
#define dither4(p)   (bayer4(  p) - 0.46875    )
#define dither8(p)   (bayer8(  p) - 0.4921875  )
#define dither16(p)  (bayer16( p) - 0.498046875)
#define dither32(p)  (bayer32( p) - 0.499511719)
#define dither64(p)  (bayer64( p) - 0.49987793 )
#define dither128(p) (bayer128(p) - 0.499969482)

#define HASHSCALE1 443.8975
#define HASHSCALE3 vec3(443.897, 441.423, 437.195)
#define HASHSCALE4 vec3(443.897, 441.423, 437.195, 444.129)

vec2 hash( vec2 p ) {
	p = vec2(dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)));
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float hash12(vec2 p){
	vec3 p3  = fract(vec3(p.xyx) * HASHSCALE3);
       p3 += dot(p3, p3.yzx + 19.19);
  return fract((p3.x + p3.y) * p3.z);
}

float hash13(vec3 p3){
	  p3 = fract(p3 * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

float hash13(float p){

	vec3 p3 = fract(vec3(p) * HASHSCALE1);
       p3 += dot(p3, p3.yzx + 19.19);
  return fract((p3.x + p3.y) * p3.z);
}

vec3 hash33(vec3 p){
    p = fract(p * HASHSCALE3);
    p += dot(p.zxy, p.yxz + 19.19);
    return fract(vec3(p.x * p.y, p.z * p.x, p.y * p.z));
}

float renderBlueNoise(vec2 coord){
	vec2 noiseCoord = vec2(coord.st * pixel) / 64.0;
       noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));
	     noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	return texture2DLod(noisetex, noiseCoord.st, 0).b;
}

vec3 render2DNoise(vec2 p){
  return texture2D(noisetex, fract(p)).xyz;
}

vec3 render2DNoiseSmooth(vec2 p){
  //p *= noiseTextureResolution;

  vec2 id = floor(p) * rNoiseTexRes;
  vec2 f = fract(p);
       f = curve(f);

  float a = texture2D(noisetex, id).x;
  float b = texture2D(noisetex, id + vec2(1.0, 0.0) * rNoiseTexRes).x;
  float c = texture2D(noisetex, id + vec2(0.0, 1.0) * rNoiseTexRes).x;
  float d = texture2D(noisetex, id + vec2(1.0, 1.0) * rNoiseTexRes).x;

  float x1 = mix(a, b, f.x);
  float x2 = mix(c, d, f.x);

  return vec3(x1, x2, f.y);
}

float render3DNoise(vec3 pos){
  float p = floor(pos.z);
  float f = pos.z - p;
        f = curve(f);

  float zStretch = 15.0 * rNoiseTexRes;

  vec2 ncoord = (pos.xy * rNoiseTexRes + (p * zStretch));

  float noise0 = texture2D(noisetex, ncoord).x;
  float noise1 = texture2D(noisetex, ncoord + zStretch).x;

  return mix(noise0, noise1, f);
}

float renderFBM(vec2 position, vec2 movement){
  position /= noiseTextureResolution;
  movement *= 0.0000045;

  float noise = 0.5 * texture2D(noisetex, position).x;
        noise += 0.25 * texture2D(noisetex, position * 2.0 + movement).x;
        noise += 0.125 * texture2D(noisetex, position * 7.0 - movement).x;
        noise += 0.0625 * texture2D(noisetex, (position + movement) * 16.0).x;
        noise += 0.0525 * texture2D(noisetex, (position - movement) * 32.0).x;

  return noise;
}

float renderVolumeFBM(vec3 position, vec3 movement){
  float noise = render3DNoise(position) * 0.5;
        noise += render3DNoise(position * 2.0 + movement) * 0.15;
        noise += render3DNoise(position * 7.0 - movement) * 0.125;
        noise += render3DNoise((position + movement) * 16.0) * 0.0625;
        //noise += render3DNoise((position - movement) * 32.0) * 0.0525;

  return curve(noise);
}