float renderLambertDiffuse(vec3 n, vec3 l){
	return clamp01(dot(n, l));
}

float SchlickFresnel(float f0, float f90, float LoH) {
    return (f90 - f0) * pow5(1 - LoH) + f0;
}

vec3 ExactFresnel(const vec3 n, const vec3 k, float c) {
    const vec3 k2= k * k;
	const vec3 n2k2 = n * n + k2;

    vec3 c2n = (c * 2) * n;
    vec3 c2 = vec3(c * c);

    vec3 rs_num = n2k2 - c2n + c2;
    vec3 rs_den = n2k2 + c2n + c2;

    vec3 rs = rs_num / rs_den;

    vec3 rp_num = n2k2 * c2 - c2n + 1;
    vec3 rp_den = n2k2 * c2 + c2n + 1;

    vec3 rp = rp_num / rp_den;

    return clamp01(0.5 * (rs + rp));
}

//Based on the Lab PBR Wiki
//https://github.com/rre36/lab-pbr/wiki/Specular-Texture-Details

vec3 renderFresnel(float f0, float f90, float VdotN){
	#if SPEC_FORMAT == 0
	int ID = int(f0 * 255);

	if(ID == 230) return ExactFresnel(vec3(2.9114, 2.9497, 2.5845), vec3(3.0893, 2.9318, 2.7670), VdotN); 							//Iron
	else if(ID == 231) return ExactFresnel(vec3(0.18299, 0.42108, 1.3734), vec3(3.4242, 2.3459, 1.7704), VdotN);					//Gold
	else if(ID == 232) return ExactFresnel(vec3(1.3456, 0.96521, 0.61722), vec3(7.4746, 6.3995, 5.3031), VdotN);					//Aluminium
	else if(ID == 233) return ExactFresnel(vec3(3.1071, 3.1812, 2.3230), vec3(3.3314, 3.3291, 3.1350), VdotN);						//Chrome
	else if(ID == 234) return ExactFresnel(vec3(0.27105, 0.67693, 1.3164), vec3(3.6092, 2.6248, 2.2921), VdotN);					//Copper
	else if(ID == 235) return ExactFresnel(vec3(1.9100, 1.8300, 1.4400), vec3(3.5100, 3.4000, 3.1800), VdotN);						//Lead
	else if(ID == 236) return ExactFresnel(vec3(2.3757, 2.0847, 1.8453), vec3(4.2655, 3.7153, 3.1365), VdotN);						//Platinum
	else if(ID == 237) return ExactFresnel(vec3(0.15943, 0.14512, 0.13547), vec3(3.9291, 3.1900, 2.3808), VdotN);					//Silver
	#else 
	if(f0 > 45) return ExactFresnel(vec3(2.9114, 2.9497, 2.5845), vec3(3.0893, 2.9318, 2.7670), VdotN); 							//Iron
	else if(f0 > 965) return ExactFresnel(vec3(0.18299, 0.42108, 1.3734), vec3(3.4242, 2.3459, 1.7704), VdotN);						//Gold
	#endif

	return vec3(SchlickFresnel(f0, 1, VdotN));
}

float ExactCorrelatedG2(float alpha2, float NoV, float NoL) {
    float x = 2 * NoL * NoV;
    float y = 1 - alpha2;

    return x / (NoV * sqrt(alpha2 + y * (NoL * NoL)) + NoL * sqrt(alpha2 + y * (NoV * NoV)));
}

float GGX(float alpha2, float NoH) {
	float d = (NoH * alpha2 - NoH) * NoH + 1;

	return alpha2 / (d * d);
}

float renderDiffuseGGX(vec3 normal, vec3 vector, vec3 lightVector, float roughness){
	float NdotL = clamp01(dot(normal, lightVector));
	float NdotV = clamp01(dot(normal, -vector));

	float K = pow2(roughness + 1) * 0.125;
	float M = 0.1159 * roughness;

	float denom = NdotL / (NdotL * (1 - K) + K);

	return (M * NdotL + denom) * rPI;
}

float renderSpecularGGX(vec3 normal, vec3 lightVector, vec3 viewVector, float f0, float roughness){
	vec3 H = normalize(lightVector - viewVector);

	float NdotL = clamp01(dot(normal, lightVector));
	float LdotH = clamp01(dot(H, lightVector));
	float NdotH = clamp01(dot(H, normal));
	float NdotV = clamp01(dot(normal, -viewVector));
	
	float D = GGX(roughness, NdotH);
	float F = SchlickFresnel(f0, 1, LdotH);
	float vis = 0.25 * roughness;

	return NdotL * D * F / (pow2(LdotH) * (1 - vis) + vis);
}

vec3 renderBlendMaterial(vec3 Kdiff, vec3 Kspec, vec3 diffuseColor, float f0) {
	if(f0 < 0.004) return Kdiff;

	float scRange = smoothstep(0.25, 0.45, f0);

	vec3 dielectric = Kspec + Kdiff;
	vec3 metal = diffuseColor * Kspec;

	return mix(dielectric, metal, scRange);
}
