vec4 cubic(float x){
  float x2 = x * x;
  float x3 = x2 * x;

  vec4 w;
       w.x = -x3 + 3 * x2 - 3 * x + 1;
       w.y = 3 * x3 - 6 * x2 + 4;
       w.z = -3 * x3 + 3 * x2 + 3 * x + 1;
       w.w = x3;

  return w / 6.0;
}

vec4 bicubicTexture(sampler2D sampler, vec2 coord){
  coord *= pixel;

  vec2 f = vec2(fract(coord.x), fract(coord.y));

  coord -= f;

  f -= 0.5;

  vec4 cubicX = cubic(f.x);
  vec4 cubicY = cubic(f.y);

  vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
  vec4 s = vec4(cubicX.x + cubicX.y, cubicX.z + cubicX.w, cubicY.z + cubicY.y, cubicY.z + cubicY.w);
  vec4 offset = c + vec4(cubicX.y, cubicX.w, cubicY.y, cubicY.w) / s;

  vec4 tex0 = texture2D(sampler, vec2(offset.x, offset.z) * rPixel);
  vec4 tex1 = texture2D(sampler, vec2(offset.y, offset.z) * rPixel);
  vec4 tex2 = texture2D(sampler, vec2(offset.x, offset.w) * rPixel);
  vec4 tex3 = texture2D(sampler, vec2(offset.y, offset.w) * rPixel);

  float sx = s.x / (s.x + s.y);
  float sy = s.z / (s.z + s.w);

  return mix(mix(tex3, tex2, sx), mix(tex1, tex0, sy), sy);
}
