out vec2 coord;

out vec3 sunVector, moonVector, lightVector, upVector;
out vec3 worldSunVector, worldMoonVector, worldLightVector, worldUpVector;
out vec3 sunlight, moonlight, skylight, weatherSkylight, torchlight;

out float sunRise, sunNoon, sunSet, dayTime;
out float moonRise, moonNoon, moonSet, moonTime;

out float ambientFog;
out float transitionFading;
out float dynamicWeather;

out mat4 shadowMatrix;
out mat3x4 skySH;

#include "/program/light/common/atmosphere/atmosphericScattering.glsl"

void renderSkylight(out vec3 skylight, vec3 sunVector, vec3 moonVector, vec3 upVector){
  const int latSamples = 5;
	const int lonSamples = 5;

	const float rLatSamples = 1.0 / latSamples;
	const float rLonSamples = 1.0 / lonSamples;
	const float sampleCount = rLatSamples * rLonSamples;

	float latitudeSize = rLatSamples * PI;
	float longitudeSize = rLonSamples * TAU;

  vec4 shR = vec4(0.0), shG = vec4(0.0), shB = vec4(0.0);

  for (int i = 0; i < latSamples; ++i) {
		float latitude = float(i) * latitudeSize;

		for (int j = 0; j < lonSamples; ++j) {
			float longitude = float(j) * longitudeSize;

			float c = cos(latitude);
			vec3 kernel = vec3(c * cos(longitude), sin(latitude), c * sin(longitude));
           kernel = normalize(kernel + worldUpVector * 0.1);

      skylight = renderAtmosphericScattering(kernel, sunVector, moonVector, upVector, 8);

      shR += ToSH(skylight.r, kernel);
			shG += ToSH(skylight.g, kernel);
			shB += ToSH(skylight.b, kernel);
    }
  }
  skySH = mat3x4(shR, shG, shB) * sampleCount;
}

float renderDynamicWeather(){
  float phase = moonPhase + 1;
  if(float(moonPhase) == 7) phase = 0;

  float phaseSmooth = mix(moonPhase, phase, float(worldTime) / 24e3);

  return (((abs(phaseSmooth - 2) + 1) / 5) + 0.5);
}

vec3 renderDesaturation(vec3 color){
  return mix(color, dot(color, vec3(1)) * vec3(0.2, 0.4, 0.9), vec3(0.75));
}

void main(){
  coord = gl_Vertex.xy;
  gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);

  #if defined deferred1
  gl_Position.xy = (gl_Position.xy * 0.5 + 0.5) * clamp01(VOLUME_CLOUDS_QUALITY + 0.01) * 2 - 1;
  #endif

  sunVector = sunPosition * 0.01;
  moonVector = -sunVector;
  lightVector = shadowLightPosition * 0.01;
  upVector = upPosition * 0.01;

  worldSunVector = mat3(gbufferModelViewInverse) * sunVector;
  worldMoonVector = mat3(gbufferModelViewInverse) * moonVector;
  worldLightVector = mat3(gbufferModelViewInverse) * lightVector;
  worldUpVector = mat3(gbufferModelViewInverse) * upVector;

  shadowMatrix = shadowProjection * shadowModelView;

  torchlight = blackbody(TORCHLIGHT_TEMP) * 32 * TORCHLIGHT_BRIGHTNESS;

  sunlight = phase_reyleigh(1) * phase_mie(1, 0.86) * renderTransmittance(vec3(0.0, earthSize, 0.0), worldSunVector, 8) * sunLux;
  moonlight = renderDesaturation(renderTransmittance(vec3(0.0, earthSize, 0.0), worldMoonVector, 8)) * moonLux;

  skylight = vec3(0);
  renderSkylight(skylight, worldSunVector, worldMoonVector, worldUpVector);
  weatherSkylight = mix(skylight, vec3(renderLuminance701(skylight)), vec3(wetness));

  sunRise = pow4(clamp01(dot(worldSunVector, vec3(1.0, 0.0, 0.0))));
  sunNoon = pow4(clamp01(dot(worldSunVector, vec3(0.0, 1.0, 0.0))));
  sunSet = pow4(clamp01(dot(worldSunVector, vec3(0.0, 0.0, 1.0))));

  moonRise = pow4(clamp01(dot(worldMoonVector, vec3(1.0, 0.0, 0.0))));
  moonNoon = pow4(clamp01(dot(worldMoonVector, vec3(0.0, 1.0, 0.0))));
  moonSet = pow4(clamp01(dot(worldMoonVector, vec3(0.0, 0.0, 1.0))));

  dayTime = sunRise + sunNoon + sunSet;
  moonTime = moonRise + moonNoon + moonSet;

  ambientFog = mix(0.0, 1.0, pow8(eyeBrightnessSmooth.y / 240.0));
  transitionFading = clamp01(clamp01(float(worldTime - 23215) / 50.0) + (1.0 - clamp01(float(worldTime - 12735) / 50.0)) + clamp01(float(worldTime - 12925) / 50.0) * (1.0 - clamp01(float(worldTime - 23075) / 50.0)));
  dynamicWeather = renderDynamicWeather();
}
