vec3 renderRoughSpecular(const float i, const float alpha2, const int steps) {
  float x = (alpha2 * i) / (1 - i);
  float y = i * steps * pow2(64) * goldenAngle;

  float c = inversesqrt(x + 1);
  float s = sqrt(x) * c;

  return vec3(cos(y) * s, sin(y) * s, c);
}

vec3 renderRoughnessReflection(vec3 color, DataBuffer data, Material material){  
  reflectionSettings r = renderReflectionSettings();

  data.f0 = toGamma(data.f0);

  float alpha = pow4(data.roughness);
  float diffuse = clamp01(dot(data.worldNormal, worldLightVector));

  vec3 shadow = renderShadow(diffuse, data.worldPosition[0], data.dither, true);
  #ifdef CLOUD_SHADOW
       shadow *= renderCloudShadow(data.worldPosition[1] + cameraPosition, worldLightVector, 1);
  #endif

  vec3 c0 = cross(data.normal, vec3(0.0, 0.0, 1.0));
  vec3 c1 = cross(data.normal, vec3(0.0, 1.0, 0.0));

  vec3 tangent = length(c0) > length(c1) ? c0 : c1;
  mat3 tbn = mat3(tangent, cross(data.normal, tangent), data.normal);

  vec3 fresnel, reflection;
  vec3 vector, worldVector;

  float VdotN, NdotV, VdotL;

  for(int i = 0; i < r.steps1; ++i){
    vec3 sampleOffset = tbn * renderRoughSpecular((float(i) + data.dither) / r.steps1, alpha, r.steps1);
    if(length(sampleOffset) <= 0) continue;

    renderReflectionVector(data, sampleOffset, vector, worldVector, VdotN, NdotV, VdotL, true);

    float g = ExactCorrelatedG2(alpha, VdotN, NdotV);

    fresnel += renderFresnel(data.f0, 1, VdotN);
    reflection += renderSSR(r, data, material, data.position[0], vector, worldVector, NdotV, data.dither, data.depth.x) * g;
  }

  fresnel /= r.steps1;
  reflection /= r.steps1;
  reflection += renderSpecularGGX(data.normal, lightVector, data.vector[0], data.f0, alpha) * fresnel * shadow * (sunlight + moonlight) * 0.05;

  return renderBlendMaterial(color * (1.0 - fresnel), reflection * fresnel, data.color, data.f0);
}
