vec3 renderAtmosphere(vec3 worldVector, float lightmap){
  	vec2 atmosphereCoord = renderUnprojectSky(worldVector) * 0.5;

	float transmittance = 1;

	vec3 sky = texture2D(colortex3, atmosphereCoord).rgb;
		 //sky = renderPlanarClouds(sky, worldVector, worldLightVector, transmittance);
    	 //sky = sky + texture2D(colortex7, worldVector.xy * VOLUME_CLOUDS_QUALITY).a * texture2D(colortex7, worldVector.xy * VOLUME_CLOUDS_QUALITY).rgb;

	return isEyeInWater > 0.5 ? vec3(0) : sky;
}

vec3 renderColor(DataBuffer data, Material material, vec2 coord){
	return DecodeRGBE8(texture2D(colortex1, coord));
}

vec3 renderSSR(reflectionSettings r, DataBuffer data, Material material, vec3 position, vec3 vector, vec3 worldVector, float NdotV, float dither, float depth){
	vec3 viewPosition = vec3(coord, depth);
	vec3 direction = normalize(renderScreenPosition(position + vector) - viewPosition);
	vec3 atmosphere = renderAtmosphere(worldVector, data.lightmap.y);
	
	float maxLength = 1.0 / r.steps0;
	float minLength = 0.1 / r.steps0;

	float sampleLength = mix(minLength, maxLength, NdotV) * (dither + 1);
	float sampleWeight = 1.0 / abs(direction.z);

	viewPosition += direction * sampleLength;

	depth = renderDepth(viewPosition.xy).y;

	for(int i = 0; i < r.steps0; ++i, viewPosition += direction * sampleLength){
		sampleLength = clamp((depth - viewPosition.z) * sampleWeight, minLength, maxLength);
		depth = renderDepth(viewPosition.xy).y;

		if(clamp01(viewPosition.xy) != viewPosition.xy) return atmosphere;
		if(depth <= viewPosition.z) break;
	}

	while(--r.refinements > 0){
		vec3 reflectedPosition = viewPosition + direction * clamp((depth - viewPosition.z) * sampleWeight, -sampleLength, sampleLength);
		float reflectedDepth = renderDepth(reflectedPosition.xy).y;

		if(reflectedDepth < reflectedPosition.z) viewPosition = reflectedPosition; depth = reflectedDepth; break;
		sampleLength *= 0.5;
	}
	
	if(depth >= 1) return atmosphere;

 	return abs(viewPosition.z - depth) * min(sampleWeight, 400) < maxLength && 0.95 < depth ? renderColor(data, material, viewPosition.xy) : atmosphere;
}