vec3 renderWaterTransmittance(vec2 depth, float waterMask){
  float surface0 = (depth.x * 8 - 4) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
  float surface1 = (depth.y * 8 - 4) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;

  float shadowDepth = (surface1 - surface0);
  float sampleDepth = (mix(0.0, shadowDepth, waterMask));

  float density = 0.045;
        density *= WATER_DENSITY;
  
  vec3 waterScatterCoefficient = toGamma(vec3(15.0 * WATER_COLOR_R, 175.0* WATER_COLOR_G, 255.0 * WATER_COLOR_B) / 255.0) * density;
  vec3 waterAbsorptionCoefficient = -log(toGamma(vec3(10.0, 95.0, 150.0) / 255.0)) * density;

  return exp2((waterAbsorptionCoefficient + waterScatterCoefficient) * sampleDepth * rLOG2);
}

vec3 renderWaterCaustics(vec2 depth, vec3 worldPosition, float waterMask, float ditherOffset){
  const int steps = 4;
  const float rSteps = 1.0 / steps;

  float surface0 = (depth.x * 4.0 - 2.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
  float surface1 = (depth.y * 4.0 - 2.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;

  float shadowDepth = (surface1 - surface0);
  float waterDepth = mix(0.0, shadowDepth, waterMask);

  if(waterDepth <= 0.0) return vec3(1.0);

  vec3 sampleRefract = refract(-worldLightVector, worldUpVector, 0.25);
  vec3 sampleRefractVector = sampleRefract * waterDepth / sampleRefract.z;

  vec3 caustics = vec3(0.0);

  for(float i = -steps; i <= steps; ++i){
    for(float j = -steps; j <= steps; ++j){
      mat2 rotation = mat2(cos(ditherOffset), -sin(ditherOffset), sin(ditherOffset), cos(ditherOffset));
      vec2 offset = worldPosition.xy + vec2(i, j) * rotation * rSteps;

      vec3 samplePosition = renderShadowPosition(worldPosition);
           samplePosition.xy = renderShadowDistortPosition(samplePosition.xy * 2.0 - 1.0) * 0.5 + 0.5;

      vec3 normal = texture2D(shadowcolor1, samplePosition.xy).xyz * 2.0 - 1.0;
      vec3 refractVector = refract(-worldLightVector, normal, 0.25);
      vec3 refractPosition = refractVector * refractVector.y + vec3(offset, 0.0);

      caustics += clamp01(distance(worldPosition, refractPosition));
    }
  }
  return pow(caustics, vec3(1.5)) * rSteps;
}

vec3 renderShadow(float NdotL, vec3 worldPosition, float dither, bool reflection){
  const float steps = 1;
  const float rSteps = 1.0 / steps;

  float ditherOffset = dither * dither + 0.5;

  vec3 shadowPosition = renderShadowPosition(worldPosition);
  vec3 outPosition = renderShadowDistortPosition(shadowPosition) * 0.5 + 0.5;
  vec3 shadowFlatNormal = mat3(shadowModelView) * clamp(normalize(cross(dFdx(worldPosition), dFdy(worldPosition))), -1, 1);

  if(any(greaterThanEqual(abs(outPosition), vec3(1)))) return vec3(1);
  if(NdotL >= 0.5) return vec3(1);

  float maxSpread = 5;  
  float angle = maxSpread * 4;

  vec3 shadow = vec3(0);
  float penumbra = 0;

  float weight = 0;
  float penumbraWeight = 0;

  float bias = sqrt(sqrt(1 - NdotL * NdotL) / NdotL) * rShadowMapResolution;
        bias = bias * (length(shadowPosition.xy) * renderShadowDistort(shadowPosition.xy * 2 - 1) + 1) * 0.25;

   for(float i = -steps; i <= steps; ++i){
    for(float j = -steps; j <= steps; ++j){      
      vec3 samplePosition = vec3(vec2(i, j), -bias) * (maxSpread * rShadowMapResolution) + shadowPosition;
           samplePosition = renderShadowDistortPosition(samplePosition) * 0.5 + 0.5;
        
      penumbra = max(penumbra, (samplePosition.z - bias) - texture2DLod(shadowtex1, samplePosition.xy, steps).x);
      ++penumbraWeight;
    }
  }
  
  penumbra /= clamp01(1 - penumbraWeight) + penumbraWeight;
  penumbra = min(penumbra * angle, maxSpread); 

  for(float i = -steps; i <= steps; ++i){
    for(float j = -steps; j <= steps; ++j){
      mat2 rotation = mat2(cos(goldenAngle), -sin(goldenAngle), sin(goldenAngle), cos(goldenAngle));
      vec2 sampleOffset = vec2(i, j) * (dither * rotation);

      #if SHADOW_TYPE == 1
      float softness = penumbra * rShadowMapResolution * (shadowResolution * 0.025);
      #else
      float softness = rShadowMapResolution * 0.45;
      #endif

      vec3 samplePosition = vec3(sampleOffset, -bias) * softness + shadowPosition;
           samplePosition = renderShadowDistortPosition(samplePosition) * 0.5 + 0.5;

      vec2 depth = vec2(texture2DLod(shadowtex0, samplePosition.xy, 0).x, texture2DLod(shadowtex1, samplePosition.xy, 0).x);

      vec4 color0 = texture2DLod(shadowcolor0, samplePosition.xy, 0);
      vec4 color1 = texture2DLod(shadowcolor1, samplePosition.xy, 0);

      vec3 shadowNormal = color1.xyz * 2.0 - 1.0;

      bias = (depth.x == depth.y) ? (dot(shadowNormal, shadowFlatNormal) > 0.1 ? bias : bias * 0.5) : bias;

      float shadow0 = depth.x > samplePosition.z - bias ? 1 : 0;
      float shadow1 = depth.y > samplePosition.z - bias ? 1 : 0;

      vec3 waterTransmittance = renderWaterTransmittance(depth, color0.a);
           //waterTransmittance *= renderWaterCaustics(depth, worldPosition, color0.a, ditherOffset);

      if(reflection){
        shadow += shadow1;
      } else {
        #ifdef COLOR_SHADOW
        shadow += mix(vec3(shadow0), color0.xyz, clamp01(shadow1 - shadow0)) * waterTransmittance;
        #else
        shadow += shadow1 * waterTransmittance;
        #endif
      }
      ++weight;
    }
  }
	
	return shadow / weight;
}