struct giSettings{
    float scale;
    float radius;
    float strength;
};

giSettings renderGISettings(){
    giSettings g;

    g.scale = 75;
    g.radius = GI_RADIUS;
    g.strength = 50 * GI_BRIGHTNESS;

    return g;
}

vec3 renderGlobalIllumination(DataBuffer data, Material material){

    const int steps = GI_QUALITY;
    const float rSteps = 1.0 / steps;

    giSettings g = renderGISettings();

    vec3 shadowPosition = renderShadowPosition(data.worldPosition[1]);
    vec3 outPosition = renderShadowDistortPosition(shadowPosition) * 0.5 + 0.5;
    vec3 shadowSpaceNormal = mat3(shadowModelView) * data.worldNormal * vec3(1.0, 1.0, -1.0);

    if(any(greaterThanEqual(abs(outPosition), vec3(1.0)))) return vec3(1.0);

    float sampleScale = 2 * g.scale / 2048;

    vec3 color = vec3(0.0);

    for(int i = 0; i < steps; ++i){
        float alpha = (i + data.dither) / steps;
        float angle = data.dither * 6.28 + alpha * 4 * 6.28;

        vec2 sampleOffset = (sincos(angle) * sqrt(alpha)) * sampleScale;
        //if(dot(shadowSpaceNormal.xy, sampleOffset) < 0) sampleOffset = -sampleOffset;

        vec2 sampleCoord = shadowPosition.xy + sampleOffset;
        vec2 sampleDistort = renderShadowDistortPosition(sampleCoord) * 0.5 + 0.5;

        float depth = texture2D(shadowtex1, sampleDistort).x * 2 - 1;

        vec4 color0 = texture2D(shadowcolor0, sampleDistort);
        vec4 color1 = texture2D(shadowcolor1, sampleDistort);

        vec3 samplePosition = vec3(sampleCoord, depth) - shadowPosition;
        
        float factor = dot(samplePosition, samplePosition);
        if(length(samplePosition) > g.scale) continue;

        vec3 sampleVector = samplePosition * inversesqrt(factor);

        vec3 sampleNormal = color1.xyz * 2.0 - 1.0;
             sampleNormal.xy -= sampleNormal.xy;

        data.lightmap.y = pow2(data.lightmap.y);

        float lightmap = color1.a * 2.0 - 1.0;
        float skylight = clamp01(1 - 5 * abs(lightmap - data.lightmap.y));

        float NdotL = material.isGrass || material.isLeaves ? 0.5 : clamp01(dot(sampleVector, shadowSpaceNormal)) * 0.9 + 0.15; if(NdotL <= 0) continue;
        float NdotS = clamp01(dot(sampleVector, sampleNormal)); if(NdotS <= 0) continue;

        float diffuse = (NdotS * NdotL) * skylight;

        float weight = 1.0 / (factor / g.scale * 16384.0 + (1.0 / g.scale) * 32.0);
              weight = color0.a > 0.2 ? 0.5 : weight;

        color += toGamma(color0.rgb) * diffuse * weight; 
    }

    #ifdef GI
    return color * rSteps * g.strength;
    #else
    return vec3(0.0);
    #endif
}