//PBR volumetric Clouds modified version from robobo1221
//https://www.shadertoy.com/view/WdsSzr

struct volumeCloudsSettings{
  float altitude;
  float scale;
  float maxAltitude;
  float thickness;
  float density;
  float speed;
};

volumeCloudsSettings renderVolumeCloudsSettings(){
  volumeCloudsSettings v;

  v.altitude = VOLUME_CLOUDS_ALTITUDE;
  v.scale = 1300.0 / v.altitude;
  v.thickness = 1200.0;
  v.density = 0.125 * VOLUME_CLOUDS_DENSITY;
  v.speed = 0.0045;
  v.maxAltitude = v.thickness + v.altitude;

  return v;
}

float renderScatterIntergral(float opticalDepth, float coeff){
  float a = -1.0 / coeff;

  return opticalDepth * a - a;
}

float remap(float value, const float originalMin, const float originalMax, const float newMin, const float newMax) {
	return (((value - originalMin) / (originalMax - originalMin)) * (newMax - newMin)) + newMin;
}

float renderVolumeFBM(volumeCloudsSettings v, vec3 p){

	if (p.y < v.altitude || p.y > v.maxAltitude) return 0;

  float time = windClouds * v.speed;

  vec3 movement = vec3(-time, 0.0, time);
  vec3 position = p * 0.00085 + movement;

  float coverage = mix(VOLUME_CLOUDS_COVERAGE, VOLUME_CLOUDS_COVERAGE_WEATHER * 1.5, wetness);

	float horizonHeight = p.y - v.altitude;
	float scaleHeight = horizonHeight / v.thickness;
	float heightAtten = remap(scaleHeight, 0.0, 0.2, 0.0, 1.0) * remap(scaleHeight, 0.8, 1.0, 1.0, 0.0);

  float noise = renderVolumeFBM(position, movement);
        noise = noise * heightAtten * coverage - (0.7 * heightAtten * scaleHeight * 0.5 + 0.45);
        noise = clamp01(noise) * v.density;

  return pow(noise, 1.2);
}

float renderCloudShadow(vec3 position, vec3 direction, float strength){
  #ifndef VOLUME_CLOUDS
  return 1.0;
  #endif  

  volumeCloudsSettings v = renderVolumeCloudsSettings();

  const int steps = CLOUD_SHADOW_QUALITY;
  const float rSteps = v.thickness / steps;

	float fade = smoothstep(0.125, 0.075, abs(direction.y));

	float increment = rSteps / direction.y;
  position += position.y <= v.altitude ? direction * (v.altitude - position.y) / direction.y : vec3(0.0);

  float opticalDepth = 0.0;

  for (int i = 0; i < steps; ++i, position += direction * increment){
		opticalDepth += renderVolumeFBM(v, position) * increment;
  }

  return exp2(-opticalDepth * strength) * (1 - fade) + fade;
}

#if defined fsh || defined deferred1 || defined deferred3 || defined composite0
float renderVisibility(volumeCloudsSettings v, vec3 position, vec3 direction, const int steps){
  float increment = v.thickness / steps;
  float opticalDepth = 0.0;

  for(int i = 0; i < steps; ++i, position += direction * increment){
    opticalDepth += renderVolumeFBM(v, position) * increment;
  }

  return opticalDepth;
}

void renderVolumeCloudsScattering(volumeCloudsSettings v, float opticalDepth, float transmittance, float VdotL, vec3 p, const int steps, out vec3 directScattering, out vec3 indirectScattering){
  float direct = renderVisibility(v, p, worldLightVector, 8);
  float indirect = renderVisibility(v, p, worldLightVector, 4);

  float scatter = renderScatterIntergral(opticalDepth, 1);

  float powder = 1 - exp2(-scatter * 4);

  float directPowder = 1 - exp2(-direct * 2) * powder;
        directPowder = mix(directPowder, 1, phase_mie(VdotL, sky_mieg));

  float indirectPowder = 1 - exp2(-indirect * 2) * powder;

  for(int i = 0; i < 3; ++i){
    float a = pow(0.5, i);
    float b = pow(0.2, i);
    float c = pow(0.8, i);

    float phase = phase2Lobes(VdotL * c);
    scatter = transmittance * scatter * a;

    directScattering += scatter * directPowder * phase * exp2(-direct * b);
    indirectScattering += scatter * indirectPowder * exp2(-indirect * b);
  }
}

void renderVolumeClouds(vec3 worldPosition, vec3 worldVector, float VdotL, float depth, float dither, out vec3 scattering, inout float transmittance, int steps){
  volumeCloudsSettings v = renderVolumeCloudsSettings();
  
  float breakTreshold = 0.1;

  //dither = pow2(dither) + 0.5;

  vec2 bottom = rsi(worldUpVector * earthSize + eyeAltitude, worldVector, earthSize + v.altitude);
  vec2 top = rsi(worldUpVector * earthSize + eyeAltitude, worldVector, earthSize + v.maxAltitude);

  float range = mix(1, (1 - clamp01((eyeAltitude - v.maxAltitude) * 0.1)) * (1 - clamp01((v.altitude - eyeAltitude) * 0.1)), float(depth >= 1));

  float startDistance = (eyeAltitude > v.maxAltitude ? top.x : bottom.y);
  float endDistance = (eyeAltitude > v.maxAltitude ? bottom.x : top.y);
  
  vec3 startPosition = worldVector * startDistance;
       startPosition = mix(startPosition, gbufferModelViewInverse[3].xyz, range);
       startPosition = renderCloudsCurvature(startPosition);

  vec3 endPosition = worldVector * endDistance;
       endPosition = mix(endPosition, worldPosition * (depth >= 1 ? (v.maxAltitude / 32) : 1), range);
       endPosition = renderCloudsCurvature(endPosition);

  vec3 increment = (endPosition - startPosition) / steps;
  vec3 position = increment * dither + startPosition + cameraPosition;

  vec3 directScattering = vec3(0);
  vec3 indirectScattering = vec3(0);

  for (int i = 0; i < int(clamp(steps / sqrt(worldVector.y), 0, 125)); ++i, position += increment) {
    if(transmittance < breakTreshold) break;

		float opticalDepth = renderVolumeFBM(v, position) * length(increment);
    if(opticalDepth <= 0) continue;

    float stepTransmittance = exp2(-opticalDepth);

		renderVolumeCloudsScattering(v, stepTransmittance, transmittance, VdotL, position, steps, directScattering, indirectScattering);
		transmittance *= stepTransmittance;
  }
  transmittance = clamp01((transmittance - breakTreshold) / (1 - breakTreshold));

  directScattering *= (sunlight + moonlight) * transitionFading;
  indirectScattering *= weatherSkylight * 0.25 * rPI;
  indirectScattering = mix(indirectScattering, vec3(renderLuminance701(indirectScattering)), 0.9);

  scattering = (directScattering + indirectScattering);
}
#endif
