vec3 renderSun(vec3 vector, vec3 sunVector) {
  const float cosSunRadius = cos(radians(sunRadius));

  return sunLux * fstep(cosSunRadius, dot(vector, sunVector)) * (TAU * (1 - cos(0.5 * radians(sunRadius))));
}

float renderMoon(vec3 vector, vec3 moonVector) {
  const float cosMoonRadius = cos(radians(moonRadius));

  return fstep(cosMoonRadius, dot(vector, moonVector)) * (1.0 / ((1.0 - cosMoonRadius) * 3));
}

float renderStars(vec3 position, vec3 direction){
  position = position * renderRotMat(vec3(0.0, 1.0, 0.0), direction);

  const float res = 2048.0;

  vec3 rp = position * (0.15 * res);

	vec3 id = floor(rp);
  vec3 q = id - rp + 0.5;
  vec3 rn = hash33(id);

  float c  = 1.0 - smoothstep(0.2, 0.5, length(q));
    	  c *= step(rn.x, 0.1 * 0.1);

  return c * 8;
}
