struct planarCloudsSettings{
  float altitude;
  float scale;
  float thickness;
  float density;
  float speed;
};

planarCloudsSettings renderPlanarCloudsSettings(){
  planarCloudsSettings p;

  p.altitude = 6000;
  p.scale = 1300.0 / p.altitude;
  p.thickness = 1200.0 / p.scale;
  p.density = 0.05 * PLANAR_CLOUDS_DENSITY;
  p.speed = 30;

  return p;
}

float renderPlanarOpticalDepth(planarCloudsSettings p, vec3 position){
    float wind = windPlanarClouds * p.speed;
    vec2 movement = vec2(-wind, wind * 0.45);

    position.x *= 0.45;
    position.x -= wind * 0.01;
    position.xz = (position.xz + movement) * 0.0015 * p.scale;

    float height = position.y - p.altitude;
    float scaleHeight = height / p.thickness + 0.5;
    float attenuation = remap(scaleHeight, 0.0, 0.2, 0.0, 1.0) * remap(scaleHeight, 0.8, 1.0, 1.0, 0.0);

    float noise = renderFBM(position.xz, movement);
          noise = noise * attenuation * PLANAR_CLOUDS_COVERAGE - (0.8 * attenuation * scaleHeight * 0.5 + 0.45);
          noise = clamp01(noise) * (p.density * p.scale);

          noise = curve(noise);

    return noise;
}

float renderPlanarVisibility(planarCloudsSettings p, vec3 position, vec3 direction, const int steps){
  float increment = p.thickness / steps;
  float opticalDepth = 0.0;

  for(int i = 0; i < steps; ++i, position += direction * increment){
    opticalDepth += renderPlanarOpticalDepth(p, position);
  }

  return opticalDepth * increment;
}

void renderPlanarScattering(planarCloudsSettings p, float opticalDepth, float transmittance, vec3 position, float VdotL, out vec3 direct, out vec3 indirect){
    float directVisibility = renderPlanarVisibility(p, position, worldLightVector, 8);
    float indirectVisibility = renderPlanarVisibility(p, position, worldLightVector, 4);
    float scatter = renderScatterIntergral(opticalDepth, 0.75);

    for(int i = 0; i < 3; ++i){
        float a = pow(0.5, i);
        float b = pow(0.15, i);
        float c = pow(0.85, i);

        float phase = phase2Lobes(VdotL * c);
        scatter = scatter * a;

        direct += scatter * phase * exp2(-directVisibility * b) * transmittance;
        indirect += scatter * exp2(-indirectVisibility * b) * transmittance;
    }
}

void renderPlanarClouds(vec3 vector, vec3 direction, out vec3 scattering, inout float transmittance){
    planarCloudsSettings p = renderPlanarCloudsSettings();

    vec3 direct = vec3(0.0);
    vec3 indirect = vec3(0.0);
    transmittance = 1.0;

    float VdotL = dot(vector, direction);

    vec2 sphere = rsi(worldUpVector * earthSize + eyeAltitude, vector, earthSize + p.altitude);

    vec3 position = vector * sphere.y;
         position += cameraPosition;
		 position = renderCloudsCurvature(position);

    float opticalDepth = renderPlanarOpticalDepth(p, position);
    float scatter = exp2(-opticalDepth * p.thickness * 0.1);

    renderPlanarScattering(p, scatter, transmittance, position, VdotL, direct, indirect);
    transmittance *= scatter;
    
    scattering = direct * (sunlight + moonlight) * transitionFading;
    scattering += indirect * weatherSkylight * 0.25 * rPI;
    scattering = scattering * PI;
}