vec2 rsi(vec3 position, vec3 direction, float radius) {
    float PoD = dot(position, direction);
    float radiusSquared = radius * radius;

    float delta = PoD * PoD + radiusSquared - dot(position, position);
    if (delta < 0.0) return vec2(-1.0);
          delta = sqrt(delta);

    return -PoD + vec2(-delta, delta);
}

#include "/program/light/common/atmosphere/constant.glsl"
#include "/program/light/common/atmosphere/phase.glsl"
#include "/program/light/common/atmosphere/transmittance.glsl"
#include "/program/light/common/atmosphere/spot.glsl"

#include "/program/light/common/atmosphere/volumetricClouds.glsl"
#include "/program/light/common/atmosphere/planarClouds.glsl"

vec3 renderAtmosphericScattering(vec3 vector, vec3 sunVector, vec3 moonVector, vec3 upVector, const int steps){
  const int jSteps = 3;

  vec3 viewPosition = (earthSize + eyeAltitude) * upVector;

  vec2 aid = rsi(viewPosition, vector, atmosphereRadius);
  vec2 pid = rsi(viewPosition, vector, earthSize * 0.9995);

	bool planetIntersected = pid.y >= 0.0;

  vec2 sd = vec2((planetIntersected && pid.x < 0.0) ? pid.y : max0(aid.x), (planetIntersected && pid.x > 0.0) ? pid.x : aid.y);

	float stepSize = (sd.y - sd.x) / steps;
	vec3 increment = vector * stepSize;
	vec3 position = vector * sd.x + (increment * 0.3 + viewPosition);

  vec2 phaseSun = phase_Sky(dot(vector, sunVector), sky_mieg);
	vec2 phaseMoon = phase_Sky(dot(vector, moonVector), sky_mieg);

	vec3 scatteringSun = vec3(0.0);
	vec3 scatteringMoon = vec3(0.0);
	vec3 scatteringAmbient = vec3(0.0);
	vec3 transmittance = vec3(1.0);

  for(int i = 0; i < steps; ++i, position += increment) {
    vec3 density = renderDensity(length(position));
    if (density.y > 1e35) break;

		vec3 stepAirmass = density * stepSize;
		vec3 stepOpticalDepth = attenuationCoeff * stepAirmass;

    vec3 stepTransmittance = exp2(-stepOpticalDepth);
    vec3 stepTransmittedFraction = clamp01((stepTransmittance - 1.0) / -stepOpticalDepth);
    vec3 stepScatteringVisible = transmittance * stepTransmittedFraction;

    scatteringSun += scatteringCoeff * (stepAirmass.xy * phaseSun) * stepScatteringVisible * renderTransmittance(position, sunVector, jSteps);
		scatteringMoon += scatteringCoeff * (stepAirmass.xy * phaseMoon) * stepScatteringVisible * renderTransmittance(position, moonVector, jSteps);

    scatteringAmbient += scatteringCoeff * (stepAirmass.xy * 0.25 * rPI) * stepScatteringVisible;

		transmittance *= stepTransmittance;
  }

  vec3 scattering = scatteringSun * sunLux;
       scattering += scatteringMoon * moonLux;
       scattering += scatteringAmbient * skylight;

  transmittance = planetIntersected ? vec3(0.0) : transmittance;
  
  return scattering;
}