void renderMaterial(out float material, out float mask, inout float lmcoord){
  mask = 1.0;
  material = mc_Entity.x;

  #if defined terrain
  lmcoord = material == 1009 ||
            material == 1010 ||
            material == 1011 ||
            material == 1012 ||
            material == 1013 ||
            material == 1014 ? 1.0 : lmcoord;
  #endif

  #if defined terrain || defined water
  mask = material == 1001 ||
         material == 1003 ||
         material == 1004 ||
         material == 1005 ||
         material == 2002 ||
	  material == 2003 ||
         material == 4002 ||
         material == 4004 ||
         material == 4005 ? 2.0 : mask;   //Grass

  mask = material == 1002 ||
         material == 2001 ||
	  material == 3001 ||
	  material == 4001 ? 3.0 : mask;   //Leaves

  mask = material == 1006 ||
	  material == 5001 ? 4.0 : mask;   //Water

  mask = material == 1007 ? 5.0 : mask;   //Ice
  mask = material == 1008 ? 6.0 : mask;   //Stained glass

  mask = material == 1009 ? 7.0 : mask;   //torch
  mask = material == 1010 ? 8.0 : mask;   //fire
  mask = material == 1011 ? 9.0 : mask;   //Lit redstone
  mask = material == 1012 ? 10.0 : mask;   //Glowstone
  mask = material == 1013 ? 11.0 : mask;  //Magma
  mask = material == 1014 ? 12.0 : mask;  //Sea lantern
  mask = material == 1019 ? 16.0 : mask;

  #elif defined basic
  mask = 14.0;                            //block selection box
  #elif defined textured
  mask = 15.0;                            //Particles
  #elif defined hand
  mask = 17.0;
  #endif
  
  mask = floor(mask) / 32;
}
