#if defined vertex
out vec2 coord;

void main(){
  coord = gl_Vertex.xy;
  gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
}
#elif defined fragment
in vec2 coord;

vec3 renderWidescreen(vec3 color){
  float up = 0.9 - WIDE_SCREEN_SIZE;
  float down = 0.1 + WIDE_SCREEN_SIZE;

  #ifdef WIDE_SCREEN
  if(coord.t > up || coord.t < down) color = vec3(0);
  #endif

  return color;
}

vec3 renderVignette(vec3 color){
  #ifndef VIGNETTE
  return color;
  #endif

  float dist = pow2(distance(coord, vec2(0.5))) * 2 * VIGNETTE_SIZE;

  return color * (1 - dist);
}

struct colorCorrection{
	float saturation;
	float vibrance;
	float contrast;
	float contrastMidpoint;

	vec3 gain;
	vec3 lift;
	vec3 invGamma;
};


colorCorrection renderColorCorrection(){
    colorCorrection c;

    c.saturation = 1 + SATURATION;
    c.vibrance = VIBRANCE;
    c.contrast = 1 + CONTRAST;
    c.contrastMidpoint = 0.5;

    c.gain = vec3(1) + GAIN;
    c.lift = vec3(0) + LIFT * 0.01;
    c.invGamma = vec3(1) * 1.1 + GAMMA;

    return c;
}

vec3 renderSaturation(colorCorrection c, vec3 color){
  float grey = renderLuminance701(color);
	return grey + c.saturation * (color - grey);
}

vec3 renderVibrance(colorCorrection c, vec3 color){
  float cmax = max(color.r, max(color.g, color.b));
  float cmin = min(color.r, min(color.g, color.b));

  float lum = renderLuminance701(color);

  return mix(vec3(lum), color, 1 + (c.vibrance * (1 - (fsign(c.vibrance) * (cmax - cmin)))));
}

vec3 renderLiftGammaGain(colorCorrection c, vec3 color){
	vec3 lerpV = clamp01(pow(color, c.invGamma));
	return c.gain * lerpV + c.lift * (1 - lerpV);
}

float renderLogContrast(float x, float eps, float logMidpoint, float contrast){
	float logX = log2(x + eps);
	float adjX = (logX - logMidpoint) * contrast + logMidpoint;

	return max0(exp2(adjX) - eps);	
}

vec3 renderContrast(colorCorrection c, vec3 color) {
	const float contrastEpsilon = 1e-5;

	vec3 ret;
	     ret.x = renderLogContrast(color.x, contrastEpsilon, log2(0.18), c.contrast);
		 ret.y = renderLogContrast(color.y, contrastEpsilon, log2(0.18), c.contrast);
		 ret.z = renderLogContrast(color.z, contrastEpsilon, log2(0.18), c.contrast);

	return ret;
}

vec3 renderColor(sampler2D sampler, vec2 coord){
     vec2 position = coord * pixel;
     vec2 centerPosition = floor(position - 0.5) + 0.5;

     vec2 f = position - centerPosition;
     vec2 ff = pow2(f);

     vec2 w0 = f * (-0.5 + f * (1 - 0.5 * f));
     vec2 w1 = 1 + ff * (-2.5 + 1.5 * f);
     vec2 w2 = f * (0.5 + f * (2 - 1.5 * f));
     vec2 w3 = ff * (-0.5 + 0.5 * f);
     
     vec2 w12 = w1 + w2;
     vec2 offset12 = w2 / (w1 + w2);

     vec2 tc0 = rPixel * (centerPosition - 1);
     vec2 tc3 = rPixel * (centerPosition + 2);
     vec2 tc12 = rPixel * (centerPosition + offset12);

     vec3 previous = vec3(0);

          previous += texture2D(sampler, vec2(tc0.x, tc0.y)).rgb * (w0.x * w0.y);
          previous += texture2D(sampler, vec2(tc12.x, tc0.y)).rgb * (w12.x * w0.y);
          previous += texture2D(sampler, vec2(tc3.x, tc0.y)).rgb * (w3.x * w0.y);

          previous += texture2D(sampler, vec2(tc0.x, tc12.y)).rgb * (w0.x * w12.y);
          previous += texture2D(sampler, vec2(tc12.x, tc12.y)).rgb * (w12.x * w12.y);
          previous += texture2D(sampler, vec2(tc3.x, tc12.y)).rgb * (w3.x * w12.y);

          previous += texture2D(sampler, vec2(tc0.x, tc3.y)).rgb * (w0.x * w3.y);
          previous += texture2D(sampler, vec2(tc12.x, tc3.y)).rgb * (w12.x * w3.y);
          previous += texture2D(sampler, vec2(tc3.x, tc3.y)).rgb * (w3.x * w3.y);

     return max0(previous);
}

void main(){
    colorCorrection c = renderColorCorrection();

    vec3 color = toGamma(renderColor(colortex4, coord)) * PI;

         color = renderVibrance(c, color);
         color = renderSaturation(c, color);
         color = renderLiftGammaGain(c, color);
         color = renderContrast(c, color);

         color = renderVignette(color);
         color = toLinear(color);
         color = clamp01(color);

         color = renderWidescreen(color);

    gl_FragColor = vec4(color, 1.0);
}
#endif
