//filmic Tonemap from here
//https://github.com/iftodebogdan/GITechDemo/blob/master/GITechDemo/Data/shaders/HDRToneMapping.hlsl

struct filmicSettings{
	float a;	//Shoulder strength
	float b;	//Linear strength
	float c;	//Linear angle
	float d;	//Toe strength
	float e;	//Toe numerator
	float f;	//Toe denominator
	float w;	//Linera white
};

filmicSettings renderFilmicSettings(){
	filmicSettings f;

	#if TONEMAP_FILMIC_PRESET == 0
	f.a = 0.22;
	f.b = 0.30;
	f.c = 0.10;
	f.d = 0.20;
	f.e = 0.01;
	f.f = 0.30;

	f.w = 11.2;
	#elif TONEMAP_FILMIC_PRESET == 1
	f.a = 0.15;
	f.b = 0.50;
	f.c = 0.10;
	f.d = 0.20;
	f.e = 0.02;
	f.f = 0.30;

	f.w = 11.2;
	#elif TONEMAP_FILMIC_PRESET == 2
	f.a = 0.28;
	f.b = 0.29;
	f.c = 0.10;
	f.d = 0.20;
	f.e = 0.025;
	f.f = 0.35;

	f.w = 15.3;
	#else
	f.a = 0.22 * TONEMAP_SHOULDER_S;
	f.b = 0.30 * TONEMAP_LINEAR_S;
	f.c = 0.10 * TONEMAP_LINEAR_A;
	f.d = 0.20 * TONEMAP_TOE_S;
	f.e = 0.01 * TONEMAP_TOE_N;
	f.f = 0.30 * TONEMAP_TOE_D;

	f.w = 11.2 * TONEMAP_LINEAR_W;
	#endif

	return f;
}

vec3 renderFilmic(vec3 color){
	filmicSettings f = renderFilmicSettings();

	vec3 filmic0 = (color * (f.a * color + f.b * f.c) + f.d * f.e);
	vec3 filmic1 = (color * (f.a * color + f.b) + f.d * f.f);

	return (filmic0 / filmic1) - f.e / f.f;
}

vec3 FilmicTonemap(vec3 color){
	filmicSettings f = renderFilmicSettings();

	vec3 whiteScale = renderFilmic(vec3(f.w));
	vec3 filmic = renderFilmic(color * TONEMAP_EXPOSURE) * whiteScale;
	#if TONEMAP_FILMIC_PRESET == 1
		 filmic *= 2;
	#endif
	
	return clamp01(filmic);
}

//Breath of the wild tonemap from Clarity Graphic pack for Cemu

vec3 BOTWTonemap(vec3 color){
	float avg = (color.r + color.g + color.b) / 2.5;
	float maxc = max(color.r, max(color.g, color.b));

	float w = 1.0 - pow2(1.0 - 2.0 * avg);
	float weight = 1.0 + w * 0.22;

	return mix(vec3(maxc), color, weight);
}

vec3 Contrasty(vec3 color){
	color *= 0.45;
	color = BOTWTonemap(color);
	color = clamp01(TONEMAP_EXPOSURE * color);

	float max_color = max(color.r, max(color.g, color.b));
	float min_color = min(color.r, min(color.g, color.b));

	float color_saturation = max_color - min_color;
	float saturation = 0.15;

	float luma = renderLuminance701(color);

	color = mix(vec3(luma), color, 1.0 + (saturation * (1.0 - fsign(saturation) * color_saturation)));

	return color;
}

//ACES Fitted from afl_ext
//https://www.shadertoy.com/view/XsGfWV

mat3 ACESInputMat = mat3(vec3(0.59719, 0.35458, 0.04823),
						 vec3(0.07600, 0.90834, 0.01566),
						 vec3(0.02840, 0.13383, 0.83777));

mat3 ACESOutputMat = mat3(vec3(1.60475, -0.53108, -0.07367),
						  vec3(-0.10208, 1.10813, -0.00605),
						  vec3(-0.00327, -0.07276, 1.07602));

vec3 RRTAndODTFit(vec3 v){
    vec3 a = v * (v + 0.0245786f) - 0.000090537f;
    vec3 b = v * (0.983729f * v + 0.4329510f) + 0.238081f;

    return a / b;
}

vec3 ACESFitted(vec3 color){
	color *= TONEMAP_EXPOSURE;
	color = color * ACESInputMat;
	color = RRTAndODTFit(color);
	color = color * ACESOutputMat;

	return clamp01(color);
}

const vec3 coneOverlapSimulation = vec3(0.25);
const mat3 coneOverlapMatrix2Deg = mat3(mix(vec3(1.0, 0.0, 0.0), vec3(0.5595088340965042, 0.39845359892109633, 0.04203756698239944), coneOverlapSimulation),
										mix(vec3(0.0, 1.0, 0.0), vec3(0.43585871315661756, 0.5003841413971261, 0.06375714544625634), coneOverlapSimulation),
										mix(vec3(0.0, 0.0, 1.0), vec3(0.10997368482498855, 0.15247972169325025, 0.7375465934817612), coneOverlapSimulation));
								
vec3 renderTonemap(vec3 color){
	color = color * coneOverlapMatrix2Deg;

	#if TONEMAP_MODE == 0
	color = FilmicTonemap(color);
	#elif TONEMAP_MODE == 1
	color = ACESFitted(color);
	#else
	color = Contrasty(color);
	#endif

	return toLinear(color * inverse(coneOverlapMatrix2Deg));
}
