//Musk's Lens Flare V2 from SolarLinear(Not from Elon Musk lol)
//https://www.shadertoy.com/view/MdGSWy

float lensNoise(float t){
  return texture2D(noisetex, vec2(t, 0.0) * rPixel).x;
}

float lensNoise(vec2 t){
  return texture2D(noisetex, t * rPixel).x;
}

vec2 renderDistOffset(vec2 coord, vec2 position){
  vec3 prep = normalize(vec3(coord.y, -coord.x, 0.0));

  float angle = length(coord) * 2.221;

  vec3 sampleOffset = vec3(coord, 0.0);
  vec3 rotate = sampleOffset * cos(angle) + cross(prep, sampleOffset) * sin(angle) + prep * dot(prep, sampleOffset) * (1.0 - cos(angle));

  return rotate.xy;
}

vec3 renderFlare(vec2 coord, vec2 position, float dist, float size){
  position = renderDistOffset(coord, position);

  float r = max0(0.01 - pow(length(coord + (dist - 0.5) * position), 2.4) * (1.0 / (size * 2.0)));
  float g = max0(0.01 - pow(length(coord + dist * position), 2.4) * (1.0 / (size * 2.0)));
  float b = max0(0.01 - pow(length(coord + (dist + 0.5) * position), 2.4) * (1.0 / (size * 2.0)));

  return vec3(r, g, b) * 6.0;
}

vec3 renderFlare(vec2 coord, vec2 position, float dist, float size, vec3 color){
  return renderFlare(coord, position, dist, size) * color;
}

vec3 renderOrb(vec2 coord, vec2 position, float dist, float size){
  const int steps = 6;
  const float inverseSteps = 1.0 / (steps * 2.0);

  vec3 color = vec3(0.0);

  for(int i = 0; i < steps; ++i){
    float sampleOffset0 = (i + 1.0) / (i + 1.0);
    float sampleOffset1 = i * inverseSteps;

    color += renderFlare(coord, position, dist + sampleOffset0, size / (i + 1.0), vec3(1.0 - sampleOffset1, 1.0, 0.5 + sampleOffset1));
  }

  color += renderFlare(coord, position, dist + 0.5, 4.0 * size, vec3(1.0)) * 4.0;

  return color / 4.0;
}

vec3 renderRing(vec2 coord, vec2 position, float dist){
  vec2 uvd = coord * length(coord);

  float r = max0(1.0 / (1.0 + 32.0 * pow2(length(uvd + (dist - 0.05) * position)))) * 0.25;
  float g = max0(1.0 / (1.0 + 32.0 * pow2(length(uvd + dist * position)))) * 0.23;
  float b = max0(1.0 / (1.0 + 32.0 * pow2(length(uvd + (dist + 0.05) * position)))) * 0.21;

  return vec3(r, g, b);
}

vec3 renderLensFlare(vec2 coord){
  #ifndef LENS_FLARE
  return vec3(0.0);
  #endif
  
  vec2 aspectCorrect = 1.0 / vec2(aspectRatio, 1.0);

  coord = coord * aspectCorrect;

  vec2 position = renderScreenPosition(sunPosition).xy * aspectCorrect;
  vec3 lightVector = normalize(sunPosition);

  float size = 1.0;

  vec3 color = vec3(0.0);

       color += renderFlare(coord, position, -3.0, 3.0 * size);
       color += renderFlare(coord, position, -1.0, size) *3.0;
       color += renderFlare(coord, position, 0.5, 0.8 * size);
       color += renderFlare(coord, position, -0.4, 0.8 * size);

       color += renderOrb(coord, position, 0.0, 0.5 * size);

       color += renderRing(coord, position, -1.0) * 0.5 * size;
       color += renderRing(coord, position, 1.0) * 0.5 * size;

  vec3 sunColor = DecodeColor(DecodeRGBE8(texture2D(colortex1, coord)));

  color *= sunColor * (1.0 - (clamp01(lightVector).z / abs(lightVector.z)));
  color *= 1.0 - float(texture2D(depthtex1, position).x < 1.0);

  return color;
}
