float renderExposure(float averageExposure) {
    float aperture = pow2(CAM_APERTURE);
    float shutterSpeed = 1 / CAM_SHUTTER_SPEED;
    float exposureOffset = CAM_EXPOFFSET;
    float iso = CAM_ISO;

    #if MODE == 1
    float exposure = log2(aperture / shutterSpeed * 100 / iso);
    #else
    float exposure = log2(averageExposure * 100 / 12.5);
    #endif

    return 1 / (1.2 * exp2(exposure - exposureOffset));
}
