#if defined vertex

out vec2 coord;

void main(){
  coord = gl_Vertex.xy;
  gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
}
#elif defined fragment
const bool colortex3MipmapEnabled = true;
const bool colortex5MipmapEnabled = true;

in vec2 coord;

#include "/program/camera/common/bloom.glsl"
#include "/program/camera/common/exposure.glsl"
#include "/program/camera/common/tonemap.glsl"
#include "/program/camera/common/heatwave.glsl"

void main(){
  vec3 color = DecodeColor(DecodeRGBE8(texture2D(colortex1, coord)));
  float exposure = renderExposure(DecodeColor(texture2D(colortex5, coord).a)) * 1.5;

  color = renderBloom(color, coord, exposure);;
  color *= exposure;

  /* DRAWBUFFERS:0 */
  gl_FragData[0].rgb = renderTonemap(color);
  gl_FragData[0].a = 1.0;
}
#endif
