#if defined vertex

out vec2 coord;

void main(){
  coord = gl_Vertex.xy;
  gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
}
#elif defined fragment
const bool colortex5MipmapEnabled = true;

in vec2 coord;

float renderAverageExposure(){
  int lod = int(log2(max(pixel.x, pixel.y)));

  float emin = 0.00035;
  float emax = 0.5;
  
  float currentLum = renderLuminance701(texture2DLod(colortex5, vec2(0.5), lod).rgb);
        currentLum = clamp(currentLum, emin, emax);

  float previous = texture2D(colortex5, vec2(0.5)).a;
        previous = clamp(previous, emin, emax);

  float exposureTime = currentLum > previous ? 1 : 2;
        exposureTime = exp(-exposureTime * frameTime);

  return mix(currentLum, previous, exposureTime);
}

#include "/program/camera/common/bloom.glsl"
#include "/program/camera/common/dof.glsl"

void main(){
  /* DRAWBUFFERS:175 */
  gl_FragData[0] = renderDOF(coord);
  gl_FragData[1] = renderBloom(coord);
  gl_FragData[2].rgb = texture2D(colortex5, coord).rgb;
  gl_FragData[2].a = renderAverageExposure();
}
#endif
