#if defined vertex
#include "/program/light/common/vector.glsl"
#elif defined fragment
const bool colortex7MipmapEnabled = true;

in vec2 coord;

in vec3 sunVector, moonVector, lightVector, upVector;
in vec3 worldSunVector, worldMoonVector, worldLightVector, worldUpVector;
in vec3 sunlight, moonlight, skylight, weatherSkylight, torchlight;

in float sunRise, sunNoon, sunSet, dayTime;
in float moonRise, moonNoon, moonSet, moonTime;

in float ambientFog;
in float transitionFading;
in float dynamicWeather;

in mat4 shadowMatrix;

in mat3x4 skySH;

#include "/program/light/common/struct.glsl"
#include "/program/light/common/atmosphere/atmosphericScattering.glsl"
#include "/program/light/common/diffuse.glsl"

float renderCloudsFade(vec3 vector){
    volumeCloudsSettings v = renderVolumeCloudsSettings();
	
    const float altitudeMin = 800;
    const float altitudeMax = 8000;
 
    vec2 sphereMin = rsi(worldUpVector * earthSize + eyeAltitude, vector, earthSize + altitudeMin);
    vec2 sphereMax = rsi(worldUpVector * earthSize + eyeAltitude, vector, earthSize + altitudeMax);

    float sampleDistance = eyeAltitude > altitudeMax ? sphereMax.x : sphereMin.y;

	  vec3 samplePosition = vector * sampleDistance;
    vec3 coefficient = rayleighCoeff + mieCoeff;

    return 1 - exp(-length(samplePosition) * max3(coefficient));
}

void main(){
  DataBuffer data = renderBuffer();
  Material material = renderMaterial(data.ID, data.depth);

  vec2 atmosphereCoord = renderUnprojectSky(data.worldVector[1]) * 0.5;

  float transmittanceC = 1;

  float VdotS = dot(data.vector[1], lightVector);
  float fade = renderCloudsFade(data.worldVector[1]);

  vec3 color = renderDiffuse(data.color, data.normal, data.worldNormal, data.position[1], data.worldPosition[0], data.vector[1], data.worldVector[1], data.lightmap, data.depth, data.dither, pow2(data.roughness), data.f0 * 0.98 + 0.02, data.shadowParallax, material);
  vec3 skyTransmittance = renderTransmittance(data.worldVector[1], 3);
  vec3 atmosphere = texture2D(colortex3, atmosphereCoord).rgb;

  vec3 scattering = vec3(0);
  vec3 clouds3D = vec3(0);
  vec3 clouds2D = vec3(0);

  color = material.isSky ? atmosphere : color;

  if(material.isSky){
    #ifdef VOLUME_CLOUDS
    renderVolumeClouds(data.worldPosition[0], data.worldVector[0], VdotS, 1, data.dither, clouds3D, transmittanceC, VOLUME_CLOUDS_QUALITY);
    scattering += clouds3D;
    #endif
    
    #ifdef PLANAR_CLOUDS
    if(transmittanceC >= 0.5) renderPlanarClouds(data.worldVector[1], worldLightVector, clouds2D, transmittanceC);
    scattering += clouds2D;
    #endif
  }

  atmosphere = mix(atmosphere, vec3(renderLuminance701(atmosphere)), 0.9);
  color = material.isSky ? mix(color * transmittanceC + scattering, atmosphere, fade) : color;
  skyTransmittance = skyTransmittance * transmittanceC;

  vec3 sun = renderSun(data.worldVector[1], worldSunVector) * sunlight;
  vec3 moon = renderMoon(data.worldVector[1], worldMoonVector) * moonlight;

  vec3 spot = (sun + moon) * skyTransmittance;
       spot += renderStars(data.worldVector[1], worldMoonVector) * skyTransmittance;
       
  color += material.isSky ? spot : color;

  /* DRAWBUFFERS:1 */
  gl_FragData[0] = EncodeRGBE8(color);
}
#endif
