#if defined vertex
#include "/program/light/common/vector.glsl"
#elif defined fragment

in vec2 coord;

in vec3 sunVector, moonVector, lightVector, upVector;
in vec3 worldSunVector, worldMoonVector, worldLightVector, worldUpVector;
in vec3 sunlight, moonlight, skylight, weatherSkylight, torchlight;

in float sunRise, sunNoon, sunSet, dayTime;
in float moonRise, moonNoon, moonSet, moonTime;

in float ambientFog;
in float transitionFading;
in float dynamicWeather;

in mat4 shadowMatrix;

in mat3x4 skySH;

#include "/program/light/common/struct.glsl"
#include "/program/light/common/ao.glsl"
#include "/program/light/common/gi.glsl"

void main(){
  DataBuffer data = renderBuffer();
  Material material = renderMaterial(data.ID, data.depth);

  float ao = material.hand ? 1 : renderSSAO(data.position[1], data.normal, data.dither);
  vec3 gi = renderGlobalIllumination(data, material) * ao;

  /* DRAWBUFFERS:6 */
  gl_FragData[0] = vec4(gi, ao);
}
#endif
