#if defined vertex
#include "/program/light/common/vector.glsl"
#elif defined fragment

in vec2 coord;

in vec3 sunVector, moonVector, lightVector, upVector;
in vec3 worldSunVector, worldMoonVector, worldLightVector, worldUpVector;
in vec3 sunlight, moonlight, skylight, weatherSkylight, torchlight;

in float sunRise, sunNoon, sunSet, dayTime;
in float moonRise, moonNoon, moonSet, moonTime;

in float ambientFog;
in float transitionFading;
in float dynamicWeather;

in mat4 shadowMatrix;

in mat3x4 skySH;

#include "/program/light/common/struct.glsl"
#include "/program/light/common/atmosphere/atmosphericScattering.glsl"

vec3 renderAtmosphere(DataBuffer data, Material material){
  vec3 atmosphere = vec3(0.0);

	if(any(greaterThan(coord, vec2(0.501)))) return vec3(0.0);

	vec3 position = renderProjectSky(coord * 2.0) * vec3(1, 1, -1);

  return renderAtmosphericScattering(position, worldSunVector, worldMoonVector, worldUpVector, 15);
}

void main(){
  #if defined world0
    DataBuffer data = renderBuffer();
    Material material = renderMaterial(data.ID, data.depth);

    /* DRAWBUFFERS:3 */
    gl_FragData[0] = vec4(renderAtmosphere(data, material), 1);
  #endif
}
#endif
