#if defined vertex
#include "/program/light/common/vector.glsl"
#elif defined fragment
const bool colortex6MipmapEnabled = true;

in vec2 coord;

in vec3 sunVector, moonVector, lightVector, upVector;
in vec3 worldSunVector, worldMoonVector, worldLightVector, worldUpVector;
in vec3 sunlight, moonlight, skylight, weatherSkylight, torchlight;

in float sunRise, sunNoon, sunSet, dayTime;
in float moonRise, moonNoon, moonSet, moonTime;

in float ambientFog;
in float transitionFading;
in float dynamicWeather;

in mat4 shadowMatrix;

in mat3x4 skySH;

#include "/program/light/common/struct.glsl"
#include "/program/light/common/atmosphere/atmosphericScattering.glsl"
#include "/program/light/common/atmosphere/volumetricRay.glsl"
#include "/program/light/common/specular/reflection.glsl"

void renderRefraction(inout vec2 coord, inout DataBuffer data, bool isTranslucent){
  if(isTranslucent){
    vec3 flatNormal = clamp(normalize(cross(dFdx(data.position[0]), dFdy(data.position[0]))), -1.0, 1.0);
    vec3 direction = refract(data.vector[0], (data.normal - flatNormal), 0.85);

    vec3 refractPosition = direction * abs(distance(data.worldPosition[0], data.worldPosition[1])) + data.position[0];
         refractPosition = renderScreenPosition(refractPosition);
         refractPosition.z = texture2D(depthtex1, refractPosition.xy).x;

    if(refractPosition.z > texture2D(depthtex0, refractPosition.xy).x){
      coord = refractPosition.xy;
      data.depth.y = refractPosition.z;

      data.position[1] = renderViewPosition(refractPosition);
      data.worldPosition[1] = renderWorldPosition(data.position[1]);

      data.vector[1] = inversesqrt(dot(data.position[1], data.position[1])) * data.position[1];
      data.worldVector[1] * mat3(gbufferModelViewInverse) * data.vector[0];
    }
  }
}

vec3 renderTranslucent(vec3 color, DataBuffer data, Material material){
  if(material.isWater || !material.isTranslucent) return color;

  vec4 color0 = texture2D(colortex0, coord);

  return mix(color * mix(vec3(1.0), toGamma(color0.rgb), fsign(color0.a)), color,  pow3(1 - color0.a));
}

vec3 renderParticles(vec3 color, bool particles){
  vec4 color0 = texture2D(colortex0, coord);
		 
  return particles ? color * (1 - color0.a) + color0.rgb : color;
}

void main(){
  DataBuffer data = renderBuffer();
  Material material = renderMaterial(data.ID, data.depth);

  vec2 refractCoord = coord;

  #ifdef WATER_REFRACTION
  renderRefraction(refractCoord, data, material.isTranslucent);
  #endif

  float VdotL = dot(data.vector[1], lightVector);

  vec3 color = DecodeRGBE8(texture2D(colortex1, refractCoord));

       if(material.rain){
         //color += phase_mie(VdotL, sky_mieg) * sunLux * 0.01;
         color += weatherSkylight * 0.55;
       }

       color = material.selection ? vec3(0.0) : color;
       color = renderParticles(color, material.particles);

      // color = material.isTranslucent && (!material.isWater || !material.isIce || isEyeInWater == 0)? renderVolumetricRay(color, data, material, true) : color;
       color = renderTranslucent(color, data, material);
       color = material.isWater || material.isIce || isEyeInWater == 1 ? renderVolumetricRayWater(color, data, material) : color;
       color = data.depth.x < 1 ? renderReflection(color, data, material) : color;
       color = isEyeInWater == 0 ? renderVolumetricRay(color, data, material, false) : color;
       
  /* DRAWBUFFERS:5 */
  gl_FragData[0].rgb = EncodeColor(color);
  gl_FragData[0].a = texture2D(colortex5, coord).a;
}
#endif
