struct DataBuffer{
  vec3 color;
  vec3 normal;
  vec3 worldNormal;
  vec3 shadowNormal;

  vec2 depth;
  vec2 lightmap;

  float ID;
  float roughness;
  float f0;
  float dither;
  float shadowParallax;

  mat2x3 position;
  mat2x3 worldPosition;
  mat2x3 vector;
  mat2x3 worldVector;
};

struct Material{
  bool isGrass;
  bool isLeaves;

  bool isWater;
  bool isIce;
  bool isStainedGlass;

  bool isTorch;
  bool isFire;
  bool isRedstone;
  bool isLava;
  bool isGlowstone;
  bool isSealantern;
  bool beaconBeam;

  bool rain;
  bool selection;
  bool particles;
  bool hand;

  bool isSky;
  bool isTranslucent;
};

vec3 renderNormal(vec2 coord){
  return DecodeNormal(gbufferModelView, texture2D(colortex2, coord).x);
}

vec2 renderDepth(vec2 coord){
  return vec2(texture2D(depthtex0, coord).x, texture2D(depthtex1, coord).x);
}

DataBuffer renderBuffer(){
  DataBuffer data;

  vec4 color0 = renderTex(colortex0);
  vec4 color2 = renderTex(colortex2);

  data.color = toGamma(color0.rgb);
  data.normal = renderNormal(coord);
  data.worldNormal = mat3(gbufferModelViewInverse) * data.normal;
  data.shadowNormal = mat3(shadowModelView) * data.worldNormal;

  data.depth = renderDepth(coord);

  data.ID = (1.0 - DecodeVec2(color2.w).x) * 32.0;
  data.shadowParallax = DecodeVec2(color2.w).y * 2.0 - 1.0;
  
  data.position = mat2x3(renderViewPosition(coord, data.depth.x),
                         renderViewPosition(coord, data.depth.y));

  data.worldPosition = mat2x3(renderWorldPosition(data.position[0]),
                              renderWorldPosition(data.position[1]));

  data.vector = mat2x3(normalize(data.position[0]),
                       normalize(data.position[1]));

  data.worldVector = mat2x3(mat3(gbufferModelViewInverse) * data.vector[0],
                            mat3(gbufferModelViewInverse) * data.vector[1]);

  data.lightmap = vec2(DecodeVec2(color2.y).x, DecodeVec2(color2.y).y);

  data.roughness = DecodeVec2(color2.z).x;
  data.f0 = DecodeVec2(color2.z).y;

  #ifdef TEMPORAL_AA
  data.dither = fract((bayer64(gl_FragCoord.xy) * 8 + frameCounter * 2) / 8);
  #else
	data.dither = bayer64(gl_FragCoord.xy);
  #endif

  return data;
}

Material renderMaterial(float ID, vec2 depth){
  Material material;

  material.isGrass = ID > 1.99 && ID < 2.01;
  material.isLeaves = ID > 2.5 && ID < 3.5;

  material.isWater = ID > 3.5 && ID < 4.5;
  material.isIce = ID > 4.5 && ID < 5.5;
  material.isStainedGlass = ID > 5.5 && ID < 6.5;

  material.isTorch = ID > 6.5 && ID < 7.5;
  material.isFire = ID > 7.5 && ID < 8.5;
  material.isRedstone = ID > 8.5 && ID < 9.5;
  material.isLava = ID > 9.5 && ID < 10.5;
  material.isGlowstone = ID > 10.5 && ID < 11.5;
  material.isSealantern = ID > 11.5 && ID < 12.5;
  material.beaconBeam = ID > 15.5 && ID < 16.5;

  material.rain = ID > 12.5 && ID < 13.5;
  material.selection = ID > 13.5 && ID < 14.5;
  material.particles = ID > 14.5 && ID < 15.5;
  material.hand = ID > 16.5 && ID < 17.5;

  material.isSky = depth.x >= 1.0;
  material.isTranslucent = depth.x < depth.y;

  return material;
}