struct reflectionSettings{
  int steps0;
  int steps1;

  float refinements;
};

reflectionSettings renderReflectionSettings(){
  reflectionSettings r;
  
  r.steps0 = SPEC_QUALITY;          //SSR quality
  r.steps1 = SPEC_ROUGH_QUALITY;    //Roughness quality
  r.refinements = 16;

  return r;
}

void renderReflectionVector(DataBuffer data, vec3 lightVector, out vec3 vector, out vec3 worldVector, out float VdotN, out float NdotV, out float VdotL, bool rough){
  if(rough){
    VdotN = abs(dot(-data.vector[1], lightVector));

    vector = (2 * VdotN) * data.normal + data.vector[1];
    worldVector = mat3(gbufferModelViewInverse) * vector;

    NdotV = clamp01(dot(data.normal, vector));
    VdotL = dot(vector, lightVector);

  } else {
    VdotN = clamp01(dot(-data.vector[1], data.normal));

    vector = (2 * VdotN) * data.normal + data.vector[1];
    worldVector = mat3(gbufferModelViewInverse) * vector;

    NdotV = clamp01(dot(data.normal, vector));
    VdotL = dot(vector, lightVector);
  }
}

#include "/program/light/common/shadow.glsl"
#include "/program/light/common/specular/raytracer.glsl"
#include "/program/light/common/specular/roughness.glsl"

vec3 renderTranslucentReflection(vec3 color, DataBuffer data, Material material){
  reflectionSettings r = renderReflectionSettings();

  data.f0 = toGamma(data.f0);
  
  float diffuse = clamp01(dot(data.worldNormal, worldLightVector));
  vec3 shadow = renderShadow(diffuse, data.worldPosition[0], data.dither, true);
  #ifdef CLOUD_SHADOW
       shadow *= renderCloudShadow(data.worldPosition[0] + cameraPosition, worldLightVector, 1);
  #endif

  vec3 fresnel, reflection;
  vec3 vector, worldVector;
  float VdotN, NdotV, VdotL;

  renderReflectionVector(data, lightVector, vector, worldVector, VdotN, NdotV, VdotL, false);

  fresnel = renderFresnel(data.f0, 1.0, VdotN);
  reflection = renderSSR(r, data, material, data.position[0], vector, worldVector, NdotV, data.dither, data.depth.x) * fresnel;
  reflection += renderSpecularGGX(data.normal, lightVector, data.vector[0], data.f0, pow3(data.roughness)) * fresnel * shadow * (sunlight + moonlight);

  return color * (1 - fresnel) + reflection;
}

vec3 renderReflection(vec3 color, DataBuffer data, Material material){
  if(data.f0 < 0.005) return color;
  
  vec3 translucent = renderTranslucentReflection(color, data, material);
  vec3 rough = renderRoughnessReflection(color, data, material);
  
  vec3 reflection = data.roughness >= 0.03 ? rough : translucent;

  if(isEyeInWater > 0.01){
		reflection = renderVolumetricRayWater(reflection, data, material);
	} else {
		//reflection = renderVolumetricRay(reflection, data, material, false);
	}

  return reflection;
}