#include "/program/light/common/shadow.glsl"

vec3 renderSkylight(float lightmap, float cloudShadow, bool water){
  float skylightmap = exp(8 * (sqrt(lightmap) - 1));
        
  vec3 skylighting = FromSH(skySH[0], skySH[1], skySH[2], worldUpVector) * PI;
  #if defined VOLUME_CLOUDS || !defined CLOUD_SHADOW
       skylighting = mix(skylighting, vec3(0.35) * vec3(renderLuminance701(skylighting)), vec3((wetness * 0.75) - cloudShadow));
  #else
       skylighting = mix(skylighting, vec3(0.35) * vec3(renderLuminance701(skylight)), vec3(wetness * 0.85));
  #endif

  return skylighting * skylightmap * SHADOW_BRIGHTNESS;
  //return vec3(0);
}

float renderLightmap(float lightmap){
     lightmap = clamp01(lightmap);
     lightmap = pow(lightmap, 1 / 0.2);
     lightmap = pow2(lightmap) * 16;

     return lightmap;
}

float renderHeldLight(vec3 worldPosition, float lightmap){
  float lightPosition = 1.0 / (pow6(length(worldPosition)) + 0.0001);

  float lightID = heldItemId == 1001 || heldItemId == 1002 || heldItemId == 1003 || heldItemId == 1004 || heldItemId == 1005 || heldItemId == 1006 || heldItemId == 1007 ? 0.0 : 1.0;

  return lightmap * lightPosition * heldBlockLightValue * lightID;
}

vec4 renderIndirectFilter(sampler2D tex, vec2 coord, vec3 normal, float depth){
  const int steps = 2;
  const float rSteps = 1.0 / steps;

  vec4 color = vec4(0.0);
  float weight = 0.0;

  if(coord .x < 0 || coord.y < 0 || coord.x > 1 || coord.y > 1) return vec4(0.0);
  
  for(int i = -steps; i <= steps; ++i){
    for(int j = -steps; j <= steps; ++j){
      vec2 sampleCoord = coord + vec2(i, j) * rPixel;
      if(sampleCoord.x == 0 && sampleCoord.y == 0) continue;

      float sampleDepth = linearDepth(renderDepth(sampleCoord).y);
      vec3 sampleNormal = renderNormal(sampleCoord);

      float sampleWeight = clamp01(1 - abs(sampleDepth - depth));
            sampleWeight *= clamp01(dot(sampleNormal, normal) * 2 - 1);

      color += texture2DLod(tex, sampleCoord, 2) * sampleWeight;
      weight += sampleWeight;
    }
  }
  color /= weight;
  color = weight < 0.01 ? texture2DLod(tex, coord, 2) : color;
  color.rgb = (color.rgb) * 2;

  return color;
  //return texture2D(tex, coord);
}

vec3 renderDiffuse(vec3 color, vec3 normal, vec3 worldNormal, vec3 position, vec3 worldPosition, vec3 vector, vec3 worldVector, vec2 lightmap, vec2 depth, float dither, float roughness, float f0, float shadowParallax, Material material){
  if(material.isSky) return color;

  //f0 = toGamma(f0);

  #ifdef CLOUD_SHADOW
  float cloudShadow = renderCloudShadow(worldPosition + cameraPosition, worldLightVector, 1);
  #else
  float cloudShadow = 1.0;
  #endif

  worldNormal = material.isGrass ? worldUpVector : worldNormal;

  float VdotL = dot(worldVector, worldLightVector);
  float diffuse = renderDiffuseGGX(worldNormal, worldVector, worldLightVector, roughness);
        diffuse = material.isLeaves || material.isFire ? renderPhaseSSS(VdotL, diffuse) : diffuse;

  #if !defined VOLUME_CLOUDS || !defined CLOUD_SHADOW
        diffuse *= mix(1.0, 0.1, wetness);
  #endif

  vec3 shadow = diffuse > 0 ? renderShadow(diffuse, worldPosition, dither, false) : vec3(1);
       shadow *= cloudShadow * shadowParallax;

  vec4 indirect = renderIndirectFilter(colortex6, coord, normal, linearDepth(depth.y));
  #if !defined VOLUME_CLOUDS || !defined CLOUD_SHADOW
       indirect.rgb *= mix(1.0, 0.0, wetness);
  #endif

  vec3 final = vec3(0.0);
       final += shadow * diffuse * (sunlight + moonlight) * (transitionFading * 0.5);
       final += renderSkylight(lightmap.y, cloudShadow, material.isWater) * indirect.a;
       final += renderLightmap(lightmap.x) * torchlight;
       final += renderHeldLight(worldPosition, lightmap.x) * torchlight * indirect.a;
  #ifdef GI
       final += indirect.rgb * (sunlight + moonlight) * (transitionFading * 0.5) * cloudShadow;
  #endif
    
       #if TEXTURES == 0
       //final *= color;
       #endif

  vec3 ggx = renderSpecularGGX(worldNormal, worldLightVector, worldVector, f0, roughness) * 0.25 * rPI * (sunlight + moonlight) * shadow * (transitionFading * 0.5);
  #if !defined VOLUME_CLOUDS || !defined CLOUD_SHADOW
       ggx *= mix(1.0, 0.0, wetness);
  #endif

  //return renderBlendMaterial(final, ggx, color, f0);
  return (final * color) + ggx;
}
