//PBR volumetric Ray from robobo1221
//https://www.shadertoy.com/view/MstBWs

struct volumetricRayPosition{
  vec3 start;
  vec3 end;
};

struct waterFogSettings{
  vec3 waterScatterCoefficient;
  vec3 waterAbsorptionCoefficient;

  float density;
};

vec3 renderScatterIntergral(float opticalDepth, vec3 coeff){
  vec3 a = -1.0 / coeff;
  vec3 b =  1.0 / coeff;

  return exp2(-coeff * opticalDepth) * a + b;
}

float renderVolumeFog(vec3 position){
  const float altitude = VOLUME_FOG_ALTITUDE;
  const float scale = 1300 / altitude;
  const float thickness = 1200 / scale;

  float time = windFog * 0.045;
  vec3 movement = vec3(-time, 0.0, time);

  position.y -= dot(position.xz, position.xz) / earthSize;
  vec3 p = position * 0.0075 * scale + movement;

  const float d = 0.5;
  const float m = 3.0;
  const int octaves = 4;

  float h = (d / m) / octaves;

  vec3 shiftM = -movement * 0.013;

  float noise = renderVolumeFBM(p, movement);
  float height = position.y - altitude;
  float scaleHeight = height / thickness;
  float heighAtten = remap(scaleHeight, 0.0, 0.2, 0.0, 1.0) * remap(scaleHeight, 0.8, 1.0, 1.0, 0.0);

  return max0(noise * heighAtten - (1 * heighAtten * scaleHeight * 0.5 + 0.5)) * exp2(-max0(height) * 0.35) * (VOLUME_FOG_DENSITY * scale);
}

vec2 renderDensity(vec3 position){
  const float level = 62;
  const float scale = 55;

  #if !defined VOLUME_CLOUDS || !defined CLOUD_SHADOW
  float wet = mix(1, 0, wetness);
  #else
  float wet = 1;
  #endif

  vec2 opticalDepth = exp2(-(position.y - level) * rScaleHeigh * vec2(scale, 1)) * scale;
       opticalDepth.y += exp2(-(position.y - level) * 0.025) * 125 * wet;

  #ifdef VOLUME_FOG
    #ifdef VOLUME_FOG_MORNING_ONLY
       opticalDepth += renderVolumeFog(position) * vec2(500, 2500) * sunRise;
    #else 
       opticalDepth += renderVolumeFog(position) * vec2(500, 2500);
    #endif
  #endif

  return opticalDepth;
}

vec3 renderVolumetricRayShadow(vec3 position, vec3 shadowPosition){
  const float lod = 1;

  vec3 shadow = vec3(0.0);

  shadowPosition = renderShadowDistortPosition(shadowPosition) * 0.5 + 0.5;

  if(any(greaterThanEqual(abs(shadowPosition), vec3(1)))) return vec3(1);

  vec2 depth = vec2(texture2DLod(shadowtex0, shadowPosition.xy, lod).x, texture2DLod(shadowtex1, shadowPosition.xy, lod).x);

  vec4 color0 = texture2DLod(shadowcolor0, shadowPosition.xy, lod);
  vec4 color1 = texture2DLod(shadowcolor1, shadowPosition.xy, lod);

  float shadow0 = float(depth.x > shadowPosition.z);
  float shadow1 = float(depth.y > shadowPosition.z);

  #ifdef COLOR_SHADOW
    shadow += mix(vec3(shadow0), toGamma(color0.xyz), clamp01(shadow1 - shadow0));
  #else
    shadow += shadow1;
  #endif

  #ifdef CLOUD_SHADOW
    shadow *= renderCloudShadow(position + cameraPosition, worldLightVector, 1.11);
  #endif

  return shadow;
}

vec3 renderVolumetricRay(vec3 color, DataBuffer data, Material material, bool translucent){
  #ifndef VOLUMETRIC_RAY
  return color;
  #endif

  const int steps = VOLUMETRIC_RAY_QUALITY;
  const float rSteps = 1.0 / steps;

  volumetricRayPosition p;
  
  if(translucent){
    p.start = data.worldPosition[0];
    p.end = data.worldPosition[1];
  } else {
    p.start = gbufferModelViewInverse[3].xyz;
    p.end = data.worldPosition[0];
  }

  //start = material.isSky ? data.worldVector[1] * altitude / clamp(data.worldVector[1].y, 0.1, 1.0) : start;
  //end = material.isSky ? data.worldVector[1] * altitude / clamp(data.worldVector[1].y, 0.1, 1.0) : start;

  vec3 increment = (p.end - p.start) * rSteps;
  vec3 position = increment * data.dither + p.start;

  vec3 shadowStart = renderShadowPosition(p.start);
  vec3 shadowEnd = renderShadowPosition(p.end);

  vec3 shadowIncrement = (shadowEnd - shadowStart) * rSteps;
  vec3 shadowPosition = shadowIncrement * data.dither + shadowStart;

  float VdotS = dot(data.vector[1], lightVector);
  vec2 phase = phase_Sky(VdotS, sky_mieg);

  vec3 direct = vec3(0);
  vec3 indirect = vec3(0);
  vec3 transmittance = vec3(1.0);
  
  for(int i = 0; i < steps; ++i, position += increment, shadowPosition += shadowIncrement){
    vec2 density = renderDensity(position + cameraPosition) * length(increment);
    vec3 opticalDepth = attenuationCoeff * vec3(density, 0);

    vec3 stepTransmittance = exp2(-opticalDepth);
    vec3 stepTransmittedFraction = clamp01((stepTransmittance - 1) / -opticalDepth);
    vec3 stepScatteringVisible = transmittance * stepTransmittedFraction;

    vec3 shadow = renderVolumetricRayShadow(position, shadowPosition);

    direct += scatteringCoeff * (density * phase) * stepScatteringVisible * shadow;
    indirect += scatteringCoeff * (density * 0.25 * PI) * stepScatteringVisible;

    transmittance *= stepTransmittance;
  }

  vec3 scattering = direct * (sunlight + moonlight) * transitionFading;
       scattering += indirect * weatherSkylight * ambientFog;

  return color * transmittance + scattering;
}

vec3 renderVolumetricRayWater(vec3 color, DataBuffer data, Material material){
  #ifndef WATER_FOG
  return color;
  #endif

  const int steps = WATER_FOG_QUALITY;
  const float rSteps = 1.0 / steps;

  volumetricRayPosition p;
  waterFogSettings w; 

  w.density = isEyeInWater > 0.5 ? 0.035 : 0.065;
  w.density *= WATER_DENSITY;
  
  w.waterAbsorptionCoefficient = -log(toGamma(vec3(15.0, 105.0, 150.0) / 255.0)) * w.density;

  if(material.isIce){
    w.waterScatterCoefficient = toGamma(vec3(35.0, 145.0, 255.0) / 255.0) * 0.1;
  } else {
    w.waterScatterCoefficient = toGamma(vec3(15.0 * WATER_COLOR_R, 175.0* WATER_COLOR_G, 255.0 * WATER_COLOR_B) / 255.0) * w.density;
  }
  
  p.start = isEyeInWater == 1 ? gbufferModelViewInverse[3].xyz : data.worldPosition[0];
  p.end = isEyeInWater == 1 ? data.worldPosition[0] : data.worldPosition[1];

  vec3 increment = (p.end - p.start) * rSteps;
  vec3 position = increment * data.dither + p.start;

  vec3 shadowStart = renderShadowPosition(p.start);
  vec3 shadowEnd = renderShadowPosition(p.end);

  vec3 shadowIncrement = (shadowEnd - shadowStart) * rSteps;
  vec3 shadowPosition = shadowIncrement * data.dither + shadowStart;

  float VdotS = dot(data.vector[1], lightVector);
  float phase = phase_mie(VdotS, 0.5) * 0.5 + 0.5;

  vec3 direct = vec3(0.0);
  vec3 indirect = vec3(0.0);
  vec3 transmittance = vec3(1.0);

  for(int i = 0; i < steps; ++i, position += increment, shadowPosition += shadowIncrement){
    vec3 opticalDepth = w.waterAbsorptionCoefficient * length(increment);
    vec3 scatter = exp2(-opticalDepth);

    vec3 stepTransmittance = clamp01((1.0 - scatter) / opticalDepth);

    vec3 shadow = renderVolumetricRayShadow(position, shadowPosition);

    direct += w.waterScatterCoefficient * opticalDepth * stepTransmittance * phase * shadow * transmittance;
    indirect += w.waterScatterCoefficient * (opticalDepth * 0.25 * PI) * stepTransmittance * transmittance;

    transmittance *= scatter;
  }
  vec3 scattering = direct * (sunlight + moonlight) * transitionFading;
       scattering += indirect * weatherSkylight;

  return color * transmittance + scattering;
}
