vec3 renderDensity(float centerDistance) {
	vec2 rayleighMie = exp(-centerDistance * rScaleHeigh + rScaledEarthSize);

  	float ozone = exp(-max0((45000.0 - centerDistance) - earthSize) / 5000) *
	              exp(-max0((centerDistance - 45000.0) - earthSize) / 50000);

	return vec3(rayleighMie, ozone);
}

vec3 renderTransmittance(vec3 position, vec3 direction, const float steps) {
	float rayLength = sqrt(pow2(dot(position, direction)) + atmosphereRadiusSquared - dot(position, position)) - dot(position, direction);
	float sampleLength = rayLength / steps;

	vec3 increment = direction * sampleLength;
	position += 0.5 * increment;

	vec3 airmass = vec3(0.0);

	for(int i = 0; i < steps; ++i, position += increment){
		airmass += renderDensity(length(position)) * sampleLength;
	}

	return exp2(-attenuationCoeff * airmass);
}

vec3 renderTransmittance(vec3 vector, const int steps){
	vec3 viewPosition = (earthSize + eyeAltitude) * worldUpVector;

  	vec2 aid = rsi(viewPosition, vector, atmosphereRadius);
  	vec2 pid = rsi(viewPosition, vector, earthSize * 0.9995);
	bool planetIntersected = pid.y >= 0.0;

  	vec2 sd = vec2((planetIntersected && pid.x < 0.0) ? pid.y : max0(aid.x), (planetIntersected && pid.x > 0.0) ? pid.x : aid.y);

	float stepSize = (sd.y - sd.x) / steps;
	vec3 increment = vector * stepSize;
	vec3 position  = vector * sd.x + (increment * 0.3 + viewPosition);

	vec3 transmittance = vec3(1.0);

  	for(int i = 0; i < steps; ++i, position += increment) {
		vec3 density = renderDensity(length(position));
		if (density.y > 1e35) break;

		vec3 stepAirmass = density * stepSize;
		vec3 stepOpticalDepth = attenuationCoeff * stepAirmass;

		transmittance *= exp2(-stepOpticalDepth);
  	}

  	transmittance = planetIntersected ? vec3(0.0) : transmittance;

  	return max0(transmittance);
}
