float phase_mie(float c, float g) {
	float gg = g * g;
  float cc = c * c;

	return (3.0 / (4.0 * PI) * (1.0 - gg) / (2.0 + gg)) * (1.0 * cc) / pow(1.0 + gg - 2.0 * g * c, 1.5);
}

float phase_mie2(float c, float g) {
	float gg = g * g;
  float cc = c * c;

	float p1 = (0.375 * (1.0 - gg)) / (PI * (2.0 * gg));
  float p2 = (cc + 1.0) * pow(-2.0 * g * c + 1.0 + gg, -1.5);

  return p1 * p2;
}

float phase2Lobes(float c){
  const float a = 0.80;
  const float m = 0.75;

	float lobe1 = phase_mie2(c, 0.80 * a);
  float lobe2 = phase_mie2(c, -0.35 * a);

  return mix(lobe2, lobe1, m);
}

float renderPhaseSSS(float VdotL, float diffuse){
  const float a = 0.45;

  float phase0 = phase_mie(VdotL, 0.25);
  float phase1 = phase_mie(VdotL, -0.10) * PI;

  return mix(max(phase0, phase1), a, a);
}

float phase_reyleigh(float c){
  float mult = (3 / (16 * PI)) * rPI;

	return c * c * mult + mult;
}

vec2 phase_Sky(float c, const float g){
	return vec2(phase_reyleigh(c), phase_mie2(c, g));
}