const float sky_mieg = 0.76;

const float earthSize = 6371e3;
const float sunRadius = 1.545;
const float moonRadius = 0.568;

const float atmosphereHeight = 110e3;
const vec2 scaleHeight = vec2(8e3, 1.2e3);

const vec3 rayleighCoeff = 2 * vec3(5.80e-6, 1.35e-5, 3.31e-5);
const vec3 mieCoeff = vec3(2e-6);
const vec3 ozoneCoeff = (vec3(4.36820899679147E-21, 3.31405330400124E-21, 1.42214627365509E-22) / 10000) * (2.5035422e25 * exp2(-35e3 / 8e3) * 4e-6);

const vec2 rScaleHeigh = 1.0 / scaleHeight;
const vec2 rScaledEarthSize = earthSize * rScaleHeigh;

float atmosphereRadius = earthSize + atmosphereHeight;
float atmosphereRadiusSquared = pow2(atmosphereRadius);

const mat2x3 scatteringCoeff = mat2x3(rayleighCoeff, mieCoeff * 1.11);
const mat3 attenuationCoeff = mat3(rayleighCoeff, mieCoeff, ozoneCoeff);

const vec3 sunLux = vec3(1, 0.975, 0.965) * 128e3 * SUNLIGHT_BRIGHTNESS;
const vec3 moonLux = vec3(4) * MOONLIGHT_BRIGHTNESS;