float renderSSAO(vec3 position, vec3 normal, float dither){
  const int steps = AO_QUALITY;

  float radius = 0.085 * -position.z;
  float thickness = 0.15 * -position.z;

  float ao = 1;

  for(int i = 0; i < steps; ++i){
    float sampleOffset0 = i + dither;
    float sampleOffset1 = sampleOffset0 / steps;

    float lon = goldenAngle * sampleOffset0 * 6;
    float lat = asin(sampleOffset1 * 2 - 1);

    vec3 kernel = vec3(cos(lat) * cos(lon), sin(lat), cos(lat) * sin(lon));
         kernel = normalize(kernel + normal);

    vec3 samplePosition = kernel * radius + position;
    vec3 sampleScreenPosition = renderScreenPosition(samplePosition);

    float sampleDepth = renderViewPosition(sampleScreenPosition.xy, renderDepth(sampleScreenPosition.xy).y).z;

    if(sampleDepth - samplePosition.z > 0 && sampleDepth - samplePosition.z < thickness){
      ao += 0.75 * clamp01(dot(kernel, normal) * 0.5 + 0.5);
    }
  }

  ao /= steps;
  ao = 1 - ao;

  #ifdef AO
  return pow(ao, 1.45);
  #else
  return 1;
  #endif
}