#if defined vertex
out vec2 coord;

out vec3 position;
out vec3 worldPosition;

out vec4 color;

flat out float mask;
#include "/program/gbuffers/common/curve.vsh"

void main(){
  coord = gl_MultiTexCoord0.xy;

  position = transMAD(gl_ModelViewMatrix, gl_Vertex.xyz);
  worldPosition = renderEarthCurvature(transMAD(gbufferModelViewInverse, position));
  position = transMAD(gbufferModelView, worldPosition);

  color = gl_Color;

  mask = 1.0;
  mask = 13.0;
  mask = floor(mask) / 32;

  gl_Position = position.xyzz * diagonal4(gl_ProjectionMatrix) + gl_ProjectionMatrix[3];
  gl_Position.xy = jitter * gl_Position.w +  gl_Position.xy;
}
#elif defined fragment
in vec2 coord;

in vec4 color;

flat in float mask;

void main(){
  /* DRAWBUFFERS:02 */
  gl_FragData[0].rgb = vec3(0.0);
  gl_FragData[0].a = wetness > 0.5 ? texture2D(texture, coord).a * color.a : 0.0;
  gl_FragData[1] = vec4(0.0, 0.0, 0.0, EncodeVec2(1.0 - mask, 1.0));
}
#endif
