#if defined vertex

out vec2 coord;
out vec2 lmcoord;

out vec3 position;
out vec3 worldPosition;
out vec3 normal;

out vec4 color;

flat out float material;

flat out mat3 tbn;

#include "/program/gbuffers/common/curve.vsh"
#include "/program/gbuffers/common/displacement.vsh"
#include "/program/gbuffers/common/tbn.vsh"

void main(){

  coord = gl_MultiTexCoord0.xy;
  lmcoord = gl_MultiTexCoord1.xy / 255.0;

  position = transMAD(gl_ModelViewMatrix, gl_Vertex.xyz);
  worldPosition = renderVertexDisplacement(transMAD(shadowModelViewInverse, position));
  worldPosition = renderEarthCurvature(worldPosition);
  position = transMAD(shadowModelView, worldPosition);
  normal = normalize(gl_NormalMatrix * gl_Normal);

  if(blockEntityId == 1019 || normal.z < 0.0){
    gl_Position = vec4(-1);
    return;
  }

  color = gl_Color;

  material = mc_Entity.x;

  tbn = renderTBN(gl_Normal);

  gl_Position = position.xyzz * diagonal4(gl_ProjectionMatrix) + gl_ProjectionMatrix[3];
  gl_Position.xyz = renderShadowDistortPosition(gl_Position.xyz);
}
#elif defined fragment

in vec2 coord;
in vec2 lmcoord;

in vec3 position;
in vec3 worldPosition;
in vec3 normal;

in vec4 color;

flat in float material;

flat in mat3 tbn;

bool isWater = material == 1006 || material == 5001;
bool isIce = material == 1007;
bool isStainedGlass = material == 1008;
bool isSlime = material == 10081;

#include "/program/gbuffers/common/waterNormal.glsl"

float renderWaterCaustics(vec3 worldPosition){
  vec3 waterNormal = renderWaveNormal(worldPosition + cameraPosition);
  vec3 refractPosition = 2 * refract(-shadowLightVector, waterNormal, 0.85);

  float oldPosition = length(dFdx(worldPosition)) * length(dFdy(worldPosition));
  float newPosition = length(dFdx(refractPosition)) * length(dFdy(refractPosition));

  return sqrt(0.5 * sqrt(oldPosition / newPosition * 0.2));
}

vec4 renderAlbedo(vec3 worldPosition){
  vec4 data0 = texture2D(texture, coord);
  if(data0.a < 0.301) discard;

  vec4 albedo = data0 * color;

  albedo = normal.z < 0 ? vec4(0, 0, 0, 1) : albedo;
	albedo = isWater || isIce ? vec4(1, 1, 1, 1) : albedo;
  albedo.rgb = isStainedGlass || isSlime ? albedo.rgb * -albedo.a + albedo.rgb : albedo.rgb;

  return albedo;
}

vec3 renderNormal(){
  return isWater ? tbn * renderWaveNormal(worldPosition + cameraPosition) : normal;
}

void main(){
  gl_FragData[0] = renderAlbedo(worldPosition + cameraPosition);
  gl_FragData[1].xyz = renderNormal() * 0.5 + 0.5;
  gl_FragData[1].w = lmcoord.y * 0.5 + 0.5;
}
#endif
