#if defined vertex
out vec2 coord;

out vec4 color;

#include "/program/gbuffers/common/curve.vsh"

void main(){
  coord = gl_MultiTexCoord0.xy;

  vec3 position = transMAD(gl_ModelViewMatrix, gl_Vertex.xyz);
  vec3 worldPosition = renderEarthCurvature(transMAD(gbufferModelViewInverse, position));
       position = transMAD(gbufferModelView, worldPosition);

  color = gl_Color;

  gl_Position = position.xyzz * diagonal4(gl_ProjectionMatrix) + gl_ProjectionMatrix[3];
}
#elif defined fragment
in vec2 coord;

in vec4 color;

vec4 data0 = texture2D(texture, coord);

vec4 renderAlbedo(){
  if(data0.a < 0.301) discard;
  vec4 albedo = data0 * color;

  #if TEXTURES == 1
  albedo = vec4(vec3(1.0), albedo.a);
  #endif

  return albedo;
}

void main(){
  /* DRAWBUFFERS:02 */
  gl_FragData[0] = renderAlbedo();
  gl_FragData[1] = vec4(EncodeNormal(vec3(0.0)), EncodeVec2(0.0, 0.0), EncodeVec2(0.0, 0.0), EncodeVec2(1.0, 1.0));
}
#endif
