struct waveSettings{
  float length;
  float amplitude;
  float steepness;
  float time;
};

waveSettings renderWavesSettings(){
  waveSettings w;

  w.length = 5;
  w.amplitude = 0.05;
  w.steepness = 0.8;
  w.time = windWater * 0.45;

  return w;
}

float renderWaves(vec3 position){
  waveSettings w = renderWavesSettings();

  const float r = 0.45;
  const vec2 sc = vec2(sin(r), cos(r));
  const mat2 rot = mat2(sc.y, -sc.x, sc.x, sc.y);

  vec2 direction = vec2(0.6, -0.4);
  vec2 anpos = position.xz * 0.015;

  float waves = 0.0;

  for (int i = 0; i < WATER_QUALITY; ++i, direction *= rot, anpos *= rot){
    vec2 noise = render2DNoise(anpos * inversesqrt(w.length)).xy * 2.0 - 1.0;

    float K = TAU / w.length;
    float W = sqrt(20 / K);
    float X = K * dot(direction, position.xz + noise * sqrt(w.length)) - W * w.time;

    waves += w.amplitude * pow(sin(X) * 0.5 + 0.5, w.steepness) - noise.x * w.amplitude;

    w.length *= 0.75;
    w.amplitude *= 0.60;
    w.steepness *= 1.00;
  }
  
  return -waves;
}

#if defined water
vec2 renderParallaxWater(vec3 position, vec3 tangentVec){
  const int steps = 5;
  const float inverseSteps = inversesqrt(steps);
  const float height = WAVE_HEIGHT;

  float waves = renderWaves(position);

  vec3 increment = inverseSteps * tangentVec / -tangentVec.z;
  vec3 sampleOffset = -waves * increment;

  waves = renderWaves(position + vec3(sampleOffset.x, sampleOffset.y, 0.0)) * height;

  for(int i = 1; i < steps && waves < sampleOffset.z; ++i){
	sampleOffset += (sampleOffset.z - waves) * increment;
	waves = renderWaves(position + vec3(sampleOffset.x, sampleOffset.y, 0.0)) * height;
  }

  if(steps > 1){
	sampleOffset.xy += (sampleOffset.z - waves) * increment.xz;
  }

  position.xz += sampleOffset.xy;

  return position.xz;
}
#endif

vec3 renderWaveNormal(vec3 position){
  const float delta = 0.025;
  const float inverseDelta = 1.0 / delta;

  vec2 wave;
       wave.x = renderWaves(position + vec3(delta, 0.0, -delta));
       wave.y = renderWaves(position + vec3(-delta, 0.0, delta));
       wave -= renderWaves(position - vec3(delta, 0.0, delta));

  vec3 normal = vec3(-wave.x, -wave.y, 2 * delta);

  return normalize(normal);
}
