float renderPuddlesRain(vec3 position){
  if(wetness < 0.01) return 0.0;

  position.xz = position.xz * 0.0015;

  float lightmap = pow2(sqrt(lmcoord.y));
        lightmap = exp(8 * (lightmap - 1));

  float noise = texture2D(noisetex, position.xz).x * 0.5;
        noise += texture2D(noisetex, position.xz * 2).x * 0.25;
        noise += texture2D(noisetex, position.xz * 7).x * 0.125;
        noise += texture2D(noisetex, position.xz * 16).x * 0.0625;

  float puddles = clamp01(noise * (2 * clamp01(wetness * 3)) - 0.45);
        puddles *= clamp01(dot(normal, vec3(0.0, 1.0, 0.0)));
        puddles *= lightmap;

  return puddles;
}
