#if defined terrain
struct parallaxSettings{
    float depth;
    float height;
    float minSample;
    float maxSample;
};

parallaxSettings renderParallaxSettings(){
    parallaxSettings p;

    float depth = 1;
    float minSample = 0;
    float maxSample = 32;

    return p;
}

vec2 renderPOM(vec2 coord, mat2 texD, inout float shadow){
    parallaxSettings p = renderParallaxSettings();

    float depth = parallaxDepth * p.depth;

    float layers = mix(p.minSample, p.maxSample, abs(dot(vec3(0, 0, 1), tangentView)));
    float layerDepth = 1 / layers;

    float currentLayer = 0;

    vec2 position = tangentView.xy / tangentView.z * depth;
    vec2 delta = position / layers;
    vec2 currentCoord = coord;

    float height = texture2DGrad(normals, currentCoord, texD[0], texD[1]).a;

    while(currentLayer < height){
        currentCoord -= delta;
        height = texture2DGrad(normals, currentCoord, texD[0], texD[1]).a;
        currentLayer += layerDepth; 
    }

    vec2 pCoord = currentCoord + delta;

    float depth0 = height - currentLayer;
    float depth1 = texture2DGrad(normals, pCoord, texD[0], texD[1]).a - currentLayer + layerDepth;

    float weight = depth0 / (depth0 - depth1);
    
    //return pCoord * weight + currentCoord * (1 - weight);
    return coord;
}
#endif

struct uniformData{
    vec4 data0;
    vec4 data1;
    vec4 data2;

    mat2 texD;
    float shadow;
};

uniformData renderUniformData(vec2 coord){
    uniformData d;

    d.texD = mat2(dFdx(coord), dFdy(coord));
    d.shadow = 1;

    #if defined terrain    
    d.data0 = texture2DGrad(texture, renderPOM(coord, d.texD, d.shadow), d.texD[0], d.texD[1]);
    d.data1 = texture2DGrad(normals, renderPOM(coord, d.texD, d.shadow), d.texD[0], d.texD[1]);
    d.data2 = texture2DGrad(specular, renderPOM(coord, d.texD, d.shadow), d.texD[0], d.texD[1]);
    #else
    d.data0 = texture2D(texture, coord);
    d.data1 = texture2D(normals, coord);
    d.data2 = texture2D(specular, coord);
    #endif

    return d;
}