vec3 wavingGround(vec3 position, bool tall){
  bool topVertex = coord.y < mc_midTexCoord.y;
  bool topBlock = mc_Entity.x == 1005 || mc_Entity.x == 4005;

  float doubleTall = 1.0;

  if (tall){
       doubleTall *= mix(float(topVertex) * 0.5, float(topVertex) * 0.5 + 0.5, float(topBlock));
  } else {
       doubleTall *= float(topVertex);
  }

  float t = windGrass * 0.45;

  vec2 noise = bicubicTexture(noisetex, position.xz / 8.0).xy;

  position.x += sin(position.z / 2.0) * 1.0;
  position.xz += noise;

  vec3 wind = vec3(0.0);

  float angleX = sin(t * 5.5 - position.x * 1.1 + noise.x * 2.0) * 2.0 + 2.0;
  float angleY = sin(t * 3.5 - position.x * 1.1 + noise.x * 16.0) * 0.4 + 0.0;

  wind.x += sin((angleX / 120.0) * PI);
  wind.z += sin((angleY / 120.0) * PI);
  wind.y += 1.0 - cos(((angleX + angleY) / 360.0) * PI);

  return wind * doubleTall;
}

vec3 wavingFire(vec3 viewPos){

  float t = TIME * 2.2;

  float magnitude = sin((t * 2.0) + viewPos.x + viewPos.z) * 1.5 + 1.5;

  float d0 = sin(t * 0.515015189115) * 3.0 - 2.0 + viewPos.z;
	float d1 = sin(t * 0.413367454418) * 3.0 - 2.0 + viewPos.x;
	float d2 = sin(t * 0.515015189115) * 3.0 - 2.0 + viewPos.x;
	float d3 = sin(t * 0.413367454418) * 3.0 - 2.0 + viewPos.z;

  vec3 wind = vec3(0.0);

  wind.x += sin((t * 0.24399475256) + (viewPos.x + d0) * 0.1 + (viewPos.z + d1) * 0.1 + viewPos.y) * (magnitude * 0.09 + 0.09);
	wind.z += sin((t * 0.24399475256) + (viewPos.z + d2) * 0.1 + (viewPos.x + d3) * 0.1 + viewPos.y) * (magnitude * 0.09 + 0.09);

  wind.x += sin((t * 1.24399475256) + (viewPos.x + d0) * 0.1 + (viewPos.z + d1) * 0.1 + viewPos.y) * (magnitude * 0.06 + 0.06);
	wind.z += sin((t * 1.24399475256) + (viewPos.y + d2) * 0.1 + (viewPos.x + d3) * 0.1 + viewPos.y) * (magnitude * 0.06 + 0.06);
  wind.y += sin((t * 0.24399475256) + (viewPos.z + d2) * 0.1 + (viewPos.x + d3) * 0.1 + viewPos.y) * 0.2 + 0.2;

  return wind * float(coord.y < mc_midTexCoord.y);
}

vec3 wavingLeaves(vec3 viewPos){
  float t = windLeaves * 1.2;

  float magnitude = sin((t * 2.0) + viewPos.x + viewPos.z) * 0.02 + 0.02;

  float d0 = sin(t * 0.367867992224) * 3.0 - 2.0;
  float d1 = sin(t * 0.295262467443) * 3.0 - 2.0;
  float d2 = sin(t * 0.233749453392) * 3.0 - 2.0;
  float d3 = sin(t * 0.316055598953) * 3.0 - 2.0;

	vec3 wind = vec3(0.0);

  wind.x += sin((t * 1.80499344071) + (viewPos.x + d0) * 0.5 + (viewPos.z + d1) * 0.5 + viewPos.y) * magnitude;
	wind.z += sin((t * 1.49332750285) + (viewPos.y + d2) * 0.5 + (viewPos.x + d3) * 0.5 + viewPos.y) * magnitude;
	wind.y += sin((t * 0.48798950513) + (viewPos.z + d2) * 0.5 + (viewPos.x + d3) * 0.5 + viewPos.y) * magnitude * 0.4;

  return wind;
}

vec3 renderVertexDisplacement(vec3 position){
  position += cameraPosition;

  #ifdef WAVING_TERRAIN
  switch(int(mc_Entity.x)) {
  	case 1010: position += wavingFire(position); break;
  	case 2002:
  	case 4002:
    case 1001: position += wavingGround(position, false); break;
    case 1004:
    case 1005:
    case 4004:
    case 4005: position += wavingGround(position, true); break;
    case 2001:
  	case 3001:
  	case 4001:
    case 1002: position += wavingLeaves(position); break;
  }
  #endif

  return position - cameraPosition;
}
