//Heat Waves from Kuda

void renderNetherHeatWaves(inout vec2 coord){
  float	refractionMultiplier = 0.0025;
	float	refractionSpeed	= 3.0;
	float refractionSize = 3.0;
	float refractionStart = 50.0;

	vec4 fragpos  = gbufferProjectionInverse * (vec4(coord.st, texture2D(depthtex1, coord.st).x, 1.0) * 2.0 - 1.0);
			 fragpos /= fragpos.w;

	float fogFactor = (1.0 - exp(-pow(length(fragpos.xyz) / refractionStart, 2.0)));

	coord += vec2(sin(frameTimeCounter * refractionSpeed + coord.x * 25.0 * refractionSize + coord.y * 25.0 * refractionSize)) * refractionMultiplier * fogFactor;
}
