const vec2 samples[40] = vec2[40](vec2(0.0, 0.0),
										              vec2(0.0, 0.4),
										              vec2(0.15, 0.37),
										              vec2(0.29, 0.29),
										              vec2(-0.37, 0.15),
										              vec2(0.4, 0.0),
									                  vec2(0.37, -0.15),
										              vec2(0.29, -0.29),
										              vec2(-0.15, -0.37),
										              vec2(0.0, 0.4),
										              vec2(-0.15, 0.37),
										              vec2(-0.29, 0.29),
										              vec2(0.37, 0.15),
										              vec2(-0.4, 0.0),
										              vec2(-0.37, -0.15),
										              vec2(-0.29, 0.29),

										              vec2(0.15, -0.37),
										              vec2(0.15, 0.37),
										              vec2(-0.37, 0.15),
										              vec2(0.37, -0.15),
										              vec2(-0.15, -0.37),
										              vec2(-0.15, 0.37),
										              vec2(0.37, 0.15),
										              vec2(-0.37, -0.15),

										              vec2(0.29, 0.29),
										              vec2(0.4, 0.0),
										              vec2(0.29, -0.29),
										              vec2(0.0, -0.4),
													  vec2(-0.29, 0.29),
													  vec2(-0.4, 0.0),
													  vec2(-0.29, -0.29),
													  vec2(0.0, 0.4),

													  vec2(0.29, 0.29),
										              vec2(0.4, 0.0),
										              vec2(0.29, -0.29),
										              vec2(0.0, -0.4),
													  vec2(-0.29, 0.29),
													  vec2(-0.4, 0.0),
													  vec2(-0.29, -0.29),
													  vec2(0.0, 0.4));

struct dofSettings{
	int steps;

	float maxBlur;
	float mipmap;
	float focal;
	float aperture;
	float strength;
	float chromaticAberrationStrength;
};

dofSettings renderDofSettings(){
	dofSettings d;

	d.steps = 40;

	d.maxBlur = 0.25;
	d.mipmap = 3;
	d.chromaticAberrationStrength = 3 * CHROMATIC_ABERRATION_STRENGTH;

	d.focal = (35 / FOCAL) * 0.04;
	d.aperture = (d.focal / APERTURE) * 0.9;

	return d;
}

vec4 renderDOF(vec2 coord){
	dofSettings d = renderDofSettings();

	vec3 color = vec3(0.0);
	float weight = 0.0;

	float depth = texture2D(depthtex1, coord).x;

	float focus = depth - centerDepthSmooth;
	float factor = focus * DOF_STRENGTH * 8 * d.focal;
		  factor = clamp(factor * d.aperture, -d.maxBlur, d.maxBlur);

	#ifdef DOF
	for(int i = 0; i < d.steps; ++i){
		float sampleLod = d.mipmap * abs(factor);
		float sampleWeight = 1.0 / (i + 1.0);

		#ifdef DOF_CHROMATIC_ABERRATION
		float sampleDistance = pow2(distance(coord, vec2(0.5)));

		vec2 sampleOffsetR = coord + (samples[i] + vec2(d.chromaticAberrationStrength * sampleDistance, 0)) * vec2(1, aspectRatio) * factor / d.steps;
		vec2 sampleOffsetG = coord + samples[i] * vec2(1, aspectRatio) * factor / d.steps;
		vec2 sampleOffsetB = coord + (samples[i] - vec2(d.chromaticAberrationStrength * sampleDistance, 0)) * vec2(1, aspectRatio) * factor / d.steps;

		float r = texture2DLod(colortex5, sampleOffsetR, sampleLod).r;
		float g = texture2DLod(colortex5, sampleOffsetG, sampleLod).g;
		float b = texture2DLod(colortex5, sampleOffsetB, sampleLod).b;

		color += vec3(r, g, b) * sampleWeight;
		#else
		vec2 sampleOffset = coord + samples[i] * vec2(1, aspectRatio) * factor / d.steps;

		color += texture2DLod(colortex5, sampleOffset, sampleLod).rgb * sampleWeight;
		#endif

		weight += sampleWeight;
	}

	return EncodeRGBE8(color / weight);
	#else
	return EncodeRGBE8(texture2D(colortex5, coord).rgb);
	#endif
}
