//Based on Bloom from Robobo1221
//https://www.shadertoy.com/view/lsBfRc

float lods[6] = float[6](2, 3, 4, 5, 6, 7);

#if defined composite1
vec3 renderTileBloom(vec2 coord, float lod){
  const int steps = 5;

  float expLod = exp2(lod);
  float offsets = exp2(-lod) * 1.5;

  vec2 sampleScale = rPixel * expLod;
  vec2 sampleCoord = (coord - offsets) * expLod;

  if(any(greaterThanEqual(abs(sampleCoord - 0.5), sampleScale + 0.5))) return vec3(0.0);

  vec3 bloom = vec3(0.0);
  float weight = 0.0;

  for(int i = -steps; i <= steps; ++i){
    for(int j = -steps; j <= steps; ++j){
      float sampleLength = clamp01(1 - length(vec2(i, j)) / steps);
      float sampleWeight = pow2(sampleLength);

      vec2 sampleOffset = sampleCoord + vec2(i, j) * sampleScale;

      bloom += texture2DLod(colortex5, sampleOffset, lod).rgb * sampleWeight;
      weight += sampleWeight;
    }
  }

  return bloom / weight;
}

vec4 renderBloom(vec2 coord){
  vec3 bloom = vec3(0.0);
  
  for(int i = 0; i < 7; ++i){
    bloom += renderTileBloom(coord, i + 1.5);
  }
  return EncodeRGBE8(bloom);
}
#elif defined composite2
vec3 renderBloom(vec3 color, vec2 coord, float avg){
	vec3 bloom = vec3(0.0);
  float weight = 0.0;

	#ifdef BLOOM
  for(int i = 0; i < 7; ++i){
    float sampleLod = exp2(-i - 1.5);
    float sampleOffset = sampleLod * 1.5;
    float sampleWeight = 1 / ((-i - 1.5) + 1);

    vec2 sampleCoord = (coord * sampleLod) + sampleOffset;

    bloom += DecodeColor(DecodeRGBE8(texture2D(colortex7, sampleCoord))) * sampleWeight;
    weight += sampleWeight;
  }
	#endif
		  
  float averageBloom = exp2(avg - 3) + BLOOM_STRENGTH;
        averageBloom = isEyeInWater == 1 ? averageBloom + 0.3 : averageBloom;
		    averageBloom = isEyeInWater == 2 ? averageBloom + 0.01 : averageBloom;

  return mix(color, bloom / weight, averageBloom);
}
#endif
