/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemSpeedloader
extends ItemInternalStorage
implements ITool,
IEItemInterfaces.IGuiItem,
IEItemInterfaces.IBulletContainer {
    public ItemSpeedloader() {
        super("speedloader", 1, new String[0]);
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 8;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            CommonProxy.openGuiForItem(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean isEmpty(ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                if (b.func_190926_b() || !(b.func_77973_b() instanceof ItemBullet) || !ItemNBTHelper.hasKey(b, "bullet")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getGuiID(ItemStack stack) {
        return 65;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    public int getBulletCount(ItemStack container) {
        return this.getSlotCount(container);
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver, boolean remote) {
        if (!remote && this.isEmpty(revolver)) {
            remote = true;
        } else if (remote && !ItemNBTHelper.hasKey(revolver, "bullets")) {
            remote = false;
        }
        if (!remote) {
            return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getSlotCount(revolver)));
        }
        return Utils.readInventory(ItemNBTHelper.getTag(revolver).func_150295_c("bullets", 10), this.getSlotCount(revolver));
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound ret = super.getNBTShareTag(stack);
        ret = ret == null ? new NBTTagCompound() : ret.func_74737_b();
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler != null) {
            NonNullList bullets = NonNullList.func_191197_a((int)this.getSlotCount(stack), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.getSlotCount(stack); ++i) {
                bullets.set(i, (Object)handler.getStackInSlot(i));
            }
            ret.func_74782_a("bullets", (NBTBase)Utils.writeInventory((Collection<ItemStack>)bullets));
        }
        return ret;
    }
}

