/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.smart.moving.SmartMovingClient;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingInfo;
import net.smart.moving.SmartMovingServer;
import net.smart.moving.config.SmartMovingClientConfig;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.moving.config.SmartMovingServerConfig;
import net.smart.render.SmartRenderContext;
import net.smart.render.statistics.SmartStatisticsContext;

public abstract class SmartMovingContext
extends SmartRenderContext {
    public static final float ClimbPullMotion = 0.3f;
    public static final double FastUpMotion = 0.2;
    public static final double MediumUpMotion = 0.14;
    public static final double SlowUpMotion = 0.1;
    public static final double HoldMotion = 0.08;
    public static final double SinkDownMotion = 0.05;
    public static final double ClimbDownMotion = 0.01;
    public static final double CatchCrawlGapMotion = 0.17;
    public static final float SwimCrawlWaterMaxBorder = 1.0f;
    public static final float SwimCrawlWaterTopBorder = 0.65f;
    public static final float SwimCrawlWaterMediumBorder = 0.6f;
    public static final float SwimCrawlWaterBottomBorder = 0.55f;
    public static final float HorizontalGroundDamping = 0.546f;
    public static final float HorizontalAirDamping = 0.91f;
    public static final float HorizontalAirodynamicDamping = 0.999f;
    public static final float SwimSoundDistance = 1.4285715f;
    public static final float SlideToHeadJumpingFallDistance = 0.05f;
    public static final SmartMovingClient Client = new SmartMovingClient();
    public static final SmartMovingOptions Options = new SmartMovingOptions();
    public static final SmartMovingServerConfig ServerConfig = new SmartMovingServerConfig();
    public static SmartMovingClientConfig Config = Options;
    private static boolean wasInitialized;
    private static MinecraftServer lastMinecraftServer;

    public static void onTickInGame() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e != null && minecraft.field_71441_e.field_72995_K) {
            SmartMovingFactory.handleMultiPlayerTick(minecraft);
        }
        Options.initializeForGameIfNeccessary();
        SmartMovingContext.initializeServerIfNecessary();
    }

    public static void initialize() {
        if (!wasInitialized) {
            SmartStatisticsContext.setCalculateHorizontalStats((boolean)true);
        }
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindGrab);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindConfigToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindSpeedIncrease);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindSpeedDecrease);
        if (wasInitialized) {
            return;
        }
        wasInitialized = true;
        System.out.println(SmartMovingInfo.ModComMessage);
        FMLLog.getLogger().info(SmartMovingInfo.ModComMessage);
    }

    public static void initializeServerIfNecessary() {
        MinecraftServer currentMinecraftServer = MinecraftServer.func_71276_C();
        if (currentMinecraftServer != null && currentMinecraftServer != lastMinecraftServer) {
            WorldSettings.GameType gameType;
            try {
                gameType = currentMinecraftServer.func_71265_f();
            }
            catch (Throwable t) {
                return;
            }
            SmartMovingServer.initialize(SmartMovingOptions.optionsPath, gameType.func_77148_a(), Options);
        }
        lastMinecraftServer = currentMinecraftServer;
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return SmartMovingContext.getState(world, x, y, z).func_177230_c();
    }

    public static IBlockState getState(World world, int x, int y, int z) {
        BlockPos position = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(position);
        Block block = state.func_177230_c();
        return block.func_176221_a(state, (IBlockAccess)world, position);
    }

    public static Material getMaterial(World world, int x, int y, int z) {
        return SmartMovingContext.getBlock(world, x, y, z).func_149688_o();
    }

    public static boolean getValue(IBlockState state, PropertyBool property) {
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public static int getValue(IBlockState state, PropertyInteger property) {
        return (Integer)state.func_177229_b((IProperty)property);
    }

    public static EnumFacing getValue(IBlockState state, PropertyDirection property) {
        return (EnumFacing)state.func_177229_b((IProperty)property);
    }

    public static Enum getValue(IBlockState state, PropertyEnum property) {
        return (Enum)((Object)state.func_177229_b((IProperty)property));
    }

    static {
        lastMinecraftServer = null;
    }
}

