/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.Orientation;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.config.SmartMovingOptions;

public abstract class SmartMovingBase
extends SmartMovingContext {
    public final EntityPlayer sp;
    public final EntityPlayerSP esp;
    public final IEntityPlayerSP isp;
    public static final int CollidedPositiveX = 1;
    public static final int CollidedNegativeX = 2;
    public static final int CollidedPositiveY = 4;
    public static final int CollidedNegativeY = 8;
    public static final int CollidedPositiveZ = 16;
    public static final int CollidedNegativeZ = 32;

    public SmartMovingBase(EntityPlayer sp, IEntityPlayerSP isp) {
        this.sp = sp;
        this.isp = isp;
        if (sp instanceof EntityPlayerSP) {
            this.esp = (EntityPlayerSP)sp;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                Options.resetForNewGame();
                Config = Options;
            }
        } else {
            this.esp = null;
        }
    }

    public Block getBlock(int x, int y, int z) {
        return SmartMovingBase.getBlock(this.sp.field_70170_p, x, y, z);
    }

    public IBlockState getState(int x, int y, int z) {
        return SmartMovingBase.getState(this.sp.field_70170_p, x, y, z);
    }

    public Material getMaterial(int x, int y, int z) {
        return SmartMovingBase.getMaterial(this.sp.field_70170_p, x, y, z);
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.sp.field_70170_p.func_175623_d(new BlockPos(x, y, z));
    }

    public AxisAlignedBB getBoundingBox() {
        return this.sp.func_174813_aQ();
    }

    public void setBoundingBox(AxisAlignedBB boundingBox) {
        this.sp.func_174826_a(boundingBox);
    }

    protected void moveFlying(float moveUpward, float moveStrafing, float moveForward, float speedFactor, boolean treeDimensional) {
        float diffMotionXStrafing = 0.0f;
        float diffMotionXForward = 0.0f;
        float diffMotionZStrafing = 0.0f;
        float diffMotionZForward = 0.0f;
        float total = MathHelper.func_76129_c((float)(moveStrafing * moveStrafing + moveForward * moveForward));
        if (total >= 0.01f) {
            if (total < 1.0f) {
                total = 1.0f;
            }
            float moveStrafingFactor = moveStrafing / total;
            float moveForwardFactor = moveForward / total;
            float sin = MathHelper.func_76126_a((float)(this.sp.field_70177_z * 3.141593f / 180.0f));
            float cos = MathHelper.func_76134_b((float)(this.sp.field_70177_z * 3.141593f / 180.0f));
            diffMotionXStrafing = moveStrafingFactor * cos;
            diffMotionXForward = -moveForwardFactor * sin;
            diffMotionZStrafing = moveStrafingFactor * sin;
            diffMotionZForward = moveForwardFactor * cos;
        }
        float rotation = treeDimensional ? this.sp.field_70125_A / 57.295776f : 0.0f;
        float divingHorizontalFactor = MathHelper.func_76134_b((float)rotation);
        float divingVerticalFactor = -MathHelper.func_76126_a((float)rotation) * Math.signum(moveForward);
        float diffMotionX = diffMotionXForward * divingHorizontalFactor + diffMotionXStrafing;
        float diffMotionY = MathHelper.func_76129_c((float)(diffMotionXForward * diffMotionXForward + diffMotionZForward * diffMotionZForward)) * divingVerticalFactor + moveUpward;
        float diffMotionZ = diffMotionZForward * divingHorizontalFactor + diffMotionZStrafing;
        float total2 = MathHelper.func_76129_c((float)(MathHelper.func_76129_c((float)(diffMotionX * diffMotionX + diffMotionZ * diffMotionZ)) + diffMotionY * diffMotionY));
        if (total2 > 0.01f) {
            float factor = speedFactor / total2;
            this.sp.field_70159_w += (double)(diffMotionX * factor);
            this.sp.field_70181_x += (double)(diffMotionY * factor);
            this.sp.field_70179_y += (double)(diffMotionZ * factor);
        }
    }

    protected Block supportsCeilingClimbing(int i, int j, int k) {
        IBlockState state = this.getState(i, j, k);
        if (state == null) {
            return null;
        }
        String name = state.func_177230_c().func_149739_a();
        if (name == null) {
            return null;
        }
        if (name.equals("tile.fenceIron")) {
            return state.func_177230_c();
        }
        if ((name.equals("tile.trapdoor") || name.equals("tile.trapdoor_iron")) && !SmartMovingBase.getValue(state, BlockTrapDoor.field_176283_b)) {
            return state.func_177230_c();
        }
        return null;
    }

    protected boolean isLava(Block block) {
        if (block == Block.func_149684_b((String)"lava") || block == Block.func_149684_b((String)"flowing_lava")) {
            return true;
        }
        return block != null && block.func_149688_o() == Material.field_151587_i;
    }

    protected float getLiquidBorder(int i, int j, int k) {
        Block block = this.getBlock(i, j, k);
        if (block == Block.func_149684_b((String)"water") || block == Block.func_149684_b((String)"flowing_water")) {
            return this.getNormalWaterBorder(i, j, k);
        }
        if (SmartMovingOptions.hasFiniteLiquid) {
            float f;
            float finiteLiquidBorder = this.getFiniteLiquidWaterBorder(i, j, k, block);
            if (f > 0.0f) {
                return finiteLiquidBorder;
            }
        }
        if (block == Block.func_149684_b((String)"lava") || block == Block.func_149684_b((String)"flowing_lava")) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? this.getNormalWaterBorder(i, j, k) : 0.0f;
        }
        Material material = this.getMaterial(i, j, k);
        if (material == null || material == Material.field_151587_i) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? 1.0f : 0.0f;
        }
        if (material == Material.field_151586_h) {
            return this.getNormalWaterBorder(i, j, k);
        }
        if (material.func_76224_d()) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected float getNormalWaterBorder(int i, int j, int k) {
        int level = SmartMovingBase.getValue(this.getState(i, j, k), BlockLiquid.field_176367_b);
        if (level >= 8) {
            return 1.0f;
        }
        if (level == 0) {
            if (this.getBlock(i, j + 1, k).func_149688_o() == Material.field_151579_a) {
                return 0.8875f;
            }
            return 1.0f;
        }
        return (float)(8 - level) / 8.0f;
    }

    protected float getFiniteLiquidWaterBorder(int i, int j, int k, Block block) {
        int type = Orientation.getFiniteLiquidWater(block);
        if (type > 0) {
            if (type == 2) {
                return 1.0f;
            }
            if (type == 1) {
                Block aboveBlock = SmartMovingBase.getBlock(this.sp.field_70170_p, i, j + 1, k);
                if (Orientation.getFiniteLiquidWater(aboveBlock) > 0) {
                    return 1.0f;
                }
                return (float)SmartMovingBase.getValue(this.getState(i, j, k), BlockLiquid.field_176367_b) / 16.0f;
            }
        }
        return 0.0f;
    }

    public boolean isFacedToLadder(boolean isSmall) {
        return this.getOnLadder(1, true, isSmall) > 0;
    }

    public boolean isFacedToSolidVine(boolean isSmall) {
        return this.getOnVine(1, true, isSmall) > 0;
    }

    public boolean isOnLadderOrVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, isSmall) > 0;
    }

    public boolean isOnVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, false, true, isSmall) > 0;
    }

    public boolean isOnLadder(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, true, false, isSmall) > 0;
    }

    protected int getOnLadder(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, false, isSmall);
    }

    protected int getOnVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, false, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean ladder, boolean vine, boolean isSmall) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int minj = MathHelper.func_76128_c((double)this.getBoundingBox().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        if (Config.isStandardBaseClimb()) {
            Block block = SmartMovingBase.getBlock(this.sp.field_70170_p, i, minj, k);
            if (ladder) {
                if (vine) {
                    return Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
                }
                return block != Block.func_149684_b((String)"vine") && Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
            }
            if (vine) {
                return block == Block.func_149684_b((String)"vine") && Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
            }
            return 0;
        }
        if (isSmall) {
            --minj;
        }
        HashSet<Orientation> facedOnlyTo = null;
        if (faceOnly) {
            facedOnlyTo = Orientation.getClimbingOrientations(this.sp, true, false);
        }
        int result = 0;
        int maxj = MathHelper.func_76128_c((double)(this.sp.func_174813_aQ().field_72338_b + Math.ceil(this.getBoundingBox().field_72337_e - this.getBoundingBox().field_72338_b))) - 1;
        for (int j = minj; j <= maxj; ++j) {
            IBlockState state = this.getState(i, j, k);
            if (ladder) {
                boolean localLadder = Orientation.isKnownLadder(state);
                Orientation localLadderOrientation = null;
                if (localLadder) {
                    localLadderOrientation = Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i, j, k);
                    if (facedOnlyTo == null || facedOnlyTo.contains((Object)localLadderOrientation)) {
                        ++result;
                    }
                }
                for (Orientation direction : facedOnlyTo != null ? facedOnlyTo : Orientation.Orthogonals) {
                    Orientation remoteLadderOrientation;
                    IBlockState remoteState;
                    if (result >= maxResult) {
                        return result;
                    }
                    if (direction == localLadderOrientation || !Orientation.isKnownLadder(remoteState = this.getState(i + direction._i, j, k + direction._k)) || (remoteLadderOrientation = Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i + direction._i, j, k + direction._k)).rotate(180) != direction) continue;
                    ++result;
                }
            }
            if (result >= maxResult) {
                return result;
            }
            if (vine && Orientation.isVine(state)) {
                if (facedOnlyTo == null) {
                    ++result;
                } else {
                    for (Orientation climbOrientation : facedOnlyTo) {
                        if (!climbOrientation.hasVineOrientation(this.sp.field_70170_p, i, j, k) || !climbOrientation.isRemoteSolid(this.sp.field_70170_p, i, j, k)) continue;
                        ++result;
                        break;
                    }
                }
            }
            if (result < maxResult) continue;
            return result;
        }
        return result;
    }

    public boolean climbingUpIsBlockedByLadder() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && Orientation.isLadder(this.getState(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.getBoundingBox().field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)))) {
            return Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i, j, k) == orientation;
        }
        return false;
    }

    public boolean climbingUpIsBlockedByTrapDoor() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && Orientation.isTrapDoor(this.getState(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.getBoundingBox().field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)))) {
            return Orientation.getOpenTrapDoorOrientation(this.sp.field_70170_p, i, j, k) == orientation;
        }
        return false;
    }

    public boolean climbingUpIsBlockedByCobbleStoneWall() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && this.getBlock(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.getBoundingBox().field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)) == Block.func_149684_b((String)"cobblestone_wall")) {
            return !((BlockWall)Block.func_149684_b((String)"cobblestone_wall")).func_176253_e((IBlockAccess)this.sp.field_70170_p, new BlockPos(i - orientation._i, j, k - orientation._k));
        }
        return false;
    }

    private List<?> getPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        AxisAlignedBB bb = this.getBoundingBox();
        bb = AxisAlignedBB.func_178781_a((double)bb.field_72340_a, (double)yMin, (double)bb.field_72339_c, (double)bb.field_72336_d, (double)yMax, (double)bb.field_72334_f);
        return this.sp.field_70170_p.func_72945_a((Entity)this.sp, horizontalTolerance == 0.0 ? bb : bb.func_72331_e(-horizontalTolerance, 0.0, -horizontalTolerance));
    }

    protected boolean isPlayerInSolidBetween(double yMin, double yMax) {
        return this.getPlayerSolidBetween(yMin, yMax, 0.0).size() > 0;
    }

    protected double getMaxPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List<?> solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMin;
        for (int i = 0; i < solids.size(); ++i) {
            AxisAlignedBB box = (AxisAlignedBB)solids.get(i);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.max(result, box.field_72337_e);
        }
        return Math.min(result, yMax);
    }

    protected double getMinPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List<?> solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMax;
        for (int i = 0; i < solids.size(); ++i) {
            AxisAlignedBB box = (AxisAlignedBB)solids.get(i);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.min(result, box.field_72338_b);
        }
        return Math.max(result, yMin);
    }

    protected boolean isInLiquid() {
        return this.getMaxPlayerLiquidBetween(this.getBoundingBox().field_72338_b, this.getBoundingBox().field_72337_e) != this.getBoundingBox().field_72338_b || this.getMinPlayerLiquidBetween(this.getBoundingBox().field_72338_b, this.getBoundingBox().field_72337_e) != this.getBoundingBox().field_72337_e;
    }

    protected double getMaxPlayerLiquidBetween(double yMin, double yMax) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int jMin = MathHelper.func_76128_c((double)yMin);
        int jMax = MathHelper.func_76128_c((double)yMax);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        for (int j = jMax; j >= jMin; --j) {
            float swimWaterBorder = this.getLiquidBorder(i, j, k);
            if (!(swimWaterBorder > 0.0f)) continue;
            return (float)j + swimWaterBorder;
        }
        return yMin;
    }

    protected double getMinPlayerLiquidBetween(double yMin, double yMax) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int jMin = MathHelper.func_76128_c((double)yMin);
        int jMax = MathHelper.func_76128_c((double)yMax);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        for (int j = jMin; j <= jMax; ++j) {
            float swimWaterBorder = this.getLiquidBorder(i, j, k);
            if (!(swimWaterBorder > 0.0f)) continue;
            if ((double)j > yMin) {
                return j;
            }
            if (!((double)((float)j + swimWaterBorder) > yMin)) continue;
            return yMin;
        }
        return yMax;
    }

    public boolean isCollided(AxisAlignedBB box, double yMin, double yMax, double horizontalTolerance) {
        return box.field_72336_d >= this.getBoundingBox().field_72340_a - horizontalTolerance && box.field_72340_a <= this.getBoundingBox().field_72336_d + horizontalTolerance && box.field_72337_e >= yMin && box.field_72338_b <= yMax && box.field_72334_f >= this.getBoundingBox().field_72339_c - horizontalTolerance && box.field_72339_c <= this.getBoundingBox().field_72334_f + horizontalTolerance;
    }

    private boolean isHeadspaceFree(BlockPos pos, int height, boolean top) {
        for (int y = 0; y < height; ++y) {
            if (!this.isOpenBlockSpace(pos.func_177982_a(0, y, 0), top)) continue;
            return false;
        }
        return true;
    }

    protected boolean pushOutOfBlocks(double x, double y, double z, boolean top) {
        BlockPos blockpos = new BlockPos(x, y, z);
        double d3 = x - (double)blockpos.func_177958_n();
        double d4 = z - (double)blockpos.func_177952_p();
        int entHeight = Math.max(Math.round(this.sp.field_70131_O), 1);
        boolean inTranslucentBlock = this.isHeadspaceFree(blockpos, entHeight, top);
        if (inTranslucentBlock) {
            int b0 = -1;
            double d5 = 9999.0;
            if (!this.isHeadspaceFree(blockpos.func_177976_e(), entHeight, top) && d3 < d5) {
                d5 = d3;
                b0 = 0;
            }
            if (!this.isHeadspaceFree(blockpos.func_177974_f(), entHeight, top) && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                b0 = 1;
            }
            if (!this.isHeadspaceFree(blockpos.func_177978_c(), entHeight, top) && d4 < d5) {
                d5 = d4;
                b0 = 4;
            }
            if (!this.isHeadspaceFree(blockpos.func_177968_d(), entHeight, top) && 1.0 - d4 < d5) {
                d5 = 1.0 - d4;
                b0 = 5;
            }
            float f = 0.1f;
            if (b0 == 0) {
                this.sp.field_70159_w = -f;
            }
            if (b0 == 1) {
                this.sp.field_70159_w = f;
            }
            if (b0 == 4) {
                this.sp.field_70179_y = -f;
            }
            if (b0 == 5) {
                this.sp.field_70179_y = f;
            }
        }
        return false;
    }

    private boolean isOpenBlockSpace(BlockPos pos, boolean top) {
        return !this.sp.field_70170_p.func_180495_p(pos).func_177230_c().func_149721_r() && (!top || !this.sp.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c().func_149721_r());
    }

    public boolean isInsideOfMaterial(Material material) {
        if (SmartMovingOptions.hasFiniteLiquid && material == Material.field_151586_h) {
            int k;
            int j;
            double d = this.sp.field_70163_u + (double)this.sp.func_70047_e();
            int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
            Block l = this.getBlock(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d)), k = MathHelper.func_76128_c((double)this.sp.field_70161_v));
            if (l != null) {
                float f;
                float border = this.getFiniteLiquidWaterBorder(i, j, k, l);
                if (f > 0.0f) {
                    float f2 = 1.0f - border - 0.1111111f;
                    float f1 = (float)(j + 1) - f2;
                    return d < (double)f1;
                }
            }
            return false;
        }
        return this.isp.localIsInsideOfMaterial(material);
    }

    public int calculateSeparateCollisions(double x, double y, double z) {
        boolean flag;
        boolean isInWeb = this.isp.getIsInWebField();
        AxisAlignedBB boundingBox = this.sp.func_174813_aQ();
        boolean onGround = this.sp.field_70122_E;
        World worldObj = this.sp.field_70170_p;
        EntityPlayer _this = this.sp;
        float stepHeight = this.sp.field_70138_W;
        if (isInWeb) {
            isInWeb = false;
            x *= 0.25;
            y *= 0.0500000007450581;
            z *= 0.25;
        }
        double d6 = x;
        double d7 = y;
        double d8 = z;
        boolean bl = flag = onGround && this.isSneaking();
        if (flag) {
            double d9 = 0.05;
            while (x != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72317_d(x, -1.0, 0.0)).isEmpty()) {
                x = x < d9 && x >= -d9 ? 0.0 : (x > 0.0 ? (x -= d9) : (x += d9));
                d6 = x;
            }
            while (z != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72317_d(0.0, -1.0, z)).isEmpty()) {
                z = z < d9 && z >= -d9 ? 0.0 : (z > 0.0 ? (z -= d9) : (z += d9));
                d8 = z;
            }
            while (x != 0.0 && z != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72317_d(x, -1.0, z)).isEmpty()) {
                x = x < d9 && x >= -d9 ? 0.0 : (x > 0.0 ? (x -= d9) : (x += d9));
                d6 = x;
                z = z < d9 && z >= -d9 ? 0.0 : (z > 0.0 ? (z -= d9) : (z += d9));
                d8 = z;
            }
        }
        List list1 = worldObj.func_72945_a((Entity)_this, boundingBox.func_72321_a(x, y, z));
        AxisAlignedBB axisalignedbb = boundingBox;
        for (AxisAlignedBB axisalignedbb1 : list1) {
            y = axisalignedbb1.func_72323_b(boundingBox, y);
        }
        boundingBox = boundingBox.func_72317_d(0.0, y, 0.0);
        boolean flag1 = onGround || d7 != y && d7 < 0.0;
        for (AxisAlignedBB axisalignedbb2 : list1) {
            x = axisalignedbb2.func_72316_a(boundingBox, x);
        }
        boundingBox = boundingBox.func_72317_d(x, 0.0, 0.0);
        for (AxisAlignedBB axisalignedbb2 : list1) {
            z = axisalignedbb2.func_72322_c(boundingBox, z);
        }
        boundingBox = boundingBox.func_72317_d(0.0, 0.0, z);
        if (stepHeight > 0.0f && flag1 && (d6 != x || d8 != z)) {
            double d14 = x;
            double d10 = y;
            double d11 = z;
            AxisAlignedBB axisalignedbb3 = boundingBox;
            boundingBox = axisalignedbb;
            y = stepHeight;
            List list = worldObj.func_72945_a((Entity)_this, boundingBox.func_72321_a(d6, y, d8));
            AxisAlignedBB axisalignedbb4 = boundingBox;
            AxisAlignedBB axisalignedbb5 = axisalignedbb4.func_72321_a(d6, 0.0, d8);
            double d12 = y;
            for (AxisAlignedBB axisalignedbb6 : list) {
                d12 = axisalignedbb6.func_72323_b(axisalignedbb5, d12);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d12, 0.0);
            double d18 = d6;
            for (AxisAlignedBB axisalignedbb7 : list) {
                d18 = axisalignedbb7.func_72316_a(axisalignedbb4, d18);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(d18, 0.0, 0.0);
            double d19 = d8;
            for (AxisAlignedBB axisalignedbb8 : list) {
                d19 = axisalignedbb8.func_72322_c(axisalignedbb4, d19);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d19);
            AxisAlignedBB axisalignedbb13 = boundingBox;
            double d20 = y;
            for (AxisAlignedBB axisalignedbb9 : list) {
                d20 = axisalignedbb9.func_72323_b(axisalignedbb13, d20);
            }
            axisalignedbb13 = axisalignedbb13.func_72317_d(0.0, d20, 0.0);
            double d21 = d6;
            for (AxisAlignedBB axisalignedbb10 : list) {
                d21 = axisalignedbb10.func_72316_a(axisalignedbb13, d21);
            }
            axisalignedbb13 = axisalignedbb13.func_72317_d(d21, 0.0, 0.0);
            double d22 = d8;
            for (AxisAlignedBB axisalignedbb11 : list) {
                d22 = axisalignedbb11.func_72322_c(axisalignedbb13, d22);
            }
            axisalignedbb13 = axisalignedbb13.func_72317_d(0.0, 0.0, d22);
            double d23 = d18 * d18 + d19 * d19;
            double d13 = d21 * d21 + d22 * d22;
            if (d23 > d13) {
                x = d18;
                z = d19;
                boundingBox = axisalignedbb4;
            } else {
                x = d21;
                z = d22;
                boundingBox = axisalignedbb13;
            }
            y = -stepHeight;
            for (AxisAlignedBB axisalignedbb12 : list) {
                y = axisalignedbb12.func_72323_b(boundingBox, y);
            }
            boundingBox = boundingBox.func_72317_d(0.0, y, 0.0);
            if (d14 * d14 + d11 * d11 >= x * x + z * z) {
                x = d14;
                y = d10;
                z = d11;
                boundingBox = axisalignedbb3;
            }
        }
        boolean isCollidedPositiveX = d6 > x;
        boolean isCollidedNegativeX = d6 < x;
        boolean isCollidedPositiveY = d7 > y;
        boolean isCollidedNegativeY = d7 < y;
        boolean isCollidedPositiveZ = d8 > z;
        boolean isCollidedNegativeZ = d8 < z;
        int result = 0;
        if (isCollidedPositiveX) {
            ++result;
        }
        if (isCollidedNegativeX) {
            result += 2;
        }
        if (isCollidedPositiveY) {
            result += 4;
        }
        if (isCollidedNegativeY) {
            result += 8;
        }
        if (isCollidedPositiveZ) {
            result += 16;
        }
        if (isCollidedNegativeZ) {
            result += 32;
        }
        return result;
    }

    public boolean isSneaking() {
        return this.sp.func_70093_af();
    }

    public void correctOnUpdate(boolean isSmall, boolean reverseMaterialAcceleration) {
        double d = this.sp.field_70165_t - this.sp.field_70169_q;
        double d1 = this.sp.field_70161_v - this.sp.field_70166_s;
        float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        if (f < 0.05f && (double)f > 0.02 && isSmall) {
            float f5;
            float f4;
            float f1 = this.sp.field_70761_aq;
            f1 = (float)Math.atan2(d1, d) * 180.0f / 3.141593f - 90.0f;
            if (this.sp.field_70733_aJ > 0.0f) {
                f1 = this.sp.field_70177_z;
            }
            for (f4 = f1 - this.sp.field_70761_aq; f4 < -180.0f; f4 += 360.0f) {
            }
            while (f4 >= 180.0f) {
                f4 -= 360.0f;
            }
            float x = this.sp.field_70761_aq + f4 * 0.3f;
            for (f5 = this.sp.field_70177_z - x; f5 < -180.0f; f5 += 360.0f) {
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            if (f5 < -75.0f) {
                f5 = -75.0f;
            }
            if (f5 >= 75.0f) {
                f5 = 75.0f;
            }
            this.sp.field_70761_aq = this.sp.field_70177_z - f5;
            if (f5 * f5 > 2500.0f) {
                this.sp.field_70761_aq += f5 * 0.2f;
            }
            while (this.sp.field_70761_aq - this.sp.field_70760_ar < -180.0f) {
                this.sp.field_70760_ar -= 360.0f;
            }
            while (this.sp.field_70761_aq - this.sp.field_70760_ar >= 180.0f) {
                this.sp.field_70760_ar += 360.0f;
            }
        }
        if (reverseMaterialAcceleration) {
            this.reverseHandleMaterialAcceleration();
        }
    }

    protected double getGapUnderneight() {
        return this.getBoundingBox().field_72338_b - this.getMaxPlayerSolidBetween(this.getBoundingBox().field_72338_b - 1.1, this.getBoundingBox().field_72338_b, 0.0);
    }

    protected double getGapOverneight() {
        return this.getMinPlayerSolidBetween(this.getBoundingBox().field_72337_e, this.getBoundingBox().field_72337_e + 1.1, 0.0) - this.getBoundingBox().field_72337_e;
    }

    public double getOverGroundHeight(double maximum) {
        if (this.esp != null) {
            return this.getBoundingBox().field_72338_b - this.getMaxPlayerSolidBetween(this.getBoundingBox().field_72338_b - maximum, this.getBoundingBox().field_72338_b, 0.0);
        }
        return this.getBoundingBox().field_72338_b + 1.0 - this.getMaxPlayerSolidBetween(this.getBoundingBox().field_72338_b - maximum + 1.0, this.getBoundingBox().field_72338_b + 1.0, 0.1);
    }

    public Block getOverGroundBlockId(double distance) {
        int x = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.getBoundingBox().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        int minY = y - (int)Math.ceil(distance);
        if (this.esp == null) {
            ++y;
            ++minY;
        }
        while (y >= minY) {
            Block block = this.getBlock(x, y, z);
            if (block != null) {
                return block;
            }
            --y;
        }
        return null;
    }

    public void reverseHandleMaterialAcceleration() {
        int j1;
        World _this = this.sp.field_70170_p;
        AxisAlignedBB axisalignedbb = this.getBoundingBox().func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001);
        Material material = Material.field_151586_h;
        EntityPlayer entity = this.sp;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        if (!_this.func_175706_a(new BlockPos(i, k, i1), new BlockPos(j, l, j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0))), true)) {
            return;
        }
        Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = _this.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.func_149688_o() != material || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.func_149801_b((int)((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b))))))) continue;
                    vec3 = block.func_176197_a(_this, blockpos, (Entity)entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && entity.func_96092_aw()) {
            vec3 = vec3.func_72432_b();
            double d1 = -0.014;
            entity.field_70159_w += vec3.field_72450_a * d1;
            entity.field_70181_x += vec3.field_72448_b * d1;
            entity.field_70179_y += vec3.field_72449_c * d1;
        }
    }
}

