/*
 * Decompiled with CFR 0.152.
 */
package net.smart.core;

import java.util.ArrayList;

public class SmartCoreTransformation {
    public final String className;
    public final String methodName;
    public final String[] parameterTypeNames;
    public final String returnType;
    public final String hookClassName;
    public final String beforeHookMethodName;
    public final String afterHookMethodName;

    public SmartCoreTransformation(String className, String methodName, String[] parameterTypeNames, String returnType, String hookClassName, String beforeHookMethodName, String afterHookMethodName) {
        this.className = className;
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
        this.returnType = returnType;
        this.hookClassName = hookClassName;
        this.beforeHookMethodName = beforeHookMethodName;
        this.afterHookMethodName = afterHookMethodName;
    }

    private static String getDescription(String type) {
        if (type == null || type == "void") {
            return "V";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("double")) {
            return "D";
        }
        return "L" + type.replace(".", "/") + ";";
    }

    private static String getDescriptions(String[] parameterTypes) {
        String result = "";
        for (int i = 0; i < parameterTypes.length; ++i) {
            result = result + SmartCoreTransformation.getDescription(parameterTypes[i]);
        }
        return result + "";
    }

    private static String getMethodDescription(String[] parameterTypes, String resultType) {
        return "(" + SmartCoreTransformation.getDescriptions(parameterTypes) + ")" + SmartCoreTransformation.getDescription(resultType);
    }

    public String getMethodDesc() {
        return SmartCoreTransformation.getMethodDescription(this.parameterTypeNames, this.returnType);
    }

    public String getHookClassDesc() {
        return this.hookClassName.replace(".", "/");
    }

    public String getHookMethodDesc() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.className);
        for (int i = 0; i < this.parameterTypeNames.length; ++i) {
            names.add(this.parameterTypeNames[i]);
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return SmartCoreTransformation.getMethodDescription(result, null);
    }
}

