/*
 * Decompiled with CFR 0.152.
 */
package net.smart.core;

import net.smart.core.SmartCoreTransformation;
import org.objectweb.asm.MethodVisitor;

public class SmartCoreMethodVisitor
extends MethodVisitor {
    private final SmartCoreTransformation transformation;

    public SmartCoreMethodVisitor(MethodVisitor paramMethodVisitor, SmartCoreTransformation transformation) {
        super(262144, paramMethodVisitor);
        this.transformation = transformation;
        this.invokeHook(transformation.beforeHookMethodName);
    }

    public void visitInsn(int opcode) {
        if (opcode == 177 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176) {
            this.invokeHook(this.transformation.afterHookMethodName);
        }
        super.visitInsn(opcode);
    }

    private void invokeHook(String hookName) {
        if (hookName == null) {
            return;
        }
        this.mv.visitVarInsn(25, 0);
        int offset = 1;
        for (int i = 0; i < this.transformation.parameterTypeNames.length; ++i) {
            String typeName = this.transformation.parameterTypeNames[i];
            this.mv.visitVarInsn(SmartCoreMethodVisitor.LoadOpcode(typeName), offset);
            offset += SmartCoreMethodVisitor.LoadOffset(typeName);
        }
        this.mv.visitMethodInsn(184, this.transformation.getHookClassDesc(), hookName, this.transformation.getHookMethodDesc(), false);
    }

    private static int LoadOpcode(String typeName) {
        if (typeName.equals(Boolean.TYPE.getName()) || typeName.equals(Byte.TYPE.getName()) || typeName.equals(Short.TYPE.getName()) || typeName.equals(Integer.TYPE.getName())) {
            return 21;
        }
        if (typeName.equals(Long.TYPE.getName())) {
            return 22;
        }
        if (typeName.equals(Float.TYPE.getName())) {
            return 23;
        }
        if (typeName.equals(Double.TYPE.getName())) {
            return 24;
        }
        return 25;
    }

    private static int LoadOffset(String typeName) {
        if (typeName.equals(Long.TYPE.getName()) || typeName.equals(Double.TYPE.getName())) {
            return 2;
        }
        return 1;
    }
}

