/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smart.moving.ClimbGap;
import net.smart.moving.FeetClimbing;
import net.smart.moving.HandsClimbing;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

public class Orientation
extends SmartMovingContext {
    public static final Set<Orientation> Orthogonals = new HashSet<Orientation>();
    public static final Set<Orientation> Diagonals = new HashSet<Orientation>();
    public static final Set<Orientation> All = new HashSet<Orientation>();
    private static final Map<EnumFacing, Orientation> FacingToOrientation = new HashMap<EnumFacing, Orientation>();
    public static final Orientation ZZ = new Orientation(0, 0, new EnumFacing[0]);
    public static final Orientation PZ = new Orientation(1, 0, EnumFacing.WEST);
    public static final Orientation ZP = new Orientation(0, 1, EnumFacing.NORTH);
    public static final Orientation NZ = new Orientation(-1, 0, EnumFacing.EAST);
    public static final Orientation ZN = new Orientation(0, -1, EnumFacing.SOUTH);
    public static final Orientation PP = new Orientation(1, 1, EnumFacing.NORTH, EnumFacing.WEST);
    public static final Orientation NN = new Orientation(-1, -1, EnumFacing.SOUTH, EnumFacing.EAST);
    public static final Orientation PN = new Orientation(1, -1, EnumFacing.SOUTH, EnumFacing.WEST);
    public static final Orientation NP = new Orientation(-1, 1, EnumFacing.NORTH, EnumFacing.EAST);
    public static final int DefaultMeta = -1;
    public static final int VineFrontMeta = 0;
    public static final int VineSideMeta = 1;
    private static final int top = 2;
    private static final int middle = 1;
    private static final int base = 0;
    private static final int sub = -1;
    private static final int subSub = -2;
    private static final int NoGrab = 0;
    private static final int HalfGrab = 1;
    private static final int AroundGrab = 2;
    protected int _i;
    protected int _k;
    private boolean _isDiagonal;
    private Set<EnumFacing> _facings;
    private EnumFacing _facing;
    private float _directionAngle;
    private float _mimimumClimbingAngle;
    private float _maximumClimbingAngle;
    private static HashSet<Orientation> _getClimbingOrientationsHashSet = null;
    private static final float _handClimbingHoldGap = Math.min(0.25f, 0.06f * Math.max(((Float)Orientation.Config._freeClimbingUpSpeedFactor.value).floatValue(), ((Float)Orientation.Config._freeClimbingDownSpeedFactor.value).floatValue()));
    private static ClimbGap _climbGapTemp = new ClimbGap();
    private static ClimbGap _climbGapOuterTemp = new ClimbGap();
    private static World world;
    private static double base_jhd;
    private static double jh_offset;
    private static int all_j;
    private static int all_offset;
    private static int base_i;
    private static int base_k;
    private static double base_id;
    private static double base_kd;
    private static int remote_i;
    private static int remote_k;
    private static boolean crawl;
    private static int local_halfOffset;
    private static int local_half;
    private static int local_offset;
    private static boolean grabRemote;
    private static int grabType;
    private static Block grabBlock;
    private static int grabMeta;
    private static final Method _canConnectFenceTo;
    private static final Block[] _knownFanceGateBlocks;
    private static final Block[] _knownFenceBlocks;
    private static final Block[] _knownWallBlocks;
    private static final Block[] _knownHalfBlocks;
    private static final Block[] _knownCompactStairBlocks;
    private static final Block[] _knownTrapDoorBlocks;
    private static final Block[] _knownThinWallBlocks;
    private static final Class<?>[] _ladderKitLadderTypes;
    private static final Class<?> _blockCarpentersLadder;
    private static final Method _carpentersBlockPropertiesGetData;

    private Orientation(int i, int k, EnumFacing ... facings) {
        this._i = i;
        this._k = k;
        this._isDiagonal = this._i != 0 && this._k != 0;
        this.setClimbingAngles();
        this._facings = new HashSet<EnumFacing>();
        for (EnumFacing facing : facings) {
            this._facings.add(facing);
        }
        All.add(this);
        if (facings.length == 1) {
            this._facing = facings[0];
            Orthogonals.add(this);
            FacingToOrientation.put(this._facing, this);
        } else {
            Diagonals.add(this);
        }
    }

    public Orientation rotate(int angle) {
        if (this == ZZ) {
            throw new RuntimeException("unrotatable orientation");
        }
        switch (angle) {
            case 0: {
                return this;
            }
            case 45: {
                if (this == PZ) {
                    return PP;
                }
                if (this == PP) {
                    return ZP;
                }
                if (this == ZP) {
                    return NP;
                }
                if (this == NP) {
                    return NZ;
                }
                if (this == NZ) {
                    return NN;
                }
                if (this == NN) {
                    return ZN;
                }
                if (this == ZN) {
                    return PN;
                }
                if (this == PN) {
                    return PZ;
                }
                throw new RuntimeException("unknown orientation \"" + (Object)((Object)this) + "\"");
            }
            case -45: {
                if (this == PZ) {
                    return PN;
                }
                if (this == PN) {
                    return ZN;
                }
                if (this == ZN) {
                    return NN;
                }
                if (this == NN) {
                    return NZ;
                }
                if (this == NZ) {
                    return NP;
                }
                if (this == NP) {
                    return ZP;
                }
                if (this == ZP) {
                    return PP;
                }
                if (this == PP) {
                    return PZ;
                }
                throw new RuntimeException("unknown orientation \"" + (Object)((Object)this) + "\"");
            }
            case 90: {
                return this.rotate(45).rotate(45);
            }
            case -90: {
                return this.rotate(-45).rotate(-45);
            }
            case 135: {
                return this.rotate(180).rotate(-45);
            }
            case -135: {
                return this.rotate(-180).rotate(45);
            }
            case -180: 
            case 180: {
                if (this == PZ) {
                    return NZ;
                }
                if (this == PN) {
                    return NP;
                }
                if (this == ZN) {
                    return ZP;
                }
                if (this == NN) {
                    return PP;
                }
                if (this == NZ) {
                    return PZ;
                }
                if (this == NP) {
                    return PN;
                }
                if (this == ZP) {
                    return ZN;
                }
                if (this == PP) {
                    return NN;
                }
                throw new RuntimeException("unknown orientation");
            }
        }
        throw new RuntimeException("angle \"" + angle + "\" not supported");
    }

    public static Orientation getOrientation(EntityPlayer p, float tolerance, boolean orthogonals, boolean diagonals) {
        float maximumRotation;
        float minimumRotation;
        float rotation = p.field_70177_z % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if ((minimumRotation = rotation - tolerance) < 0.0f) {
            minimumRotation += 360.0f;
        }
        if ((maximumRotation = rotation + tolerance) >= 360.0f) {
            maximumRotation -= 360.0f;
        }
        if (orthogonals) {
            if (NZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return NZ;
            }
            if (PZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return PZ;
            }
            if (ZN.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZN;
            }
            if (ZP.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZP;
            }
        }
        if (diagonals) {
            if (NP.isWithinAngle(minimumRotation, maximumRotation)) {
                return NP;
            }
            if (PN.isWithinAngle(minimumRotation, maximumRotation)) {
                return PN;
            }
            if (NN.isWithinAngle(minimumRotation, maximumRotation)) {
                return NN;
            }
            if (PP.isWithinAngle(minimumRotation, maximumRotation)) {
                return PP;
            }
        }
        return null;
    }

    public double getHorizontalBorderGap(Entity entity) {
        return this.getHorizontalBorderGap(entity.field_70165_t, entity.field_70161_v);
    }

    private double getHorizontalBorderGap() {
        return this.getHorizontalBorderGap(base_id, base_kd);
    }

    private double getHorizontalBorderGap(double i, double k) {
        if (this == NZ) {
            return i % 1.0;
        }
        if (this == PZ) {
            return 1.0 - i % 1.0;
        }
        if (this == ZN) {
            return k % 1.0;
        }
        if (this == ZP) {
            return 1.0 - k % 1.0;
        }
        return 0.0;
    }

    public boolean isTunnelAhead(World world, int i, int j, int k) {
        Material aboveMaterial;
        IBlockState state = Orientation.getState(world, i + this._i, j + 1, k + this._k);
        return Orientation.isFullEmpty(state) && (aboveMaterial = Orientation.getBlock(world, i + this._i, j + 2, k + this._k).func_149688_o()) != null && Orientation.isSolid(aboveMaterial);
    }

    public static HashSet<Orientation> getClimbingOrientations(EntityPlayer p, boolean orthogonals, boolean diagonals) {
        float rotation = p.field_70177_z % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if (_getClimbingOrientationsHashSet == null) {
            _getClimbingOrientationsHashSet = new HashSet();
        } else {
            _getClimbingOrientationsHashSet.clear();
        }
        if (orthogonals) {
            NZ.addTo(rotation);
            PZ.addTo(rotation);
            ZN.addTo(rotation);
            ZP.addTo(rotation);
        }
        if (diagonals) {
            NP.addTo(rotation);
            PN.addTo(rotation);
            NN.addTo(rotation);
            PP.addTo(rotation);
        }
        return _getClimbingOrientationsHashSet;
    }

    private void addTo(float rotation) {
        if (this.isRotationForClimbing(rotation)) {
            _getClimbingOrientationsHashSet.add(this);
        }
    }

    public boolean isFeetLadderSubstitute(World world, int bi, int j, int bk) {
        int i = bi + this._i;
        int k = bk + this._k;
        return this.isLadderSubstitute(world, i, j, k, 1) > 0 || this.isLadderSubstitute(world, i, j, k, 0) > 0;
    }

    public boolean isHandsLadderSubstitute(World world, int bi, int j, int bk) {
        int i = bi + this._i;
        int k = bk + this._k;
        return this.isLadderSubstitute(world, i, j, k, 1) > 0 || this.isLadderSubstitute(world, i, j, k, 0) > 0 || this.isLadderSubstitute(world, i, j, k, -1) > 0;
    }

    private int isLadderSubstitute(World worldObj, int i, int j, int k, int halfOffset) {
        world = worldObj;
        remote_i = i;
        all_j = j;
        remote_k = k;
        all_offset = 0;
        return this.isLadderSubstitute(halfOffset, null);
    }

    public void seekClimbGap(float rotation, World world, int i, double id, double jhd, int k, double kd, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, HandsClimbing[] inout_handsClimbing, FeetClimbing[] inout_feetClimbing, ClimbGap out_handsClimbGap, ClimbGap out_feetClimbGap) {
        if (this.isRotationForClimbing(rotation)) {
            this.initialize(world, i, id, jhd, k, kd);
            inout_handsClimbing[0] = inout_handsClimbing[0].max(this.handsClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_handsClimbGap, _climbGapOuterTemp);
            inout_feetClimbing[0] = inout_feetClimbing[0].max(this.feetClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_feetClimbGap, _climbGapOuterTemp);
        }
    }

    private HandsClimbing handsClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(3.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        HandsClimbing result = HandsClimbing.None;
        int gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0) {
            result = jh_offset > 1.0 - (double)_handClimbingHoldGap ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.None, out_climbGap, _climbGapTemp);
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = jh_offset < (double)_handClimbingHoldGap ? result.max(HandsClimbing.BottomHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(-1, _climbGapTemp);
        if (!(gap <= 0 || isCrawling && gap > 1)) {
            result = !isClimbCrawling && gap > 2 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (isClimbCrawling && gap > 1 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (jh_offset < (double)_handClimbingHoldGap ? (grabType == 2 ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp)) : (grabType == 2 ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp))));
        }
        if ((gap = this.isLadderSubstitute(-2, _climbGapTemp)) > 0 && !isCrawling && (gap > 2 && !isCrawlClimbing || grabType == 2 || gap > 1 && isClimbCrawling)) {
            result = jh_offset < (double)_handClimbingHoldGap && !isClimbCrawling ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : (isClimbCrawling ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp));
        }
        return result;
    }

    private FeetClimbing feetClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(0.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        FeetClimbing result = FeetClimbing.None;
        int gap = this.isLadderSubstitute(2, _climbGapTemp);
        if (gap > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0 && !isCrawling) {
            result = gap > 3 && !isClimbCrawling ? (!isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : ((isClimbCrawling || isCrawlClimbing) && gap > 1 ? (isCrawlClimbing ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp)) : (gap > 2 ? (!isClimbCrawling ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.TopWithHands, out_climbGap, _climbGapTemp)));
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = gap > 3 && !isCrawling && !isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : (gap > 2 && !isCrawling ? (!isClimbCrawling ? (jh_offset < (double)_handClimbingHoldGap ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.SlowUpWithSinkWithoutHands, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : (jh_offset < 1.0 - (double)_handClimbingHoldGap ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.BaseHold, out_climbGap, _climbGapTemp)));
        }
        if (this.isLadderSubstitute(-1, _climbGapTemp) > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        if (isCrawlClimbing || isCrawling) {
            result = result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp);
        }
        return result;
    }

    private int isLadderSubstitute(int local_Offset, ClimbGap out_climbGap) {
        int gap;
        Orientation.initializeLocal(local_Offset);
        if (local_half == 1) {
            if (this.hasHalfHold()) {
                if (!grabRemote) {
                    boolean overOverFullAccessible;
                    boolean overLadder = Orientation.isOnLadderOrVine(0) || Orientation.isOnOpenTrapDoor(0) || Orientation.isRope(0) || Orientation.isOnWallRope(0);
                    boolean overOverLadder = Orientation.isOnLadderOrVine(1) || Orientation.isOnOpenTrapDoor(1) || Orientation.isRope(1) || Orientation.isOnWallRope(1);
                    boolean overAccessible = Orientation.isBaseAccessible(1, false, true);
                    boolean overOverAccessible = Orientation.isBaseAccessible(2, false, true);
                    boolean overFullAccessible = overAccessible && this.isFullAccessible(1, grabRemote);
                    boolean bl = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(2, grabRemote);
                    gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverFullAccessible ? 5 : (crawl ? 3 : 5)) : (overOverLadder ? 5 : 1)) : 1);
                } else {
                    gap = Orientation.isBaseAccessible(0) ? (this.isUpperHalfFrontEmpty(remote_i, 0, remote_k) ? (this.isFullAccessible(1, grabRemote) ? (this.isFullExtentAccessible(2, grabRemote) ? 5 : (this.isJustLowerHalfExtentAccessible(2) ? 4 : 3)) : (this.isLowerHalfAccessible(1, grabRemote) ? 2 : 1)) : 1) : 0;
                }
            } else {
                gap = 0;
            }
        } else if (this.hasBottomHold()) {
            if (!grabRemote) {
                boolean overOverFullAccessible;
                boolean overLadder = Orientation.isOnLadderOrVine(0) || Orientation.isOnOpenTrapDoor(0) || Orientation.isRope(0) || Orientation.isOnWallRope(0);
                boolean overOverLadder = Orientation.isOnLadderOrVine(1) || Orientation.isOnOpenTrapDoor(1) || Orientation.isRope(1) || Orientation.isOnWallRope(0);
                boolean overAccessible = Orientation.isBaseAccessible(0, false, true);
                boolean overOverAccessible = Orientation.isBaseAccessible(1, false, true);
                boolean overFullAccessible = overAccessible && this.isFullAccessible(0, grabRemote);
                boolean bl = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(1, grabRemote);
                gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverAccessible ? (overOverFullAccessible ? 4 : (crawl ? 2 : 4)) : 2) : (overOverLadder ? 2 : 1)) : 1);
            } else {
                gap = Orientation.isBaseAccessible(0) ? (this.isFullAccessible(0, grabRemote) ? (this.isFullExtentAccessible(1, grabRemote) ? 4 : 2) : 1) : 0;
            }
        } else {
            gap = 0;
        }
        if (out_climbGap != null && gap > 0) {
            out_climbGap.Block = grabBlock;
            out_climbGap.Meta = grabMeta;
            out_climbGap.CanStand = gap > 3;
            out_climbGap.MustCrawl = gap > 1 && gap < 4;
            out_climbGap.Direction = this;
        }
        return gap;
    }

    private boolean hasHalfHold() {
        if (Config.isFreeBaseClimb()) {
            if (Orientation.isOnLadder(0) && this.isOnLadderFront(0)) {
                return this.setHalfGrabType(2, Orientation.getBaseBlock(0), false);
            }
            if (this.remoteLadderClimbing(0)) {
                return this.setHalfGrabType(2, Orientation.getRemoteBlock(0), true);
            }
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            IBlockState state = Orientation.getRopeState(0);
            if (state != null && this.isHeadedToRope()) {
                return this.setHalfGrabType(2, state, false);
            }
            state = Orientation.getAnchorState(0);
            if (state != null && this.isOnAnchorFront(0)) {
                return this.setHalfGrabType(1, state, false);
            }
        }
        IBlockState remoteState = Orientation.getRemoteBlockState(0);
        if (Orientation.isEmpty(base_i, 0, base_k) && remoteState == Block.func_149684_b((String)"iron_bars") && this.headedToFrontWall(remote_i, 0, remote_k, remoteState)) {
            return this.setHalfGrabType(1, remoteState);
        }
        IBlockState wallId = Orientation.getWallBlockId(base_i, 0, base_k);
        if (wallId == Block.func_149684_b((String)"iron_bars") && this.headedToBaseWall(0, wallId)) {
            return this.setHalfGrabType(1, wallId, false);
        }
        if (wallId != null && this.isOnMiddleLadderFront(0)) {
            return this.setHalfGrabType(2, remoteState, false);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            IBlockState remoteBelowState;
            if (Orientation.isFence(remoteState) && this.headedToFrontWall(remote_i, 0, remote_k, remoteState)) {
                if (!Orientation.isFence(Orientation.getBaseBlockState(0))) {
                    return this.setHalfGrabType(1, remoteState);
                }
                if (this.headedToFrontSideWall(remote_i, 0, remote_k, remoteState)) {
                    return this.setHalfGrabType(1, remoteState);
                }
            }
            if (Orientation.isFence(remoteBelowState = Orientation.getRemoteBlockState(-1)) && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowState)) {
                if (!Orientation.isFence(Orientation.getBaseBlockState(-1))) {
                    return this.setHalfGrabType(1, remoteState);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, remoteBelowState)) {
                    return this.setHalfGrabType(1, remoteState);
                }
            }
            if (Orientation.isFence(wallId) && this.headedToBaseWall(0, wallId)) {
                return this.setHalfGrabType(1, wallId, false);
            }
            IBlockState belowWallId = Orientation.getWallBlockId(base_i, -1, base_k);
            if (Orientation.isFence(belowWallId) && this.headedToBaseWall(-1, belowWallId)) {
                return this.setHalfGrabType(1, belowWallId, false);
            }
            if (remoteState == Block.func_149684_b((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteState, 0)) {
                return this.setHalfGrabType(1, remoteState);
            }
            if (remoteBelowState == Block.func_149684_b((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteBelowState, -1)) {
                return this.setHalfGrabType(1, remoteBelowState);
            }
        }
        if (Orientation.isBottomHalfBlock(remoteState) || Orientation.isStairCompact(remoteState) && this.isBottomStairCompactNotBack(remoteState) && (!Orientation.isStairCompact(Orientation.getBaseBlockState(-1)) || !this.isBottomStairCompactFront(Orientation.getBaseBlockState(-1)))) {
            return this.setHalfGrabType(1, remoteState);
        }
        if (Orientation.isTrapDoor(remoteState) && Orientation.isClosedTrapDoor(remoteState)) {
            return this.setHalfGrabType(1, remoteState);
        }
        IBlockState baseState = Orientation.getBaseBlockState(0);
        if (Orientation.isTrapDoor(baseState) && !Orientation.isClosedTrapDoor(baseState)) {
            return this.setHalfGrabType(1, baseState, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseState) && this.isASGrapplingHookFront(baseState)) {
                return this.setHalfGrabType(1, baseState, false);
            }
            if (Orientation.isASRope(remoteState) && this.rotate(180).isASGrapplingHookFront(remoteState)) {
                return this.setHalfGrabType(1, remoteState, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
        }
        return this.setHalfGrabType(0);
    }

    private boolean hasBottomHold() {
        IBlockState belowWallState;
        if (Config.isFreeBaseClimb()) {
            if (Orientation.isOnLadder(-1) && this.isOnLadderFront(-1)) {
                return this.setBottomGrabType(2, Orientation.getBaseBlock(-1), false);
            }
            if (Orientation.isOnLadder(0) && this.isOnLadderFront(0)) {
                return this.setBottomGrabType(2, Orientation.getBaseBlock(0), false);
            }
            if (this.remoteLadderClimbing(-1)) {
                return this.setBottomGrabType(2, Orientation.getRemoteBlock(-1), true);
            }
            if (this.remoteLadderClimbing(0)) {
                return this.setBottomGrabType(2, Orientation.getRemoteBlock(0), true);
            }
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            IBlockState state = Orientation.getRopeState(-1);
            if (state != null && this.isHeadedToRope() || (state = Orientation.getRopeState(0)) != null && this.isHeadedToRope()) {
                return this.setBottomGrabType(2, state, false);
            }
            state = Orientation.getAnchorState(-1);
            if (state != null && this.isOnAnchorFront(-1) || (state = Orientation.getAnchorState(0)) != null && this.isOnAnchorFront(0)) {
                return this.setBottomGrabType(1, state, false);
            }
        }
        IBlockState remoteState = Orientation.getRemoteBlockState(0);
        IBlockState remoteBelowState = Orientation.getRemoteBlockState(-1);
        boolean remoteLowerHalfEmpty = this.isLowerHalfFrontFullEmpty(remote_i, 0, remote_k);
        if (SmartMovingOptions.hasRedPowerWire) {
            int coverSides;
            int coverSides2;
            if (Orientation.isRedPowerWire(remoteBelowState) && (this.isRedPowerWireFullFront(coverSides2 = Orientation.getRpCoverSides(remote_i, -1, remote_k)) || Orientation.isRedPowerWireTop(coverSides2)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowState);
            }
            if (Orientation.isRedPowerWire(remoteState) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, 0, remote_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowState);
            }
            IBlockState baseState = Orientation.getBaseBlockState(-1);
            if (Orientation.isRedPowerWire(baseState) && this.isRedPowerWireFullBack(coverSides = Orientation.getRpCoverSides(base_i, -1, base_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowState);
            }
            if (Orientation.isRedPowerWire(remoteBelowState)) {
                return false;
            }
        }
        if (Orientation.isEmpty(base_i, -1, base_k) && remoteBelowState == Block.func_149684_b((String)"iron_bars") && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowState)) {
            return this.setBottomGrabType(1, remoteBelowState);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            IBlockState baseBelowState = Orientation.getBaseBlockState(-1);
            if (Orientation.isFence(remoteBelowState) && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowState)) {
                if (!Orientation.isFence(baseBelowState)) {
                    return this.setBottomGrabType(1, remoteBelowState);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, remoteBelowState)) {
                    return this.setBottomGrabType(1, remoteBelowState);
                }
            }
            if (remoteBelowState == Block.func_149684_b((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteBelowState, -1)) {
                return this.setHalfGrabType(1, remoteBelowState);
            }
            if (remoteState == Block.func_149684_b((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteState, 0)) {
                return this.setHalfGrabType(1, remoteState);
            }
        }
        if ((belowWallState = Orientation.getWallBlockId(base_i, -1, base_k)) != null) {
            if (Orientation.isEmpty(base_i - this._i, 0, base_k - this._k) && Orientation.isEmpty(base_i - this._i, -1, base_k - this._k)) {
                if (belowWallState == Block.func_149684_b((String)"iron_bars") && this.headedToBaseWall(-1, belowWallState)) {
                    return this.setBottomGrabType(1, belowWallState, false);
                }
                if (this.isOnMiddleLadderFront(-1)) {
                    return this.setHalfGrabType(2, remoteState, false);
                }
                if (this.headedToBaseGrabWall(-1, belowWallState)) {
                    return this.setBottomGrabType(1, belowWallState, false);
                }
            }
            if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && Orientation.isFence(belowWallState) && this.headedToBaseWall(-1, belowWallState)) {
                return this.setBottomGrabType(1, belowWallState, false);
            }
            return false;
        }
        if (!(!remoteLowerHalfEmpty || !Orientation.isBaseAccessible(-1, true, false) || !this.isUpperHalfFrontAnySolid(remote_i, -1, remote_k) || Orientation.isBottomHalfBlock(remoteBelowState) || Orientation.isStairCompact(remoteBelowState) && this.isBottomStairCompactFront(remoteBelowState) || Orientation.isDoor(remoteBelowState) && !Orientation.isDoorTop(remoteBelowState) || Orientation.isDoor(Orientation.getBaseBlockState(0)) && this.isDoorFrontBlocked(base_i, 0, base_k) || !((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && Orientation.isFence(Orientation.getRemoteBlockState(-1)))) {
            return this.setBottomGrabType(1, remoteBelowState);
        }
        if (Orientation.isStairCompact(remoteState) && Orientation.isTopStairCompact(remoteState) && !this.isTopStairCompactBack(remoteState) && Orientation.isUpperHalfFrontFullSolid(remote_i, -1, remote_k)) {
            return this.setBottomGrabType(1, remoteBelowState);
        }
        IBlockState baseBelowState = Orientation.getBaseBlockState(-1);
        if (Orientation.isTrapDoor(baseBelowState) && !Orientation.isClosedTrapDoor(baseBelowState)) {
            return this.setBottomGrabType(1, baseBelowState, false);
        }
        if (Orientation.isDoor(baseBelowState) && Orientation.isDoorTop(baseBelowState) && this.isDoorFrontBlocked(base_i, -1, base_k) && Orientation.isBaseAccessible(0)) {
            return this.setBottomGrabType(1, baseBelowState, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseBelowState) && this.isASGrapplingHookFront(Orientation.getBaseBlockState(0))) {
                return this.setBottomGrabType(1, baseBelowState, false);
            }
            IBlockState baseState = Orientation.getBaseBlockState(0);
            if (Orientation.isASRope(baseState) && this.isASGrapplingHookFront(baseState)) {
                return this.setBottomGrabType(1, baseState, false);
            }
            if (Orientation.isASRope(remoteBelowState) && this.rotate(180).isASGrapplingHookFront(remoteBelowState)) {
                return this.setHalfGrabType(1, remoteBelowState, true);
            }
            if (Orientation.isASRope(remoteState) && this.rotate(180).isASGrapplingHookFront(remoteState)) {
                return this.setHalfGrabType(1, remoteState, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
            meta = this.baseVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.func_149684_b((String)"vine"), false, meta);
            }
        }
        return this.setBottomGrabType(0);
    }

    private boolean setHalfGrabType(int type) {
        return this.setHalfGrabType(type, (Block)null);
    }

    private boolean setHalfGrabType(int type, Block block) {
        return this.setHalfGrabType(type, block, true);
    }

    private boolean setHalfGrabType(int type, IBlockState state) {
        return this.setHalfGrabType(type, state.func_177230_c());
    }

    private boolean setHalfGrabType(int type, Block block, boolean remote) {
        return this.setHalfGrabType(type, block, remote, -1);
    }

    private boolean setHalfGrabType(int type, IBlockState state, boolean remote) {
        return this.setHalfGrabType(type, state.func_177230_c(), remote);
    }

    private boolean setHalfGrabType(int type, Block block, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isUpperHalfFrontEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isUpperHalfFrontEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, block, remote, hasGrab, metaClimb);
    }

    private boolean setBottomGrabType(int type) {
        return this.setBottomGrabType(type, (Block)null);
    }

    private boolean setBottomGrabType(int type, Block block) {
        return this.setBottomGrabType(type, block, true);
    }

    private boolean setBottomGrabType(int type, IBlockState state) {
        return this.setBottomGrabType(type, state.func_177230_c());
    }

    private boolean setBottomGrabType(int type, Block block, boolean remote) {
        return this.setBottomGrabType(type, block, remote, -1);
    }

    private boolean setBottomGrabType(int type, IBlockState state, boolean remote) {
        return this.setBottomGrabType(type, state.func_177230_c(), remote);
    }

    private boolean setBottomGrabType(int type, Block block, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isLowerHalfFrontFullEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isLowerHalfFrontFullEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, block, remote, hasGrab, metaClimb);
    }

    private static boolean setGrabType(int type, Block block, boolean remote, boolean hasGrab, int metaClimb) {
        grabRemote = remote;
        grabType = hasGrab ? type : 0;
        grabBlock = block;
        grabMeta = metaClimb;
        return hasGrab;
    }

    private boolean setClimbingAngles() {
        switch (this._i) {
            case -1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(135.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(90.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(45.0f);
                    }
                }
                break;
            }
            case 0: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(180.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(0.0f, 360.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(0.0f);
                    }
                }
                break;
            }
            case 1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(225.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(270.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(315.0f);
                    }
                }
            }
        }
        return false;
    }

    private boolean setClimbingAngles(float directionAngle) {
        this._directionAngle = directionAngle;
        float halfAreaAngle = (this._isDiagonal ? (Float)Orientation.Config._freeClimbingDiagonalDirectionAngle.value : (Float)Orientation.Config._freeClimbingOrthogonalDirectionAngle.value).floatValue() / 2.0f;
        return this.setClimbingAngles(directionAngle - halfAreaAngle, directionAngle + halfAreaAngle);
    }

    private boolean setClimbingAngles(float mimimumClimbingAngle, float maximumClimbingAngle) {
        if (mimimumClimbingAngle < 0.0f) {
            mimimumClimbingAngle += 360.0f;
        }
        if (maximumClimbingAngle > 360.0f) {
            maximumClimbingAngle -= 360.0f;
        }
        this._mimimumClimbingAngle = mimimumClimbingAngle;
        this._maximumClimbingAngle = maximumClimbingAngle;
        return mimimumClimbingAngle != maximumClimbingAngle;
    }

    private boolean isWithinAngle(float minimumRotation, float maximumRotation) {
        return Orientation.isWithinAngle(this._directionAngle, minimumRotation, maximumRotation);
    }

    private boolean isRotationForClimbing(float rotation) {
        return Orientation.isWithinAngle(rotation, this._mimimumClimbingAngle, this._maximumClimbingAngle);
    }

    private static boolean isWithinAngle(float rotation, float minimumRotation, float maximumRotation) {
        if (minimumRotation > maximumRotation) {
            return rotation >= minimumRotation || rotation <= maximumRotation;
        }
        return rotation >= minimumRotation && rotation <= maximumRotation;
    }

    private int baseVineClimbing(int j_offset) {
        boolean result = Orientation.isOnVine(j_offset);
        if (result) {
            result = this.isOnVineFront(j_offset);
            if (result) {
                return 0;
            }
            if (this.baseVineClimbing(j_offset, PZ) || this.baseVineClimbing(j_offset, NZ) || this.baseVineClimbing(j_offset, ZP) || this.baseVineClimbing(j_offset, ZN)) {
                return 1;
            }
        }
        return -1;
    }

    private boolean baseVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        return orientation.rotate(180).hasVineOrientation(world, base_i, local_offset + j_offset, base_k) && orientation.getHorizontalBorderGap() >= 0.65;
    }

    private boolean remoteLadderClimbing(int j_offset) {
        return Orientation.isBehindLadder(j_offset) && this.isOnLadderBack(j_offset);
    }

    private int remoteVineClimbing(int j_offset) {
        if (Orientation.isBehindVine(j_offset) && this.isOnVineBack(j_offset)) {
            return 0;
        }
        if (this.remoteVineClimbing(j_offset, PZ) || this.remoteVineClimbing(j_offset, NZ) || this.remoteVineClimbing(j_offset, ZP) || this.remoteVineClimbing(j_offset, ZN)) {
            return 1;
        }
        return -1;
    }

    private boolean remoteVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        int i = base_i - orientation._i;
        int k = base_k - orientation._k;
        return Orientation.isVine(Orientation.getBlockState(i, j_offset, k)) && orientation.hasVineOrientation(world, i, local_offset + j_offset, k) && orientation.getHorizontalBorderGap() >= (double)0.65f;
    }

    private static boolean isOnLadder(int j_offset) {
        IBlockState state = Orientation.getBaseBlockState(j_offset);
        if (Orientation.isLadder(state)) {
            return true;
        }
        if (Orientation.isVine(state)) {
            return false;
        }
        return Orientation.isClimbable(world, base_i, local_offset + j_offset, base_k);
    }

    private static boolean isBehindLadder(int j_offset) {
        IBlockState state = Orientation.getRemoteBlockState(j_offset);
        if (Orientation.isLadder(state)) {
            return true;
        }
        if (Orientation.isVine(state)) {
            return false;
        }
        return Orientation.isClimbable(world, remote_i, local_offset + j_offset, remote_k);
    }

    private static boolean isOnVine(int j_offset) {
        return Orientation.isVine(Orientation.getBaseBlockState(j_offset));
    }

    private static boolean isBehindVine(int j_offset) {
        return Orientation.isVine(Orientation.getRemoteBlockState(j_offset));
    }

    private static boolean isOnLadderOrVine(int j_offset) {
        return Orientation.isLadderOrVine(Orientation.getBaseBlockState(j_offset)) || grabBlock == Block.func_149684_b((String)"vine");
    }

    public static boolean isLadder(IBlockState state) {
        return state.func_177230_c() == Block.func_149684_b((String)"ladder");
    }

    public static boolean isVine(IBlockState state) {
        return state.func_177230_c() == Block.func_149684_b((String)"vine");
    }

    public static boolean isLadderOrVine(IBlockState state) {
        return Orientation.isLadder(state) || Orientation.isVine(state) || Orientation.isBlockOfType(state, _ladderKitLadderTypes);
    }

    public static boolean isKnownLadder(IBlockState state) {
        return Orientation.isLadder(state) || Orientation.isBlockOfType(state, _ladderKitLadderTypes);
    }

    public static boolean isClimbable(World world, int i, int j, int k) {
        Block block = Orientation.getBlock(world, i, j, k);
        return block != null && block.isLadder((IBlockAccess)world, new BlockPos(i, j, k), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
    }

    private boolean isOnLadderFront(int j_offset) {
        return this.hasLadderOrientation(base_i, j_offset, base_k);
    }

    private boolean isOnLadderBack(int j_offset) {
        return this.rotate(180).hasLadderOrientation(remote_i, j_offset, remote_k);
    }

    private boolean isOnVineFront(int j_offset) {
        return this.hasVineOrientation(world, base_i, local_offset + j_offset, base_k);
    }

    private boolean isOnVineBack(int j_offset) {
        return this.rotate(180).hasVineOrientation(world, remote_i, local_offset + j_offset, remote_k);
    }

    private boolean isOnMiddleLadderFront(int j_offset) {
        switch (Orientation.getCarpentersBlockData(base_i, j_offset, base_k)) {
            case 0: {
                if (this == ZN) {
                    return Orientation.isTopHalf(base_kd);
                }
                if (this != ZP) break;
                return !Orientation.isTopHalf(base_kd);
            }
            case 1: {
                if (this == NZ) {
                    return Orientation.isTopHalf(base_id);
                }
                if (this != PZ) break;
                return !Orientation.isTopHalf(base_id);
            }
        }
        return false;
    }

    private static int getCarpentersBlockData(int i, int j_offset, int k) {
        IBlockState state;
        TileEntity entity;
        if (Orientation.isBlockOfType(Orientation.getBlockState(i, j_offset, k), _blockCarpentersLadder) && (entity = (state = Orientation.getState(world, i, j_offset, k)).func_177230_c().createTileEntity(world, state)) != null) {
            return (Integer)Reflect.Invoke(_carpentersBlockPropertiesGetData, null, entity);
        }
        return -1;
    }

    public static Orientation getKnownLadderOrientation(World world, int i, int j, int k) {
        IBlockState state = Orientation.getState(world, i, j, k);
        EnumFacing facing = Orientation.getValue(state, BlockLadder.field_176382_a);
        return FacingToOrientation.get(facing);
    }

    public boolean hasVineOrientation(World world, int i, int j, int k) {
        IBlockState state = Orientation.getState(world, i, j, k);
        if (this == NZ) {
            return Orientation.getValue(state, BlockVine.field_176278_M);
        }
        if (this == PZ) {
            return Orientation.getValue(state, BlockVine.field_176280_O);
        }
        if (this == ZP) {
            return Orientation.getValue(state, BlockVine.field_176273_b);
        }
        if (this == ZN) {
            return Orientation.getValue(state, BlockVine.field_176279_N);
        }
        return false;
    }

    private boolean hasLadderOrientation(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        EnumFacing value = Orientation.getValue(state, BlockLadder.field_176382_a);
        return value == this._facing;
    }

    public boolean isRemoteSolid(World world, int i, int j, int k) {
        return Orientation.isSolid(Orientation.getBlock(world, i + this._i, j, k + this._k).func_149688_o());
    }

    public static Orientation getOpenTrapDoorOrientation(World world, int i, int j, int k) {
        IBlockState state = Orientation.getState(world, i, j, k);
        if (!Orientation.isClosedTrapDoor(state)) {
            return FacingToOrientation.get(Orientation.getValue(state, BlockTrapDoor.field_176284_a));
        }
        return null;
    }

    private boolean isHeadedToRope() {
        int iTriple = Orientation.getTriple(base_id, base_kd);
        int kTriple = Orientation.getTriple(base_kd, base_id);
        if (iTriple > 0) {
            if (kTriple > 0) {
                return this == NN;
            }
            if (kTriple < 0) {
                return this == NP;
            }
            return this == NZ;
        }
        if (iTriple < 0) {
            if (kTriple > 0) {
                return this == PN;
            }
            if (kTriple < 0) {
                return this == PP;
            }
            return this == PZ;
        }
        if (kTriple > 0) {
            return this == ZN;
        }
        if (kTriple < 0) {
            return this == ZP;
        }
        return this == ZZ;
    }

    private boolean isOnAnchorFront(int j_offset) {
        return false;
    }

    private static IBlockState getRopeState(int j_offset) {
        IBlockState state = Orientation.getBaseBlockState(j_offset);
        if (Orientation.isRope(state.func_177230_c())) {
            return state;
        }
        return null;
    }

    private static boolean isRope(int j_offset) {
        return Orientation.getRopeState(j_offset) != null;
    }

    private static boolean isRope(Block block) {
        return SmartMovingOptions.hasBetterThanWolves && Orientation.hasBlockName(block, "tile.fcRopeBlock") || SmartMovingOptions.hasRopesPlus && Orientation.hasBlockName(block, "tile.blockRopeCentral");
    }

    private static IBlockState getAnchorState(int j_offset) {
        IBlockState state = Orientation.getBaseBlockState(j_offset);
        if (Orientation.isAnchor(state)) {
            return state;
        }
        return null;
    }

    private static boolean isAnchor(IBlockState state) {
        return Orientation.hasBlockName(state.func_177230_c(), "tile.fcAnchor");
    }

    private static boolean isOnWallRope(int j_offset) {
        return (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(Orientation.getBaseBlockState(j_offset));
    }

    private static boolean isASRope(IBlockState state) {
        return Orientation.hasBlockName(state.func_177230_c(), "tile.blockRope");
    }

    private static boolean isASGrapplingHook(IBlockState state) {
        return Orientation.hasBlockName(state.func_177230_c(), "tile.blockGrHk");
    }

    private boolean isASGrapplingHookFront(IBlockState state) {
        return false;
    }

    private static boolean isOnOpenTrapDoor(int j_offset) {
        IBlockState state = Orientation.getBaseBlockState(j_offset);
        return Orientation.isTrapDoor(state) && !Orientation.isClosedTrapDoor(state);
    }

    private boolean isTrapDoorFront(IBlockState state) {
        return this._facings.contains(Orientation.getValue(state, BlockTrapDoor.field_176284_a));
    }

    private boolean isBottomStairCompactNotBack(IBlockState state) {
        return !Orientation.isTopStairCompact(state) && !this.isStairCompactBack(state);
    }

    private boolean isBottomStairCompactFront(IBlockState state) {
        return !Orientation.isTopStairCompact(state) && this.isStairCompactFront(state);
    }

    private boolean isTopStairCompactFront(IBlockState state) {
        return Orientation.isTopStairCompact(state) && this.isStairCompactFront(state);
    }

    private boolean isTopStairCompactBack(IBlockState state) {
        return Orientation.isTopStairCompact(state) && this.isStairCompactBack(state);
    }

    private boolean isStairCompactFront(IBlockState state) {
        EnumFacing facing = Orientation.getValue(state, BlockStairs.field_176309_a);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)Orientation.getValue(state, BlockStairs.field_176310_M);
        if (this == NZ) {
            return Orientation.north(facing) && Orientation.outer_left(shape) || Orientation.south(facing) && Orientation.outer_right(shape) || Orientation.west(facing) && (Orientation.straight(shape) || Orientation.outer_right(shape) || Orientation.outer_left(shape));
        }
        if (this == PZ) {
            return Orientation.north(facing) && Orientation.outer_right(shape) || Orientation.south(facing) && Orientation.outer_left(shape) || Orientation.east(facing) && (Orientation.straight(shape) || Orientation.outer_right(shape) || Orientation.outer_left(shape));
        }
        if (this == ZP) {
            return Orientation.east(facing) && Orientation.outer_right(shape) || Orientation.west(facing) && Orientation.outer_left(shape) || Orientation.south(facing) && (Orientation.straight(shape) || Orientation.outer_right(shape) || Orientation.outer_left(shape));
        }
        if (this == ZN) {
            return Orientation.east(facing) && Orientation.outer_left(shape) || Orientation.west(facing) && Orientation.outer_right(shape) || Orientation.north(facing) && (Orientation.straight(shape) || Orientation.outer_right(shape) || Orientation.outer_left(shape));
        }
        if (this == PN) {
            return Orientation.south(facing) && Orientation.outer_left(shape) || Orientation.west(facing) && Orientation.outer_right(shape) || Orientation.east(facing) && !Orientation.inner_right(shape) || Orientation.north(facing) && !Orientation.inner_left(shape);
        }
        if (this == PP) {
            return Orientation.north(facing) && Orientation.outer_right(shape) || Orientation.west(facing) && Orientation.outer_left(shape) || Orientation.east(facing) && !Orientation.inner_left(shape) || Orientation.south(facing) && !Orientation.inner_right(shape);
        }
        if (this == NN) {
            return Orientation.east(facing) && Orientation.outer_left(shape) || Orientation.south(facing) && Orientation.outer_right(shape) || Orientation.north(facing) && !Orientation.inner_right(shape) || Orientation.west(facing) && !Orientation.inner_left(shape);
        }
        if (this == NP) {
            return Orientation.east(facing) && Orientation.outer_right(shape) || Orientation.north(facing) && Orientation.outer_left(shape) || Orientation.south(facing) && !Orientation.inner_left(shape) || Orientation.west(facing) && !Orientation.inner_right(shape);
        }
        return false;
    }

    private boolean isStairCompactBack(IBlockState state) {
        EnumFacing facing = Orientation.getValue(state, BlockStairs.field_176309_a);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)Orientation.getValue(state, BlockStairs.field_176310_M);
        if (this == NZ) {
            return Orientation.north(facing) && Orientation.inner_right(shape) || Orientation.south(facing) && Orientation.inner_left(shape) || Orientation.east(facing) && (Orientation.straight(shape) || Orientation.inner_left(shape) || Orientation.inner_right(shape));
        }
        if (this == PZ) {
            return Orientation.north(facing) && Orientation.inner_left(shape) || Orientation.south(facing) && Orientation.inner_right(shape) || Orientation.west(facing) && (Orientation.straight(shape) || Orientation.inner_left(shape) || Orientation.inner_right(shape));
        }
        if (this == ZP) {
            return Orientation.east(facing) && Orientation.inner_left(shape) || Orientation.west(facing) && Orientation.inner_right(shape) || Orientation.north(facing) && (Orientation.straight(shape) || Orientation.inner_left(shape) || Orientation.inner_right(shape));
        }
        if (this == ZN) {
            return Orientation.east(facing) && Orientation.inner_right(shape) || Orientation.west(facing) && Orientation.inner_left(shape) || Orientation.south(facing) && (Orientation.straight(shape) || Orientation.inner_left(shape) || Orientation.inner_right(shape));
        }
        if (this == PN) {
            return Orientation.east(facing) && Orientation.inner_right(shape) || Orientation.north(facing) && Orientation.inner_left(shape) || Orientation.south(facing) && !Orientation.outer_left(shape) || Orientation.west(facing) && !Orientation.outer_right(shape);
        }
        if (this == PP) {
            return Orientation.east(facing) && Orientation.inner_left(shape) || Orientation.south(facing) && Orientation.inner_right(shape) || Orientation.north(facing) && !Orientation.outer_right(shape) || Orientation.west(facing) && !Orientation.outer_left(shape);
        }
        if (this == NN) {
            return Orientation.north(facing) && Orientation.inner_right(shape) || Orientation.west(facing) && Orientation.inner_left(shape) || Orientation.east(facing) && !Orientation.outer_left(shape) || Orientation.south(facing) && !Orientation.outer_right(shape);
        }
        if (this == NP) {
            return Orientation.south(facing) && Orientation.inner_left(shape) || Orientation.west(facing) && Orientation.inner_right(shape) || Orientation.east(facing) && !Orientation.outer_right(shape) || Orientation.north(facing) && !Orientation.outer_left(shape);
        }
        return false;
    }

    private static boolean outer_left(BlockStairs.EnumShape shape) {
        return shape == BlockStairs.EnumShape.OUTER_LEFT;
    }

    private static boolean inner_left(BlockStairs.EnumShape shape) {
        return shape == BlockStairs.EnumShape.INNER_LEFT;
    }

    private static boolean straight(BlockStairs.EnumShape shape) {
        return shape == BlockStairs.EnumShape.STRAIGHT;
    }

    private static boolean inner_right(BlockStairs.EnumShape shape) {
        return shape == BlockStairs.EnumShape.INNER_RIGHT;
    }

    private static boolean outer_right(BlockStairs.EnumShape shape) {
        return shape == BlockStairs.EnumShape.OUTER_RIGHT;
    }

    private static boolean west(EnumFacing facing) {
        return facing == EnumFacing.WEST;
    }

    private static boolean south(EnumFacing facing) {
        return facing == EnumFacing.SOUTH;
    }

    private static boolean north(EnumFacing facing) {
        return facing == EnumFacing.NORTH;
    }

    private static boolean east(EnumFacing facing) {
        return facing == EnumFacing.EAST;
    }

    private static boolean isTopStairCompact(IBlockState state) {
        return (BlockStairs.EnumHalf)Orientation.getValue(state, BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
    }

    private static boolean isRedPowerWireTop(int coverSides) {
        return (coverSides >> 1) % 2 == 1;
    }

    private static boolean isRedPowerWireBottom(int coverSides) {
        return (coverSides >> 0) % 2 == 1;
    }

    private boolean isRedPowerWireFullFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireFullBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isFenceGateFront(IBlockState state) {
        EnumFacing facing = Orientation.getValue(state, BlockDirectional.field_176387_N);
        Orientation orientation = FacingToOrientation.get(facing);
        return this == orientation.rotate(90) || this == orientation.rotate(-90);
    }

    private boolean headedToFrontWall(int i, int j_offset, int k, IBlockState state) {
        boolean zn = this.getWallFlag(ZN, i, j_offset, k, state);
        boolean zp = this.getWallFlag(ZP, i, j_offset, k, state);
        boolean nz = this.getWallFlag(NZ, i, j_offset, k, state);
        boolean pz = this.getWallFlag(PZ, i, j_offset, k, state);
        boolean allOnNone = Orientation.getAllWallsOnNoWall(state);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        return this.headedToWall(NZ, pz) || this.headedToWall(PZ, nz) || this.headedToWall(ZN, zp) || this.headedToWall(ZP, zn);
    }

    private boolean headedToFrontSideWall(int i, int j_offset, int k, IBlockState state) {
        boolean zn = this.getWallFlag(ZN, i, j_offset, k, state);
        boolean zp = this.getWallFlag(ZP, i, j_offset, k, state);
        boolean nz = this.getWallFlag(NZ, i, j_offset, k, state);
        boolean pz = this.getWallFlag(PZ, i, j_offset, k, state);
        boolean allOnNone = Orientation.getAllWallsOnNoWall(state);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToWall(NZ, zp) || this.headedToWall(PZ, zp) || this.headedToWall(ZN, pz) || this.headedToWall(ZP, pz);
            }
            return this.headedToWall(NZ, zn) || this.headedToWall(PZ, zn) || this.headedToWall(ZN, pz) || this.headedToWall(ZP, pz);
        }
        if (kTop) {
            return this.headedToWall(NZ, zp) || this.headedToWall(PZ, zp) || this.headedToWall(ZN, nz) || this.headedToWall(ZP, nz);
        }
        return this.headedToWall(NZ, zn) || this.headedToWall(PZ, zn) || this.headedToWall(ZN, nz) || this.headedToWall(ZP, nz);
    }

    private boolean headedToWall(Orientation base, boolean result) {
        if (this == base || this == base.rotate(45) || this == base.rotate(-45)) {
            return result;
        }
        return false;
    }

    private boolean headedToBaseWall(int j_offset, IBlockState state) {
        boolean zn = this.getWallFlag(ZN, base_i, j_offset, base_k, state);
        boolean zp = this.getWallFlag(ZP, base_i, j_offset, base_k, state);
        boolean nz = this.getWallFlag(NZ, base_i, j_offset, base_k, state);
        boolean pz = this.getWallFlag(PZ, base_i, j_offset, base_k, state);
        boolean allOnNone = Orientation.getAllWallsOnNoWall(state);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        boolean leaf = zn || zp || nz || pz;
        boolean coreOnly = !allOnNone && !leaf;
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToBaseWall(NN, NZ, ZN, zp, nz, pz, zn, coreOnly, leaf);
            }
            return this.headedToBaseWall(NP, NZ, ZP, zn, nz, pz, zp, coreOnly, leaf);
        }
        if (kTop) {
            return this.headedToBaseWall(PN, PZ, ZN, zp, pz, nz, zn, coreOnly, leaf);
        }
        return this.headedToBaseWall(PP, PZ, ZP, zn, pz, nz, zp, coreOnly, leaf);
    }

    private boolean headedToBaseWall(Orientation diagonal, Orientation left, Orientation right, boolean leftFront, boolean rightFrontOpposite, boolean rightFront, boolean leftFrontOpposite, boolean co, boolean leaf) {
        if (this == diagonal) {
            return leaf || co;
        }
        if (this == left) {
            return Orientation.headedToBaseWall(leftFront, rightFrontOpposite, rightFront, leftFrontOpposite, co);
        }
        if (this == right) {
            return Orientation.headedToBaseWall(rightFront, leftFrontOpposite, leftFront, rightFrontOpposite, co);
        }
        return false;
    }

    private static boolean headedToBaseWall(boolean front, boolean sideOpposite, boolean side, boolean frontOpposite, boolean coreOnly) {
        return front || sideOpposite && !side || frontOpposite && !front && !side || coreOnly;
    }

    private boolean headedToBaseGrabWall(int j_offset, IBlockState state) {
        boolean azn;
        boolean azp;
        boolean anz;
        boolean apz;
        IBlockState aboveBlock;
        boolean zn = this.getWallFlag(ZN, base_i, j_offset, base_k, state);
        boolean zp = this.getWallFlag(ZP, base_i, j_offset, base_k, state);
        boolean nz = this.getWallFlag(NZ, base_i, j_offset, base_k, state);
        boolean pz = this.getWallFlag(PZ, base_i, j_offset, base_k, state);
        boolean allOnNone = Orientation.getAllWallsOnNoWall(state);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        if (Orientation.isFullEmpty(aboveBlock = Orientation.getBlockState(base_i, j_offset + 1, base_k))) {
            apz = false;
            anz = false;
            azp = false;
            azn = false;
        } else if (Orientation.isWallBlock(aboveBlock, base_i, j_offset + 1, base_k)) {
            azn = this.getWallFlag(ZN, base_i, j_offset + 1, base_k, aboveBlock);
            azp = this.getWallFlag(ZP, base_i, j_offset + 1, base_k, aboveBlock);
            anz = this.getWallFlag(NZ, base_i, j_offset + 1, base_k, aboveBlock);
            apz = this.getWallFlag(PZ, base_i, j_offset + 1, base_k, aboveBlock);
            boolean aboveAllOnNone = Orientation.getAllWallsOnNoWall(aboveBlock);
            if (!(!aboveAllOnNone || azn || azp || anz || apz)) {
                apz = true;
                anz = true;
                azp = true;
                azn = true;
            }
        } else {
            apz = true;
            anz = true;
            azp = true;
            azn = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return Orientation.headedToBaseGrabWall(-this._i, -this._k, zp, pz, nz, zn, azp, apz, anz, azn);
            }
            return Orientation.headedToBaseGrabWall(-this._i, this._k, pz, zn, zp, nz, apz, azn, azp, anz);
        }
        if (kTop) {
            return Orientation.headedToBaseGrabWall(this._i, -this._k, nz, zp, zn, pz, anz, azp, azn, apz);
        }
        return Orientation.headedToBaseGrabWall(this._i, this._k, zn, nz, pz, zp, azn, anz, apz, azp);
    }

    private static boolean headedToBaseGrabWall(int i, int k, boolean front, boolean side, boolean frontOpposite, boolean sideOpposite, boolean aboveFront, boolean aboveSide, boolean aboveFrontOpposite, boolean aboveSideOpposite) {
        if (sideOpposite && !aboveSideOpposite && !front && !aboveFront && i == 1) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !side && !aboveSide && k == 1) {
            return true;
        }
        if (side && !aboveSide && k >= 0) {
            return true;
        }
        if (front && !aboveFront && k >= 0) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !aboveFront && i == 1 && k >= 0) {
            return true;
        }
        return sideOpposite && !aboveSideOpposite && !aboveSide && k == 1 && i >= 0;
    }

    private boolean headedToRemoteFlatWall(IBlockState state, int j_offset) {
        return !this.getWallFlag(this, remote_i, j_offset, remote_k, state) && this.getWallFlag(this.rotate(90), remote_i, j_offset, remote_k, state) && !this.getWallFlag(this.rotate(180), remote_i, j_offset, remote_k, state) && this.getWallFlag(this.rotate(-90), remote_i, j_offset, remote_k, state);
    }

    private boolean getWallFlag(Orientation direction, int i, int j_offset, int k, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockPane) {
            return ((BlockPane)block).func_150098_a(Orientation.getBlock(world, i + direction._i, j_offset, k + direction._k));
        }
        if (Orientation.isFenceBase(state)) {
            if (block instanceof BlockFence) {
                return ((BlockFence)block).func_176524_e((IBlockAccess)world, new BlockPos(i + direction._i, local_offset + j_offset, k + direction._k));
            }
            if (block instanceof BlockWall) {
                return ((BlockWall)block).func_176253_e((IBlockAccess)world, new BlockPos(i + direction._i, local_offset + j_offset, k + direction._k));
            }
            if (SmartMovingOptions.hasBetterMisc && _canConnectFenceTo != null) {
                return (Boolean)Reflect.Invoke(_canConnectFenceTo, block, world, i + direction._i, local_offset + j_offset, k + direction._k);
            }
        } else {
            if (Orientation.isFenceGate(state)) {
                return Orientation.isClosedFenceGate(state) && this.isFenceGateFront(state);
            }
            switch (Orientation.getCarpentersBlockData(i, j_offset, k)) {
                case -1: {
                    break;
                }
                case 0: {
                    if (direction._k != 0 || direction._i == 0) break;
                    return true;
                }
                case 1: {
                    if (direction._i != 0 || direction._k == 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean getAllWallsOnNoWall(IBlockState state) {
        return state.func_177230_c() instanceof BlockPane;
    }

    private static boolean isTopHalf(double d) {
        return (int)Math.abs(Math.floor(d * 2.0)) % 2 == 1;
    }

    private static int getTriple(double primary, double secondary) {
        primary = primary - Math.floor(primary) - 0.5;
        secondary = secondary - Math.floor(secondary) - 0.5;
        if (Math.abs(primary) * 2.0 < Math.abs(secondary)) {
            return 0;
        }
        if (primary > 0.0) {
            return 1;
        }
        if (primary < 0.0) {
            return -1;
        }
        return 0;
    }

    private static boolean isBottomHalfBlock(IBlockState state) {
        if (Orientation.isHalfBlock(state) && Orientation.isHalfBlockBottomMetaData(state)) {
            return true;
        }
        if (state.func_177230_c() == Block.func_149684_b((String)"bed")) {
            return true;
        }
        return SmartMovingOptions.hasBetterThanWolves && Orientation.isAnchor(state);
    }

    private static boolean isTopHalfBlock(IBlockState state) {
        return Orientation.isHalfBlock(state) && Orientation.isHalfBlockTopMetaData(state);
    }

    private static boolean isHalfBlockBottomMetaData(IBlockState state) {
        return (BlockSlab.EnumBlockHalf)Orientation.getValue(state, BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }

    private static boolean isHalfBlockTopMetaData(IBlockState state) {
        return (BlockSlab.EnumBlockHalf)Orientation.getValue(state, BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    private static boolean isHalfBlock(IBlockState state) {
        return Orientation.isBlock(state, BlockSlab.class, _knownHalfBlocks) && !((BlockSlab)state.func_177230_c()).func_149662_c();
    }

    private static boolean isStairCompact(IBlockState state) {
        return Orientation.isBlock(state, BlockStairs.class, _knownCompactStairBlocks);
    }

    private static boolean isLowerHalfEmpty(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        boolean empty = Orientation.isFullEmpty(state);
        if (!empty && Orientation.isHalfBlock(state) && Orientation.isHalfBlockTopMetaData(state)) {
            empty = true;
        }
        return empty;
    }

    private boolean isLowerHalfFrontFullEmpty(int i, int j_offset, int k) {
        int coverSides;
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        boolean empty = Orientation.isFullEmpty(state);
        if (!empty && SmartMovingOptions.hasRedPowerWire && Orientation.isRedPowerWire(state) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i, j_offset, k))) {
            empty = true;
        }
        if (empty || !SmartMovingOptions.hasBetterThanWolves || Orientation.isAnchor(state)) {
            // empty if block
        }
        if (!empty && Orientation.isStairCompact(state) && this.isTopStairCompactFront(state)) {
            empty = true;
        }
        if (!empty && Orientation.isHalfBlock(state) && Orientation.isHalfBlockTopMetaData(state)) {
            empty = true;
        }
        if (!empty && Orientation.isWallBlock(state, i, j_offset, k) && !this.headedToFrontWall(i, j_offset, k, state)) {
            empty = true;
        }
        if (!empty && Orientation.isDoor(state) && !this.rotate(180).isDoorFrontBlocked(i, j_offset, k)) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(state) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockState(j_offset))) {
            empty = true;
        }
        if (empty && Orientation.isBlockOfType(state, _ladderKitLadderTypes) && this.rotate(180).hasLadderOrientation(i, j_offset, k)) {
            empty = false;
        }
        if (!empty && Orientation.isTrapDoor(state) && (Orientation.isClosedTrapDoor(state) || !this.rotate(180).isTrapDoorFront(state))) {
            empty = true;
        }
        return empty;
    }

    private boolean isUpperHalfFrontAnySolid(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        boolean solid = Orientation.isUpperHalfFrontFullSolid(i, j_offset, k);
        if (solid && Orientation.isWallBlock(state, i, j_offset, k) && !this.headedToFrontWall(i, j_offset, k, state)) {
            solid = false;
        }
        return solid;
    }

    private static boolean isUpperHalfFrontFullSolid(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        if (state == null) {
            return false;
        }
        boolean solid = Orientation.isSolid(state.func_177230_c().func_149688_o());
        if (solid && state == Block.func_149684_b((String)"standing_sign")) {
            solid = false;
        }
        if (solid && state == Block.func_149684_b((String)"wall_sign")) {
            solid = false;
        }
        if (solid && state instanceof BlockPressurePlate) {
            solid = false;
        }
        if (solid && Orientation.isTrapDoor(state)) {
            solid = false;
        }
        if (solid && SmartMovingOptions.hasASGrapplingHook && Orientation.isASGrapplingHook(state)) {
            solid = false;
        }
        if (solid && Orientation.isOpenFenceGate(state)) {
            solid = false;
        }
        return solid;
    }

    private static boolean isFullEmpty(IBlockState state) {
        boolean empty;
        if (state == null) {
            return true;
        }
        Block block = state.func_177230_c();
        boolean bl = empty = !Orientation.isSolid(block.func_149688_o());
        if (!empty && block == Block.func_149684_b((String)"standing_sign")) {
            empty = true;
        }
        if (!empty && block == Block.func_149684_b((String)"wall_sign")) {
            empty = true;
        }
        if (!empty && block instanceof BlockPressurePlate) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASGrapplingHook(state)) {
            empty = true;
        }
        if (empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(state)) {
            empty = false;
        }
        return empty;
    }

    private static boolean isFenceBase(IBlockState state) {
        return Orientation.isBlock(state, BlockFence.class, _knownFenceBlocks) || Orientation.isBlock(state, BlockWall.class, _knownWallBlocks);
    }

    private static boolean isFence(IBlockState state) {
        return Orientation.getFenceId(state) != null;
    }

    private static IBlockState getFenceId(IBlockState state) {
        if (Orientation.isFenceBase(state) || Orientation.isClosedFenceGate(state)) {
            return state;
        }
        return null;
    }

    private static boolean isClosedFenceGate(IBlockState state) {
        return Orientation.isFenceGate(state) && !Orientation.getValue(state, BlockFenceGate.field_176466_a);
    }

    private static boolean isFenceGate(IBlockState state) {
        return Orientation.isBlock(state, BlockFenceGate.class, _knownFanceGateBlocks);
    }

    private static boolean isOpenFenceGate(IBlockState state) {
        return Orientation.isFenceGate(state) && !Orientation.getValue(state, BlockFenceGate.field_176466_a);
    }

    private static boolean isOpenTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(i, j_offset, k) && !Orientation.isClosedTrapDoor(Orientation.getBlockState(i, j_offset, k));
    }

    private static boolean isClosedTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(i, j_offset, k) && Orientation.isClosedTrapDoor(Orientation.getBlockState(i, j_offset, k));
    }

    private static boolean isTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(Orientation.getBlockState(i, j_offset, k));
    }

    public static boolean isTrapDoor(IBlockState block) {
        return Orientation.isBlock(block, BlockTrapDoor.class, _knownTrapDoorBlocks);
    }

    private static boolean isBlock(IBlockState state, Class<?> type, Block[] baseBlocks) {
        if (state == null) {
            return false;
        }
        Block block = state.func_177230_c();
        if (type != null && baseBlocks.length > 1 && Orientation.isBlockOfType(state, type)) {
            return true;
        }
        for (int i = 0; i < baseBlocks.length; ++i) {
            if (baseBlocks[i] == null || block != baseBlocks[i]) continue;
            return true;
        }
        if (type != null && Orientation.isBlockOfType(state, type)) {
            return true;
        }
        Class<?> blockType = block.getClass();
        for (int i = 0; i < baseBlocks.length; ++i) {
            if (baseBlocks[i] == null || !baseBlocks[i].getClass().isAssignableFrom(blockType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClosedTrapDoor(IBlockState state) {
        return !Orientation.getValue(state, BlockTrapDoor.field_176283_b);
    }

    private static boolean isDoor(IBlockState state) {
        return Orientation.isBlockOfType(state, BlockDoor.class);
    }

    private static boolean isDoorTop(IBlockState state) {
        return (BlockDoor.EnumDoorHalf)Orientation.getValue(state, BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER;
    }

    private boolean isDoorFrontBlocked(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        if (Orientation.isDoorTop(state)) {
            return this.isDoorFrontBlocked(i, j_offset - 1, k);
        }
        switch (Orientation.getDoorFacing(state)) {
            case SOUTH: {
                return this._k < 0;
            }
            case WEST: {
                return this._i > 0;
            }
            case NORTH: {
                return this._k > 0;
            }
            case EAST: {
                return this._i < 0;
            }
        }
        return true;
    }

    private static EnumFacing getDoorFacing(IBlockState state) {
        EnumFacing facing = Orientation.getValue(state, BlockDoor.field_176520_a);
        if (!Orientation.getValue(state, BlockDoor.field_176519_b)) {
            return facing;
        }
        switch ((BlockDoor.EnumHingePosition)Orientation.getValue(state, BlockDoor.field_176521_M)) {
            case LEFT: {
                switch (facing) {
                    case EAST: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.SOUTH;
                    }
                    case SOUTH: {
                        return EnumFacing.EAST;
                    }
                }
                return facing;
            }
            case RIGHT: {
                switch (facing) {
                    case EAST: {
                        return EnumFacing.SOUTH;
                    }
                    case SOUTH: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.NORTH;
                    }
                    case NORTH: {
                        return EnumFacing.EAST;
                    }
                }
                return facing;
            }
        }
        return facing;
    }

    private static IBlockState getWallBlockId(int i, int j_offset, int k) {
        IBlockState block = Orientation.getBlockState(i, j_offset, k);
        if (Orientation.isWallBlock(block, i, j_offset, k)) {
            return block;
        }
        return null;
    }

    private static boolean isWallBlock(IBlockState state, int i, int j_offset, int k) {
        return Orientation.isBlock(state, BlockPane.class, _knownThinWallBlocks) || Orientation.isFence(state) || Orientation.isBlockOfType(state, _blockCarpentersLadder);
    }

    private static boolean isBaseAccessible(int j_offset) {
        return Orientation.isBaseAccessible(j_offset, false, false);
    }

    private static boolean isBaseAccessible(int j_offset, boolean bottom, boolean full) {
        IBlockState state = Orientation.getBaseBlockState(j_offset);
        boolean accessible = Orientation.isEmpty(base_i, j_offset, base_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(state)) {
            int coverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
            accessible = !Orientation.isRedPowerWireBottom(coverSides);
            IBlockState lowerId = Orientation.getBaseBlockState(j_offset - 1);
            if (Orientation.isRedPowerWire(lowerId)) {
                int lowerCoverSides = Orientation.getRpCoverSides(base_i, j_offset - 1, base_k);
                accessible &= !Orientation.isRedPowerWireTop(lowerCoverSides);
            }
        }
        if (!accessible && Orientation.isFullEmpty(state)) {
            accessible = true;
        }
        if (!accessible && Orientation.isOpenTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && bottom && Orientation.isClosedTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && Orientation.isWallBlock(state, base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(state)) {
            accessible = true;
        }
        if (!accessible && Orientation.isDoor(state)) {
            accessible = true;
        }
        return accessible;
    }

    private boolean isRemoteAccessible(int j_offset) {
        IBlockState remoteState;
        boolean accessible = Orientation.isEmpty(remote_i, j_offset, remote_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(remoteState = Orientation.getRemoteBlockState(j_offset))) {
            int coverSides = Orientation.getRpCoverSides(remote_i, j_offset, remote_k);
            accessible = !this.isRedPowerWireAnyFront(coverSides);
            IBlockState baseState = Orientation.getBaseBlockState(j_offset);
            if (Orientation.isRedPowerWire(baseState)) {
                int baseCoverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
                accessible &= !this.isRedPowerWireAnyBack(baseCoverSides);
            }
        }
        if (accessible) {
            IBlockState baseState = Orientation.getBaseBlockState(j_offset);
            if (Orientation.isTrapDoor(baseState)) {
                boolean bl = accessible = !this.isTrapDoorFront(baseState);
            }
            if (accessible && Orientation.isDoor(baseState)) {
                boolean bl = accessible = !this.isDoorFrontBlocked(base_i, j_offset, base_k);
            }
            if (this.remoteLadderClimbing(j_offset)) {
                accessible = false;
            }
        }
        if (!accessible && Orientation.isTrapDoor(remote_i, j_offset, remote_k)) {
            accessible = Orientation.isClosedTrapDoor(Orientation.getRemoteBlockState(j_offset));
        }
        if (!accessible) {
            remoteState = Orientation.getRemoteBlockState(j_offset);
            if (Orientation.isWallBlock(remoteState, remote_i, j_offset, remote_k) && !this.headedToFrontWall(remote_i, j_offset, remote_k, remoteState) && !Orientation.isFence(Orientation.getRemoteBlockState(j_offset - 1))) {
                accessible = true;
            }
            IBlockState remoteBelowState = Orientation.getRemoteBlockState(j_offset - 1);
            if (!(accessible || !Orientation.isFence(remoteBelowState) || this.headedToFrontWall(remote_i, j_offset - 1, remote_k, remoteBelowState) && !Orientation.isWallBlock(Orientation.getBaseBlockState(j_offset - 1), base_i, j_offset - 1, base_k) || remoteBelowState == Block.func_149684_b((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteBelowState, -1))) {
                accessible = true;
            }
            if (!accessible && Orientation.isDoor(remoteState) && !this.rotate(180).isDoorFrontBlocked(remote_i, j_offset, remote_k)) {
                accessible = true;
            }
            if ((SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(remoteState) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockState(j_offset))) {
                accessible = true;
            }
        }
        return accessible;
    }

    private boolean isAccessAccessible(int j_offset) {
        if (!this._isDiagonal) {
            return true;
        }
        return Orientation.isEmpty(remote_i, j_offset, base_k) && Orientation.isEmpty(base_i, j_offset, remote_k);
    }

    private boolean isFullExtentAccessible(int j_offset, boolean grabRemote) {
        boolean accessible = this.isFullAccessible(j_offset, grabRemote);
        if (SmartMovingOptions.hasRedPowerWire && accessible) {
            int coverSides;
            IBlockState bottomState;
            int coverSides2;
            IBlockState topState = Orientation.getRemoteBlockState(j_offset);
            if (Orientation.isRedPowerWire(topState) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, j_offset, remote_k))) {
                accessible = false;
            }
            if (Orientation.isRedPowerWire(bottomState = Orientation.getRemoteBlockState(j_offset - 1)) && Orientation.isRedPowerWireTop(coverSides = Orientation.getRpCoverSides(remote_i, j_offset - 1, remote_k))) {
                accessible = false;
            }
        }
        return accessible;
    }

    private boolean isJustLowerHalfExtentAccessible(int j_offset) {
        IBlockState remoteState = Orientation.getRemoteBlockState(j_offset);
        boolean accessible = false;
        if (!accessible) {
            accessible = Orientation.isTopHalfBlock(remoteState);
        }
        if (!accessible) {
            accessible = Orientation.isStairCompact(remoteState) && this.isTopStairCompactFront(remoteState);
        }
        return accessible;
    }

    private boolean isFullAccessible(int j_offset, boolean grabRemote) {
        if (grabRemote) {
            return Orientation.isBaseAccessible(j_offset) && this.isRemoteAccessible(j_offset) && this.isAccessAccessible(j_offset);
        }
        return Orientation.isEmpty(base_i, j_offset, base_k);
    }

    private boolean isLowerHalfAccessible(int j_offset, boolean grabRemote) {
        if (grabRemote) {
            return Orientation.isBaseAccessible(1, true, false) && this.rotate(180).isLowerHalfFrontFullEmpty(base_i, 1, base_k) && this.isLowerHalfFrontFullEmpty(remote_i, 1, remote_k);
        }
        return Orientation.isLowerHalfEmpty(base_i, j_offset, base_k);
    }

    private static boolean isEmpty(int i, int j_offset, int k) {
        return Orientation.isFullEmpty(Orientation.getBlockState(i, j_offset, k)) && !Orientation.isFence(Orientation.getBlockState(i, j_offset - 1, k));
    }

    private boolean isUpperHalfFrontEmpty(int i, int j_offset, int k) {
        IBlockState wallId;
        int coverSides;
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        boolean empty = Orientation.isFullEmpty(state);
        if (!empty) {
            if (Orientation.isBottomHalfBlock(state)) {
                empty = true;
            }
            if (!empty && Orientation.isStairCompact(state) && this.isBottomStairCompactFront(state)) {
                empty = true;
            }
        }
        if (SmartMovingOptions.hasRedPowerWire && !empty && Orientation.isRedPowerWire(state) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i, j_offset, k))) {
            empty = true;
        }
        if (!empty && Orientation.isTrapDoor(state)) {
            empty = true;
        }
        if (!(empty || (wallId = Orientation.getWallBlockId(i, j_offset, k)) == null || this.headedToFrontWall(i, j_offset, k, wallId) && !Orientation.isWallBlock(Orientation.getBlockState(i - this._i, j_offset, k - this._k), i - this._i, j_offset, k - this._k))) {
            empty = true;
        }
        if (empty && Orientation.isBlockOfType(state, _ladderKitLadderTypes) && this.rotate(180).hasLadderOrientation(i, j_offset, k)) {
            empty = false;
        }
        return empty;
    }

    private static int getRpCoverSides(int i, int j_offset, int k) {
        IBlockState state = Orientation.getBlockState(i, j_offset, k);
        TileEntity tileEntity = state.func_177230_c().createTileEntity(world, state);
        Class<?> tileEntityClass = tileEntity.getClass();
        while (!tileEntityClass.getSimpleName().equals("TileCovered")) {
            tileEntityClass = tileEntityClass.getSuperclass();
        }
        return (Integer)Reflect.GetField(tileEntityClass, tileEntity, new Name("CoverSides"));
    }

    private static boolean isRedPowerWire(IBlockState state) {
        return Orientation.hasBlockName(state.func_177230_c(), "tile.rpwire");
    }

    public static int getFiniteLiquidWater(Block block) {
        String blockName = Orientation.getBlockName(block);
        if (blockName == null) {
            return 0;
        }
        if (blockName.equals("tile.nocean")) {
            return 2;
        }
        if (blockName.equals("tile.nwater_still")) {
            return 1;
        }
        return 0;
    }

    private static boolean isSolid(Material material) {
        return material.func_76220_a() && material.func_76230_c();
    }

    private static IBlockState getBlockState(int i, int j_offset, int k) {
        return Orientation.getState(world, i, local_offset + j_offset, k);
    }

    private static Block getBaseBlock(int j_offset) {
        return Orientation.getBaseBlockState(j_offset).func_177230_c();
    }

    private static IBlockState getBaseBlockState(int j_offset) {
        return Orientation.getState(world, base_i, local_offset + j_offset, base_k);
    }

    private static boolean isBlockOfType(IBlockState state, Class<?> ... types) {
        if (types == null || state == null) {
            return false;
        }
        Class<?> blockType = state.func_177230_c().getClass();
        for (Class<?> type : types) {
            if (type == null || !type.isAssignableFrom(blockType)) continue;
            return true;
        }
        return false;
    }

    private static Block getRemoteBlock(int j_offset) {
        return Orientation.getRemoteBlockState(j_offset).func_177230_c();
    }

    private static IBlockState getRemoteBlockState(int j_offset) {
        return Orientation.getState(world, remote_i, local_offset + j_offset, remote_k);
    }

    private static boolean hasBlockName(Block block, String name) {
        String blockName = Orientation.getBlockName(block);
        return blockName != null && blockName.equals(name);
    }

    private static String getBlockName(Block block) {
        if (block == null) {
            return null;
        }
        return block.func_149739_a();
    }

    private void initialize(World w, int i, double id, double jhd, int k, double kd) {
        world = w;
        base_i = i;
        base_id = id;
        base_jhd = jhd;
        base_k = k;
        base_kd = kd;
        remote_i = i + this._i;
        remote_k = k + this._k;
    }

    private static void initializeOffset(double offset_halfs, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling) {
        crawl = isClimbCrawling || isCrawlClimbing || isCrawling;
        double offset_jhd = base_jhd + offset_halfs;
        int offset_jh = MathHelper.func_76128_c((double)offset_jhd);
        jh_offset = offset_jhd - (double)offset_jh;
        all_j = offset_jh / 2;
        all_offset = offset_jh % 2;
    }

    private static void initializeLocal(int localOffset) {
        local_halfOffset = localOffset + all_offset;
        local_half = Math.abs(local_halfOffset) % 2;
        local_offset = all_j + (local_halfOffset - local_half) / 2;
    }

    public String toString() {
        if (this == ZZ) {
            return "ZZ";
        }
        if (this == NZ) {
            return "NZ";
        }
        if (this == PZ) {
            return "PZ";
        }
        if (this == ZP) {
            return "ZP";
        }
        if (this == ZN) {
            return "ZN";
        }
        if (this == PN) {
            return "PN";
        }
        if (this == PP) {
            return "PP";
        }
        if (this == NN) {
            return "NN";
        }
        if (this == NP) {
            return "NP";
        }
        return "UNKNOWN(" + this._i + "," + this._k + ")";
    }

    static {
        Class<?> modFenceBlock = Reflect.LoadClass(Block.class, SmartMovingInstall.ModBlockFence, false);
        _canConnectFenceTo = modFenceBlock != null ? Reflect.GetMethod(modFenceBlock, new Name("canConnectFenceTo"), false, IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE) : null;
        _blockCarpentersLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersBlockLadder, false);
        if (_blockCarpentersLadder != null) {
            Class<?> carpentersBlockProperties = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersBlockProperties, false);
            Class<?> carpentersTEBaseBlock = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersTEBaseBlock, false);
            _carpentersBlockPropertiesGetData = Reflect.GetMethod(carpentersBlockProperties, SmartMovingInstall.CarpentersBlockProperties_getMetadata, carpentersTEBaseBlock);
        } else {
            _carpentersBlockPropertiesGetData = null;
        }
        _knownFanceGateBlocks = new Block[]{Block.func_149684_b((String)"fence_gate")};
        _knownFenceBlocks = new Block[]{Block.func_149684_b((String)"fence"), Block.func_149684_b((String)"nether_brick_fence")};
        _knownWallBlocks = new Block[]{Block.func_149684_b((String)"cobblestone_wall")};
        _knownHalfBlocks = new Block[]{Block.func_149684_b((String)"stone_slab"), Block.func_149684_b((String)"double_stone_slab"), Block.func_149684_b((String)"wooden_slab"), Block.func_149684_b((String)"double_wooden_slab")};
        _knownCompactStairBlocks = new Block[]{Block.func_149684_b((String)"stone_stairs"), Block.func_149684_b((String)"oak_stairs"), Block.func_149684_b((String)"dark_oak_stairs"), Block.func_149684_b((String)"brick_stairs"), Block.func_149684_b((String)"nether_brick_stairs"), Block.func_149684_b((String)"sandstone_stairs"), Block.func_149684_b((String)"stone_brick_stairs"), Block.func_149684_b((String)"birch_stairs"), Block.func_149684_b((String)"jungle_stairs"), Block.func_149684_b((String)"spruce_stairs"), Block.func_149684_b((String)"quartz_stairs"), Block.func_149684_b((String)"acacia_stairs")};
        _knownTrapDoorBlocks = new Block[]{Block.func_149684_b((String)"trapdoor")};
        _knownThinWallBlocks = new Block[]{Block.func_149684_b((String)"iron_bars"), Block.func_149684_b((String)"glass_pane")};
        Class<?> blockRopeLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.BlockRopeLadder, false);
        Class<?> blockSturdyLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.BlockSturdyLadder, false);
        _ladderKitLadderTypes = blockRopeLadder != null ? (blockSturdyLadder != null ? new Class[]{blockRopeLadder, blockSturdyLadder} : new Class[]{blockRopeLadder}) : (blockSturdyLadder != null ? new Class[]{blockSturdyLadder} : null);
    }
}

