/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.devices.TileMirror;
import thaumcraft.common.tiles.devices.TileMirrorEssentia;

@SideOnly(value=Side.CLIENT)
public class TileMirrorRenderer
extends TileEntitySpecialRenderer {
    FloatBuffer fBuffer = GLAllocation.func_74529_h((int)16);
    private static final ResourceLocation t1 = new ResourceLocation("thaumcraft", "textures/misc/tunnel.png");
    private static final ResourceLocation t2 = new ResourceLocation("thaumcraft", "textures/misc/particlefield.png");
    private static ResourceLocation mp = new ResourceLocation("thaumcraft", "textures/blocks/mirrorpane.png");
    private static ResourceLocation mpt = new ResourceLocation("thaumcraft", "textures/blocks/mirrorpanetrans.png");

    public void drawPlaneYPos(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float px = (float)TileEntityRendererDispatcher.field_147554_b;
        float py = (float)TileEntityRendererDispatcher.field_147555_c;
        float pz = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.99f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(y + (double)offset);
            float f9 = (float)((double)f8 - ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f10 = (float)((double)(f8 + f5) - ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f11 = f9 / f10;
            f11 = (float)(y + (double)offset) + f11;
            GL11.glTranslatef((float)px, (float)f11, (float)pz);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-px), (float)(-pz), (float)(-py));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72450_a * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72449_c * (double)f5 / (double)f9), (double)(-py));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)offset, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)offset, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)offset, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)offset, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void drawPlaneYNeg(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float f1 = (float)TileEntityRendererDispatcher.field_147554_b;
        float f2 = (float)TileEntityRendererDispatcher.field_147555_c;
        float f3 = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.01f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(-(y + (double)offset));
            float f9 = (float)((double)f8 + ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f10 = (float)((double)(f8 + f5) + ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f11 = f9 / f10;
            f11 = (float)(y + (double)offset) + f11;
            GL11.glTranslatef((float)f1, (float)f11, (float)f3);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-f1), (float)(-f3), (float)(-f2));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72450_a * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72449_c * (double)f5 / (double)f9), (double)(-f2));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)offset, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)offset, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)offset, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)offset, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void drawPlaneZNeg(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float px = (float)TileEntityRendererDispatcher.field_147554_b;
        float py = (float)TileEntityRendererDispatcher.field_147555_c;
        float pz = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.01f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(-(z + (double)offset));
            float f9 = (float)((double)f8 + ActiveRenderInfo.getCameraPosition().field_72449_c);
            float f10 = (float)((double)(f8 + f5) + ActiveRenderInfo.getCameraPosition().field_72449_c);
            float f11 = f9 / f10;
            f11 = (float)(z + (double)offset) + f11;
            GL11.glTranslatef((float)px, (float)py, (float)f11);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-px), (float)(-py), (float)(-pz));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72450_a * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72448_b * (double)f5 / (double)f9), (double)(-pz));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + 1.0 - (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + 1.0 - (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void drawPlaneZPos(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float px = (float)TileEntityRendererDispatcher.field_147554_b;
        float py = (float)TileEntityRendererDispatcher.field_147555_c;
        float pz = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.99f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(z + (double)offset);
            float f9 = (float)((double)f8 - ActiveRenderInfo.getCameraPosition().field_72449_c);
            float f10 = (float)((double)(f8 + f5) - ActiveRenderInfo.getCameraPosition().field_72449_c);
            float f11 = f9 / f10;
            f11 = (float)(z + (double)offset) + f11;
            GL11.glTranslatef((float)px, (float)py, (float)f11);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-px), (float)(-py), (float)(-pz));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72450_a * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72448_b * (double)f5 / (double)f9), (double)(-pz));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)p, y + 1.0 - (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + 1.0 - (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + 1.0 - (double)p, y + (double)p, z + (double)offset).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void drawPlaneXNeg(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float px = (float)TileEntityRendererDispatcher.field_147554_b;
        float py = (float)TileEntityRendererDispatcher.field_147555_c;
        float pz = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.01f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(-(x + (double)offset));
            float f9 = (float)((double)f8 + ActiveRenderInfo.getCameraPosition().field_72450_a);
            float f10 = (float)((double)(f8 + f5) + ActiveRenderInfo.getCameraPosition().field_72450_a);
            float f11 = f9 / f10;
            f11 = (float)(x + (double)offset) + f11;
            GL11.glTranslatef((float)f11, (float)py, (float)pz);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-pz), (float)(-py), (float)(-px));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72449_c * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72448_b * (double)f5 / (double)f9), (double)(-px));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + 1.0 - (double)p, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + 1.0 - (double)p, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + (double)p, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + (double)p, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void drawPlaneXPos(TileEntity tileentityendportal, double x, double y, double z, float f) {
        float px = (float)TileEntityRendererDispatcher.field_147554_b;
        float py = (float)TileEntityRendererDispatcher.field_147555_c;
        float pz = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        Random random = new Random(31100L);
        float offset = 0.99f;
        float p = 0.1875f;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(t1);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(t2);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(x + (double)offset);
            float f9 = (float)((double)f8 - ActiveRenderInfo.getCameraPosition().field_72450_a);
            float f10 = (float)((double)(f8 + f5) - ActiveRenderInfo.getCameraPosition().field_72450_a);
            float f11 = f9 / f10;
            f11 = (float)(x + (double)offset) + f11;
            GL11.glTranslatef((float)f11, (float)py, (float)pz);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.calcFloatBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.calcFloatBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 250000.0f), (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-pz), (float)(-py), (float)(-px));
            GL11.glTranslated((double)(ActiveRenderInfo.getCameraPosition().field_72449_c * (double)f5 / (double)f9), (double)(ActiveRenderInfo.getCameraPosition().field_72448_b * (double)f5 / (double)f9), (double)(-px));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = random.nextFloat() * 0.5f + 0.1f;
            float f12 = random.nextFloat() * 0.5f + 0.4f;
            float f13 = random.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + (double)p, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + (double)p, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + 1.0 - (double)p, z + 1.0 - (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x + (double)offset, y + 1.0 - (double)p, z + (double)p).func_181666_a(f11 * f7, f12 * f7, f13 * f7, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    private FloatBuffer calcFloatBuffer(float f, float f1, float f2, float f3) {
        this.fBuffer.clear();
        this.fBuffer.put(f).put(f1).put(f2).put(f3);
        this.fBuffer.flip();
        return this.fBuffer;
    }

    public void func_192841_a(TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a(te, x, y, z, partialTicks, destroyStage, alpha);
        EnumFacing dir = BlockStateUtils.getFacing(te.func_145832_p());
        boolean linked = false;
        if (te instanceof TileMirror) {
            linked = ((TileMirror)te).linked;
        }
        if (te instanceof TileMirrorEssentia) {
            linked = ((TileMirrorEssentia)te).linked;
        }
        int b = te.func_145838_q().func_185484_c(te.func_145831_w().func_180495_p(te.func_174877_v()), (IBlockAccess)te.func_145831_w(), te.func_174877_v());
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.translateFromOrientation((float)x, (float)y, (float)z, dir.ordinal(), 0.01f);
        UtilsFX.renderItemIn2D(te.func_145838_q() == BlocksTC.mirror ? "thaumcraft:blocks/mirrorframe" : "thaumcraft:blocks/mirrorframe2", 0.0625f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        if (linked && FMLClientHandler.instance().getClient().field_71439_g.func_174831_c(te.func_174877_v()) < 1024.0) {
            GL11.glPushMatrix();
            switch (dir) {
                case DOWN: {
                    this.drawPlaneYPos(te, x, y, z, partialTicks);
                    break;
                }
                case UP: {
                    this.drawPlaneYNeg(te, x, y, z, partialTicks);
                    break;
                }
                case WEST: {
                    this.drawPlaneXPos(te, x, y, z, partialTicks);
                    break;
                }
                case EAST: {
                    this.drawPlaneXNeg(te, x, y, z, partialTicks);
                    break;
                }
                case NORTH: {
                    this.drawPlaneZPos(te, x, y, z, partialTicks);
                    break;
                }
                case SOUTH: {
                    this.drawPlaneZNeg(te, x, y, z, partialTicks);
                }
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.translateFromOrientation((float)x, (float)y, (float)z, dir.ordinal(), 0.02f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.5, (double)-0.5, (double)0.0);
            UtilsFX.renderQuadCentered(mpt, 1.0f, 1.0f, 1.0f, 1.0f, b, 771, 1.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.translateFromOrientation((float)x, (float)y, (float)z, dir.ordinal(), 0.02f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.5, (double)-0.5, (double)0.0);
            UtilsFX.renderQuadCentered(mp, 1.0f, 1.0f, 1.0f, 1.0f, b, 771, 1.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    private void translateFromOrientation(float x, float y, float z, int orientation, float off) {
        if (orientation == 0) {
            GL11.glTranslatef((float)x, (float)(y + 1.0f), (float)(z + 1.0f));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 1) {
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 2) {
            GL11.glTranslatef((float)x, (float)y, (float)(z + 1.0f));
        } else if (orientation == 3) {
            GL11.glTranslatef((float)(x + 1.0f), (float)y, (float)z);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 4) {
            GL11.glTranslatef((float)(x + 1.0f), (float)y, (float)(z + 1.0f));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 5) {
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-off));
    }
}

